/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.def;

import java.util.Objects;
import kala.collection.Seq;
import kala.collection.SeqLike;
import kala.collection.immutable.ImmutableSeq;
import org.aya.concrete.stmt.decl.Decl;
import org.aya.concrete.stmt.decl.TeleDecl;
import org.aya.core.def.CtorDef;
import org.aya.core.def.DataDef;
import org.aya.core.def.GenericDef;
import org.aya.core.term.PiTerm;
import org.aya.core.term.Term;
import org.aya.generic.AyaDocile;
import org.aya.prettier.CorePrettier;
import org.aya.pretty.doc.Doc;
import org.aya.ref.DefVar;
import org.aya.util.prettier.PrettierOptions;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Def
extends AyaDocile,
GenericDef {
    @NotNull
    public static Term defType(@NotNull DefVar<? extends Def, ? extends TeleDecl<?>> defVar) {
        return PiTerm.make(Def.defTele(defVar), Def.defResult(defVar));
    }

    @NotNull
    public static ImmutableSeq<Term.Param> defTele(@NotNull DefVar<? extends Def, ? extends TeleDecl<?>> defVar) {
        if (defVar.core != null) {
            return ((Def)defVar.core).telescope();
        }
        Signature signature = ((TeleDecl)defVar.concrete).signature;
        if (!1.$assertionsDisabled && signature == null) {
            throw new AssertionError((Object)defVar.name());
        }
        return signature.param;
    }

    @NotNull
    public static Seq<CtorDef> dataBody(@NotNull DefVar<? extends DataDef, ? extends TeleDecl.DataDecl> defVar) {
        if (defVar.core != null) {
            return ((DataDef)defVar.core).body;
        }
        return ((TeleDecl.DataDecl)defVar.concrete).checkedBody;
    }

    @Contract(pure=true)
    @NotNull
    public static <T extends Term> T defResult(@NotNull DefVar<? extends Def, ? extends TeleDecl<? extends T>> defVar) {
        if (defVar.core != null) {
            return (T)((Def)defVar.core).result();
        }
        return Objects.requireNonNull(((TeleDecl)defVar.concrete).signature).result;
    }

    @NotNull
    public DefVar<? extends Def, ? extends Decl> ref();

    @NotNull
    public ImmutableSeq<Term.Param> telescope();

    @Override
    @NotNull
    default public Doc toDoc(@NotNull PrettierOptions options) {
        return new CorePrettier(options).def(this);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public record Signature<T extends Term>(@NotNull @NotNull ImmutableSeq<@NotNull Term.Param> param, @NotNull T result) implements AyaDocile
    {
        @Override
        @NotNull
        public Doc toDoc(@NotNull PrettierOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.sep((SeqLike)this.param.view().map(p -> p.toDoc(options))), Doc.symbol((String)"->"), this.result.toDoc(options)});
        }
    }
}

