/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.meta;

import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import kala.tuple.Tuple2;
import org.aya.core.meta.MetaInfo;
import org.aya.core.term.MetaTerm;
import org.aya.core.term.PiTerm;
import org.aya.core.term.SortTerm;
import org.aya.core.term.Term;
import org.aya.core.visitor.Subst;
import org.aya.generic.Constants;
import org.aya.ref.AnyVar;
import org.aya.util.Arg;
import org.aya.util.error.SourcePos;
import org.jetbrains.annotations.NotNull;

public final class Meta
implements AnyVar {
    @NotNull
    public final ImmutableSeq<Term.Param> contextTele;
    @NotNull
    public final ImmutableSeq<Term.Param> telescope;
    @NotNull
    public final String name;
    @NotNull
    public final MetaInfo info;
    @NotNull
    public final SourcePos sourcePos;
    @NotNull
    public final MutableList<Tuple2<Subst, Term>> conditions = MutableList.create();

    public SeqView<Term.Param> fullTelescope() {
        return this.contextTele.view().concat(this.telescope);
    }

    private Meta(@NotNull ImmutableSeq<Term.Param> contextTele, @NotNull ImmutableSeq<Term.Param> telescope, @NotNull String name, @NotNull MetaInfo info, @NotNull SourcePos sourcePos) {
        this.contextTele = contextTele;
        this.telescope = telescope;
        this.name = name;
        this.info = info;
        this.sourcePos = sourcePos;
    }

    @NotNull
    public static Meta from(@NotNull ImmutableSeq<Term.Param> contextTele, @NotNull String name, @NotNull SourcePos sourcePos) {
        return new Meta(contextTele, (ImmutableSeq<Term.Param>)ImmutableSeq.empty(), name, new MetaInfo.AnyType(), sourcePos);
    }

    @NotNull
    public static Meta from(@NotNull ImmutableSeq<Term.Param> contextTele, @NotNull String name, @NotNull Term result, @NotNull SourcePos sourcePos) {
        if (result instanceof PiTerm) {
            PiTerm pi = (PiTerm)result;
            MutableList buf = MutableList.create();
            MetaInfo.Result r = new MetaInfo.Result(pi.parameters((MutableList<Term.Param>)buf));
            return new Meta(contextTele, (ImmutableSeq<Term.Param>)buf.toImmutableSeq(), name, r, sourcePos);
        }
        return new Meta(contextTele, (ImmutableSeq<Term.Param>)ImmutableSeq.empty(), name, new MetaInfo.Result(result), sourcePos);
    }

    @NotNull
    public PiTerm asPi(@NotNull String domName, @NotNull String codName, boolean explicit, @NotNull ImmutableSeq<Arg<Term>> contextArgs) {
        assert (this.telescope.isEmpty());
        MetaInfo knownDomInfo = this.info;
        MetaInfo knownCodInfo = this.info;
        if (knownDomInfo instanceof MetaInfo.Result) {
            Term term = Meta.$proxy$result((MetaInfo.Result)knownDomInfo);
            Term result = term;
            if (!(result instanceof SortTerm)) {
                throw new AssertionError((Object)"This should be unreachable");
            }
            SortTerm sort = (SortTerm)result;
            knownDomInfo = new MetaInfo.PiDom(sort);
        }
        Meta domVar = new Meta(this.contextTele, (ImmutableSeq<Term.Param>)ImmutableSeq.empty(), domName, knownDomInfo, this.sourcePos);
        Meta codVar = new Meta(this.contextTele, (ImmutableSeq<Term.Param>)ImmutableSeq.empty(), codName, knownCodInfo, this.sourcePos);
        MetaTerm dom = new MetaTerm(domVar, contextArgs, (ImmutableSeq<Arg<Term>>)ImmutableSeq.empty());
        MetaTerm cod = new MetaTerm(codVar, contextArgs, (ImmutableSeq<Arg<Term>>)ImmutableSeq.empty());
        Term.Param domParam = new Term.Param(Constants.randomlyNamed(this.sourcePos), dom, explicit);
        return new PiTerm(domParam, cod);
    }

    @NotNull
    public Meta clone(@NotNull MetaInfo newInfo) {
        Meta typed = new Meta(this.contextTele, this.telescope, this.name, newInfo, this.sourcePos);
        typed.conditions.appendAll(this.conditions);
        return typed;
    }

    @NotNull
    public MetaTerm asPiDom(@NotNull SortTerm sort, @NotNull ImmutableSeq<Arg<Term>> contextArgs) {
        assert (this.telescope.isEmpty());
        assert (this.info instanceof MetaInfo.AnyType);
        Meta typed = new Meta(this.contextTele, (ImmutableSeq<Term.Param>)ImmutableSeq.empty(), this.name, new MetaInfo.PiDom(sort), this.sourcePos);
        return new MetaTerm(typed, contextArgs, (ImmutableSeq<Arg<Term>>)ImmutableSeq.empty());
    }

    @Override
    @NotNull
    public String name() {
        return this.name;
    }

    private static /* synthetic */ Term $proxy$result(MetaInfo.Result arg0) {
        try {
            return arg0.result();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.toString(), throwable);
        }
    }
}

