/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.pat;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import kala.collection.immutable.ImmutableSeq;
import org.aya.concrete.stmt.decl.TeleDecl;
import org.aya.core.def.DataDef;
import org.aya.core.pat.Pat;
import org.aya.core.term.ConCall;
import org.aya.core.term.DataCall;
import org.aya.core.term.IntegerTerm;
import org.aya.core.term.MetaPatTerm;
import org.aya.core.term.RefTerm;
import org.aya.core.term.Term;
import org.aya.core.term.TupTerm;
import org.aya.ref.DefVar;
import org.aya.ref.LocalVar;
import org.aya.util.Arg;
import org.jetbrains.annotations.NotNull;

public class PatToTerm {
    @NotNull
    static final PatToTerm INSTANCE = new PatToTerm();

    protected PatToTerm() {
    }

    public Term visit(@NotNull Pat pat) {
        Pat pat2 = pat;
        Objects.requireNonNull(pat2);
        Pat pat3 = pat2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Pat.Absurd.class, Pat.Ctor.class, Pat.Bind.class, Pat.Tuple.class, Pat.Meta.class, Pat.ShapedInt.class}, (Object)pat3, n)) {
            default -> throw new RuntimeException(null, null);
            case 0 -> {
                Pat.Absurd absurd = (Pat.Absurd)pat3;
                yield new RefTerm(new LocalVar("()"));
            }
            case 1 -> {
                Pat.Ctor ctor = (Pat.Ctor)pat3;
                yield this.visitCtor(ctor);
            }
            case 2 -> {
                Pat.Bind bind = (Pat.Bind)pat3;
                yield new RefTerm(bind.bind());
            }
            case 3 -> {
                Pat.Tuple tuple = (Pat.Tuple)pat3;
                yield new TupTerm((ImmutableSeq<Arg<Term>>)tuple.pats().map(p -> p.map(this::visit)));
            }
            case 4 -> {
                Pat.Meta meta = (Pat.Meta)pat3;
                yield new MetaPatTerm(meta);
            }
            case 5 -> {
                Pat.ShapedInt lit = (Pat.ShapedInt)pat3;
                yield new IntegerTerm(lit.repr(), lit.recognition(), lit.type());
            }
        };
    }

    @NotNull
    protected Term visitCtor(@NotNull Pat.Ctor ctor) {
        DataCall data = ctor.type();
        ImmutableSeq args = Arg.mapSeq(ctor.params(), this::visit);
        return new ConCall((DefVar<DataDef, TeleDecl.DataDecl>)data.ref(), ctor.ref(), data.args(), data.ulift(), (ImmutableSeq<Arg<Term>>)args);
    }
}

