/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.repr;

import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableLinkedHashMap;
import kala.collection.mutable.MutableMap;
import kala.control.Option;
import kala.tuple.Tuple;
import kala.tuple.Tuple2;
import org.aya.core.def.Def;
import org.aya.core.def.GenericDef;
import org.aya.core.repr.CodeShape;
import org.aya.core.repr.ShapeMatcher;
import org.aya.core.repr.ShapeRecognition;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface AyaShape {
    @NotNull
    public static final AyaShape NAT_SHAPE = new AyaIntShape();
    @NotNull
    public static final AyaShape LIST_SHAPE = new AyaListShape();
    @NotNull
    public static final ImmutableSeq<AyaShape> LITERAL_SHAPES = ImmutableSeq.of((Object)NAT_SHAPE, (Object)LIST_SHAPE);

    @NotNull
    public CodeShape codeShape();

    public record AyaIntShape() implements AyaShape
    {
        @NotNull
        public static final CodeShape DATA_NAT = new CodeShape.DataShape((ImmutableSeq<CodeShape.ParamShape>)ImmutableSeq.empty(), (ImmutableSeq<CodeShape.CtorShape>)ImmutableSeq.of((Object)new CodeShape.CtorShape(CodeShape.MomentId.ZERO, (ImmutableSeq<CodeShape.ParamShape>)ImmutableSeq.empty()), (Object)new CodeShape.CtorShape(CodeShape.MomentId.SUC, (ImmutableSeq<CodeShape.ParamShape>)ImmutableSeq.of((Object)CodeShape.ParamShape.explicit(CodeShape.TermShape.Call.justCall(0))))));

        @Override
        @NotNull
        public CodeShape codeShape() {
            return DATA_NAT;
        }
    }

    public record AyaListShape() implements AyaShape
    {
        @NotNull
        public static final CodeShape DATA_LIST = new CodeShape.DataShape((ImmutableSeq<CodeShape.ParamShape>)ImmutableSeq.of((Object)CodeShape.ParamShape.anyLicit(new CodeShape.TermShape.Sort(null, 0))), (ImmutableSeq<CodeShape.CtorShape>)ImmutableSeq.of((Object)new CodeShape.CtorShape(CodeShape.MomentId.NIL, (ImmutableSeq<CodeShape.ParamShape>)ImmutableSeq.empty()), (Object)new CodeShape.CtorShape(CodeShape.MomentId.CONS, (ImmutableSeq<CodeShape.ParamShape>)ImmutableSeq.of((Object)CodeShape.ParamShape.anyLicit(new CodeShape.TermShape.TeleRef(0, 0)), (Object)CodeShape.ParamShape.anyLicit(new CodeShape.TermShape.Call(0, (ImmutableSeq<CodeShape.TermShape>)ImmutableSeq.of((Object)new CodeShape.TermShape.TeleRef(0, 0))))))));

        @Override
        @NotNull
        public CodeShape codeShape() {
            return DATA_LIST;
        }
    }

    public static class Factory {
        @NotNull
        public MutableMap<GenericDef, ShapeRecognition> discovered = MutableLinkedHashMap.of();

        @NotNull
        public ImmutableSeq<Tuple2<GenericDef, ShapeRecognition>> findImpl(@NotNull AyaShape shape) {
            return this.discovered.view().map(Tuple::of).filter(t -> ((ShapeRecognition)t.component2()).shape() == shape).toImmutableSeq();
        }

        @NotNull
        public Option<ShapeRecognition> find(@NotNull Def def) {
            return this.discovered.getOption((Object)def);
        }

        public void bonjour(@NotNull GenericDef def, @NotNull ShapeRecognition shape) {
            this.discovered.put((Object)def, (Object)shape);
        }

        public void bonjour(@NotNull GenericDef def) {
            LITERAL_SHAPES.view().flatMap(shape -> ShapeMatcher.match(shape, def)).forEach(shape -> this.bonjour(def, (ShapeRecognition)shape));
        }

        public void importAll(@NotNull Factory other) {
            this.discovered.putAll(other.discovered);
        }
    }
}

