/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.serde;

import java.io.Serializable;
import kala.collection.immutable.ImmutableSeq;
import org.aya.concrete.stmt.decl.TeleDecl;
import org.aya.core.def.CtorDef;
import org.aya.core.pat.Pat;
import org.aya.core.serde.SerDef;
import org.aya.core.serde.SerTerm;
import org.aya.core.term.Term;
import org.aya.ref.DefVar;
import org.aya.util.Arg;
import org.aya.util.error.SourcePos;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface SerPat
extends Serializable {
    @NotNull
    public Arg<Pat> de(@NotNull SerTerm.DeState var1);

    public record ShapedInt(int integer, boolean explicit, @NotNull SerDef.SerShapeResult shape, @NotNull SerTerm.Data type) implements SerPat
    {
        @Override
        @NotNull
        public Arg<Pat> de(@NotNull SerTerm.DeState state) {
            return new Arg((Object)new Pat.ShapedInt(this.integer, this.shape.de(state), this.type.de(state)), this.explicit);
        }
    }

    public record Ctor(boolean explicit, @NotNull SerDef.QName name, @NotNull ImmutableSeq<SerPat> params, @NotNull SerTerm.Data ty) implements SerPat
    {
        @Override
        @NotNull
        public Arg<Pat> de(@NotNull SerTerm.DeState state) {
            return new Arg((Object)new Pat.Ctor((DefVar<CtorDef, TeleDecl.DataCtor>)state.resolve(this.name), (ImmutableSeq<Arg<Pat>>)this.params.map(param -> param.de(state)), this.ty.de(state)), this.explicit);
        }
    }

    public record Bind(boolean explicit, @NotNull SerTerm.SimpVar var, @NotNull SerTerm ty) implements SerPat
    {
        @Override
        @NotNull
        public Arg<Pat> de(@NotNull SerTerm.DeState state) {
            return new Arg((Object)new Pat.Bind(this.var.de(state), this.ty.de(state)), this.explicit);
        }
    }

    public record Tuple(boolean explicit, @NotNull ImmutableSeq<SerPat> pats) implements SerPat
    {
        @Override
        @NotNull
        public Arg<Pat> de(@NotNull SerTerm.DeState state) {
            return new Arg((Object)new Pat.Tuple((ImmutableSeq<Arg<Pat>>)this.pats.map(pat -> pat.de(state))), this.explicit);
        }
    }

    public record Absurd(boolean explicit) implements SerPat
    {
        @Override
        @NotNull
        public Arg<Pat> de(@NotNull SerTerm.DeState state) {
            return new Arg((Object)new Pat.Absurd(), this.explicit);
        }
    }

    public record Clause(@NotNull ImmutableSeq<SerPat> pats, @NotNull SerTerm body) implements Serializable
    {
        @NotNull
        public Term.Matching de(@NotNull SerTerm.DeState state) {
            return new Term.Matching(SourcePos.SER, (ImmutableSeq<Arg<Pat>>)this.pats.map(pat -> pat.de(state)), this.body.de(state));
        }
    }
}

