/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.term;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.function.UnaryOperator;
import kala.collection.immutable.ImmutableSeq;
import org.aya.core.def.CtorDef;
import org.aya.core.pat.Pat;
import org.aya.core.repr.ShapeRecognition;
import org.aya.core.term.ConCall;
import org.aya.core.term.DataCall;
import org.aya.core.term.StableWHNF;
import org.aya.core.term.Term;
import org.aya.generic.Shaped;
import org.aya.util.Arg;
import org.jetbrains.annotations.NotNull;

public final class IntegerTerm
extends Record
implements StableWHNF,
Shaped.Nat<Term> {
    private final int repr;
    @NotNull
    private final ShapeRecognition recognition;
    @NotNull
    private final DataCall type;

    public IntegerTerm(int repr, @NotNull ShapeRecognition recognition, @NotNull DataCall type) {
        this.repr = repr;
        this.recognition = recognition;
        this.type = type;
    }

    public IntegerTerm update(DataCall type) {
        return type == this.type() ? this : new IntegerTerm(this.repr, this.recognition, type);
    }

    @Override
    @NotNull
    public IntegerTerm descent(@NotNull UnaryOperator<Term> f, @NotNull UnaryOperator<Pat> g) {
        return this.update((DataCall)f.apply(this.type));
    }

    @Override
    @NotNull
    public Term makeZero(@NotNull CtorDef zero) {
        return new ConCall(zero.dataRef, zero.ref, (ImmutableSeq<Arg<Term>>)ImmutableSeq.empty(), 0, (ImmutableSeq<Arg<Term>>)ImmutableSeq.empty());
    }

    @Override
    @NotNull
    public Term makeSuc(@NotNull CtorDef suc, @NotNull Arg<Term> term) {
        return new ConCall(suc.dataRef, suc.ref, (ImmutableSeq<Arg<Term>>)ImmutableSeq.empty(), 0, (ImmutableSeq<Arg<Term>>)ImmutableSeq.of(term));
    }

    @Override
    @NotNull
    public Term destruct(int repr) {
        return new IntegerTerm(repr, this.recognition, this.type);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{IntegerTerm.class, "repr;recognition;type", "repr", "recognition", "type"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{IntegerTerm.class, "repr;recognition;type", "repr", "recognition", "type"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{IntegerTerm.class, "repr;recognition;type", "repr", "recognition", "type"}, this, o);
    }

    @Override
    public int repr() {
        return this.repr;
    }

    @Override
    @NotNull
    public ShapeRecognition recognition() {
        return this.recognition;
    }

    @Override
    @NotNull
    public DataCall type() {
        return this.type;
    }
}

