/*
 * Decompiled with CFR 0.152.
 */
package org.aya.generic;

import java.util.function.BiPredicate;
import kala.collection.immutable.ImmutableSeq;
import org.aya.core.def.CtorDef;
import org.aya.core.repr.CodeShape;
import org.aya.core.repr.ShapeRecognition;
import org.aya.core.term.DataCall;
import org.aya.core.term.Term;
import org.aya.generic.AyaDocile;
import org.aya.ref.DefVar;
import org.aya.tyck.unify.TermComparator;
import org.aya.util.Arg;
import org.jetbrains.annotations.NotNull;

public interface Shaped<T> {
    @NotNull
    public Term type();

    public static interface List<T extends AyaDocile>
    extends Inductive<T> {
        @NotNull
        public ImmutableSeq<T> repr();

        @NotNull
        public T makeNil(@NotNull CtorDef var1, @NotNull Arg<Term> var2);

        @NotNull
        public T makeCons(@NotNull CtorDef var1, @NotNull Arg<Term> var2, Arg<T> var3, Arg<T> var4);

        @NotNull
        public T destruct(@NotNull ImmutableSeq<T> var1);

        default public <O extends AyaDocile> boolean compareUntyped(@NotNull List<O> other, @NotNull BiPredicate<T, O> comparator) {
            ImmutableSeq<O> rhsRepr;
            ImmutableSeq<T> lhsRepr = this.repr();
            return lhsRepr.sizeEquals(rhsRepr = other.repr()) && lhsRepr.allMatchWith(rhsRepr, comparator);
        }

        @Override
        @NotNull
        default public T constructorForm() {
            CtorDef nil = (CtorDef)this.ctorRef((CodeShape.MomentId)CodeShape.MomentId.NIL).core;
            CtorDef cons = (CtorDef)this.ctorRef((CodeShape.MomentId)CodeShape.MomentId.CONS).core;
            Arg dataArg = (Arg)this.type().args().first();
            boolean xLicit = ((Term.Param)cons.selfTele.get(0)).explicit();
            boolean xsLicit = ((Term.Param)cons.selfTele.get(1)).explicit();
            ImmutableSeq<T> elements = this.repr();
            if (elements.isEmpty()) {
                return this.makeNil(nil, (Arg<Term>)dataArg);
            }
            return this.makeCons(cons, (Arg<Term>)dataArg, new Arg((Object)((AyaDocile)elements.first()), xLicit), new Arg(this.destruct(elements.drop(1)), xsLicit));
        }
    }

    public static interface Nat<T extends AyaDocile>
    extends Inductive<T> {
        @NotNull
        public T makeZero(@NotNull CtorDef var1);

        @NotNull
        public T makeSuc(@NotNull CtorDef var1, @NotNull Arg<T> var2);

        @NotNull
        public T destruct(int var1);

        public int repr();

        default public <O extends AyaDocile> boolean compareUntyped(@NotNull Nat<O> other) {
            return this.repr() == other.repr();
        }

        @Override
        @NotNull
        default public T constructorForm() {
            int repr = this.repr();
            DefVar<CtorDef, ?> zero = this.ctorRef(CodeShape.MomentId.ZERO);
            DefVar<CtorDef, ?> suc = this.ctorRef(CodeShape.MomentId.SUC);
            if (repr == 0) {
                return this.makeZero((CtorDef)zero.core);
            }
            return this.makeSuc((CtorDef)suc.core, new Arg(this.destruct(repr - 1), true));
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Inductive<T>
    extends Shaped<T> {
        @Override
        @NotNull
        public DataCall type();

        @NotNull
        public ShapeRecognition recognition();

        @NotNull
        public T constructorForm();

        @NotNull
        default public DefVar<CtorDef, ?> ctorRef(@NotNull CodeShape.MomentId id) {
            return (DefVar)this.recognition().captures().get((Object)id);
        }

        default public <O> boolean compareShape(TermComparator comparator, @NotNull Inductive<O> other) {
            if (this.recognition().shape() != other.recognition().shape()) {
                return false;
            }
            if (other.getClass() != this.getClass()) {
                return false;
            }
            return comparator.compare(this.type(), other.type(), null);
        }
    }
}

