/*
 * Decompiled with CFR 0.152.
 */
package org.aya.generic.util;

import java.nio.file.Path;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import org.aya.generic.Constants;
import org.aya.util.FileUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface AyaFiles {
    @NotNull
    public static String stripAyaSourcePostfix(@NotNull String name) {
        return Constants.AYA_POSTFIX_PATTERN.matcher(name).replaceAll("");
    }

    @NotNull
    public static Path resolveAyaSourceFile(@NotNull Path basePath, @NotNull ImmutableSeq<String> moduleName) {
        return FileUtil.resolveFile((Path)basePath, moduleName, (String)".aya");
    }

    @Nullable
    public static Path resolveAyaSourceFile(@NotNull SeqView<Path> basePaths, @NotNull ImmutableSeq<String> moduleName) {
        return FileUtil.resolveFile(basePaths, moduleName, (String)".aya");
    }

    @NotNull
    public static Path resolveAyaCompiledFile(@NotNull Path basePath, @NotNull ImmutableSeq<String> moduleName) {
        return FileUtil.resolveFile((Path)basePath, moduleName, (String)".ayac");
    }

    @Nullable
    public static Path resolveAyaCompiledFile(@NotNull SeqView<Path> basePaths, @NotNull ImmutableSeq<String> moduleName) {
        return FileUtil.resolveFile(basePaths, moduleName, (String)".ayac");
    }

    @NotNull
    public static ImmutableSeq<Path> collectAyaSourceFiles(@NotNull Path basePath) {
        return AyaFiles.collectAyaSourceFiles(basePath, Integer.MAX_VALUE);
    }

    @NotNull
    public static ImmutableSeq<Path> collectAyaSourceFiles(@NotNull Path basePath, int maxDepth) {
        return FileUtil.collectSource((Path)basePath, (String)".aya", (int)maxDepth);
    }
}

