/*
 * Decompiled with CFR 0.152.
 */
package org.aya.resolve.context;

import java.util.function.Consumer;
import kala.collection.Seq;
import kala.collection.SeqLike;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import kala.collection.mutable.MutableMap;
import kala.control.Option;
import kala.control.Result;
import kala.value.primitive.MutableBooleanValue;
import org.aya.concrete.stmt.QualifiedID;
import org.aya.concrete.stmt.UseHide;
import org.aya.ref.DefVar;
import org.aya.resolve.context.ModuleName;
import org.aya.resolve.context.ModuleSymbol;
import org.aya.resolve.error.NameProblem;
import org.aya.util.error.SourcePos;
import org.aya.util.error.WithPos;
import org.aya.util.reporter.Problem;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record ModuleExport(@NotNull ModuleSymbol<DefVar<?, ?>> symbols, @NotNull MutableMap<ModuleName.Qualified, ModuleExport> modules) {
    public ModuleExport() {
        this(new ModuleSymbol(), (MutableMap<ModuleName.Qualified, ModuleExport>)MutableMap.create());
    }

    public ModuleExport(@NotNull ModuleExport that) {
        this(new ModuleSymbol(that.symbols), (MutableMap<ModuleName.Qualified, ModuleExport>)MutableMap.from(that.modules));
    }

    @Contract(pure=true)
    @NotNull
    ExportResult filter(@NotNull ImmutableSeq<QualifiedID> names, UseHide.Strategy strategy) {
        ModuleExport newModule;
        MutableList badNames = MutableList.create();
        MutableList ambiNames = MutableList.create();
        switch (strategy) {
            case Using: {
                newModule = new ModuleExport();
                names.forEach(qname -> {
                    Result<ExportUnit, ModuleSymbol.Error> unit = this.getMaybe(qname.component(), qname.name());
                    if (unit.isOk()) {
                        ((ExportUnit)unit.get()).forEach(symbol -> newModule.export(qname.component(), qname.name(), (DefVar<?, ?>)symbol), module -> newModule.export(qname.component().resolve(qname.name()), (ModuleExport)module));
                    } else {
                        switch ((ModuleSymbol.Error)((Object)((Object)unit.getErr()))) {
                            case NotFound: {
                                badNames.append(qname);
                                break;
                            }
                            case Ambiguous: {
                                ambiNames.append((Object)new WithPos(qname.sourcePos(), (Object)qname.name()));
                            }
                        }
                    }
                });
                break;
            }
            case Hiding: {
                ModuleExport aNewModule;
                newModule = aNewModule = new ModuleExport(this);
                names.forEach(qname -> {
                    Result<ExportUnit, ModuleSymbol.Error> oldUnit = aNewModule.removeMaybe(qname.component(), qname.name());
                    ModuleSymbol.Error error = (ModuleSymbol.Error)((Object)((Object)oldUnit.getErrOrNull()));
                    switch (error != null ? 1.$SwitchMap$org$aya$resolve$context$ModuleSymbol$Error[error.ordinal()] : -1) {
                        case 1: {
                            badNames.append(qname);
                            break;
                        }
                        case 2: {
                            ambiNames.append((Object)new WithPos(qname.sourcePos(), (Object)qname.name()));
                            break;
                        }
                    }
                });
                break;
            }
            default: {
                throw new AssertionError((Object)"I mean, this case is impossible.");
            }
        }
        boolean hasError = badNames.isNotEmpty() || ambiNames.isNotEmpty();
        return new ExportResult(hasError ? this : newModule, (ImmutableSeq<QualifiedID>)badNames.toImmutableSeq(), (ImmutableSeq<WithPos<String>>)ambiNames.toImmutableSeq(), (ImmutableSeq<WithPos<String>>)ImmutableSeq.empty());
    }

    @Contract(pure=true)
    @NotNull
    ExportResult map(@NotNull Seq<WithPos<UseHide.Rename>> mapper) {
        ModuleExport newExport = new ModuleExport(this);
        MutableList badNames = MutableList.create();
        MutableList ambiNames = MutableList.create();
        MutableList shadowNames = MutableList.create();
        mapper.forEach(pair -> {
            SourcePos pos = pair.sourcePos();
            ModuleName fromModule = ModuleName.from(((UseHide.Rename)pair.data()).fromModule());
            String fromName = ((UseHide.Rename)pair.data()).name();
            String to = ((UseHide.Rename)pair.data()).to();
            if (fromModule == ModuleName.This && fromName.equals(to)) {
                return;
            }
            Result<ExportUnit, ModuleSymbol.Error> thing = newExport.removeMaybe(fromModule, fromName);
            if (thing.isOk()) {
                MutableBooleanValue reportShadow = MutableBooleanValue.create((boolean)false);
                ((ExportUnit)thing.get()).forEach(symbol -> {
                    MutableMap<ModuleName, DefVar<?, ?>> candidates = newExport.symbols.resolveUnqualified(to);
                    boolean isShadow = candidates.isNotEmpty();
                    if (isShadow) {
                        candidates.clear();
                        reportShadow.set(true);
                    }
                    candidates.put((Object)ModuleName.This, symbol);
                }, module -> {
                    boolean isShadow = newExport.modules.containsKey((Object)new ModuleName.Qualified(to));
                    if (isShadow) {
                        reportShadow.set(true);
                    }
                    newExport.modules.put((Object)new ModuleName.Qualified(to), module);
                });
                if (reportShadow.get()) {
                    shadowNames.append((Object)new WithPos(pos, (Object)to));
                }
            } else {
                switch ((ModuleSymbol.Error)((Object)((Object)thing.getErr()))) {
                    case NotFound: {
                        badNames.append((Object)new QualifiedID(pos, fromModule, fromName));
                        break;
                    }
                    case Ambiguous: {
                        ambiNames.append((Object)new WithPos(pos, (Object)fromName));
                    }
                }
            }
        });
        boolean hasError = badNames.isNotEmpty() || ambiNames.isNotEmpty();
        return new ExportResult(hasError ? this : newExport, (ImmutableSeq<QualifiedID>)badNames.toImmutableSeq(), (ImmutableSeq<WithPos<String>>)ambiNames.toImmutableSeq(), (ImmutableSeq<WithPos<String>>)shadowNames.toImmutableSeq());
    }

    public boolean export(@NotNull ModuleName modName, @NotNull String name, @NotNull DefVar<?, ?> ref) {
        Option<DefVar<?, ?>> exists = this.symbols.add(modName, name, ref);
        return exists.isEmpty();
    }

    public boolean export(@NotNull ModuleName.Qualified componentName, @NotNull ModuleExport module) {
        Option exists = this.modules.put((Object)componentName, (Object)module);
        return exists.isEmpty();
    }

    private Result<ExportUnit, ModuleSymbol.Error> getMaybe(@NotNull ModuleName component, @NotNull String name) {
        Result<DefVar<?, ?>, ModuleSymbol.Error> symbol = this.symbols.getMaybe(component, name);
        Option module = this.modules.getOption((Object)component.resolve(name));
        if (symbol.getErrOrNull() == ModuleSymbol.Error.Ambiguous) {
            return Result.err((Object)((Object)ModuleSymbol.Error.Ambiguous));
        }
        if (symbol.isEmpty() && module.isEmpty()) {
            return Result.err((Object)((Object)ModuleSymbol.Error.NotFound));
        }
        return Result.ok((Object)new ExportUnit((DefVar)symbol.getOrNull(), (ModuleExport)module.getOrNull()));
    }

    private Result<ExportUnit, ModuleSymbol.Error> removeMaybe(@NotNull ModuleName component, @NotNull String name) {
        Result<DefVar<?, ?>, ModuleSymbol.Error> symbol = this.symbols.removeDefinitely(component, name);
        if (symbol.getErrOrNull() == ModuleSymbol.Error.Ambiguous) {
            return Result.err((Object)((Object)ModuleSymbol.Error.Ambiguous));
        }
        Option module = this.modules.remove((Object)component.resolve(name));
        if (symbol.isEmpty() && module.isEmpty()) {
            return Result.err((Object)((Object)ModuleSymbol.Error.NotFound));
        }
        return Result.ok((Object)new ExportUnit((DefVar)symbol.getOrNull(), (ModuleExport)module.getOrNull()));
    }

    record ExportResult(@NotNull ModuleExport result, @NotNull ImmutableSeq<QualifiedID> invalidNames, @NotNull ImmutableSeq<WithPos<String>> ambiguousNames, @NotNull ImmutableSeq<WithPos<String>> shadowNames) {
        public boolean anyError() {
            return this.invalidNames().isNotEmpty() || this.ambiguousNames().isNotEmpty();
        }

        public boolean anyWarn() {
            return this.shadowNames().isNotEmpty();
        }

        public SeqView<Problem> problems(@NotNull ModuleName modName) {
            SeqView invalidNameProblems = this.invalidNames().view().map(name -> new NameProblem.QualifiedNameNotFoundError(modName.concat(name.component()), name.name(), name.sourcePos()));
            SeqView ambiguousNameProblems = this.ambiguousNames().view().map(name -> {
                ModuleExport old = this.result();
                ImmutableSeq disambi = old.symbols().resolveUnqualified((String)name.data()).keysView().toImmutableSeq();
                return new NameProblem.AmbiguousNameError((String)name.data(), (ImmutableSeq<ModuleName>)disambi, name.sourcePos());
            });
            SeqView shadowNameProblems = this.shadowNames().view().map(name -> new NameProblem.ShadowingWarn((String)name.data(), name.sourcePos()));
            return shadowNameProblems.concat((SeqLike)invalidNameProblems).concat((SeqLike)ambiguousNameProblems);
        }
    }

    private record ExportUnit(@Nullable DefVar<?, ?> symbol, @Nullable ModuleExport module) {
        public ExportUnit(@Nullable DefVar<?, ?> symbol, @Nullable ModuleExport module) {
            assert (symbol != null || module != null) : "Sanity check";
        }

        public void forEach(Consumer<DefVar<?, ?>> symbolConsumer, Consumer<ModuleExport> moduleConsumer) {
            if (this.symbol != null) {
                symbolConsumer.accept(this.symbol);
            }
            if (this.module != null) {
                moduleConsumer.accept(this.module);
            }
        }
    }
}

