/*
 * Decompiled with CFR 0.152.
 */
package org.aya.resolve.context;

import java.io.Serializable;
import kala.collection.immutable.ImmutableSeq;
import org.aya.concrete.stmt.QualifiedID;
import org.aya.generic.util.InternalException;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ModuleName
extends Serializable {
    @NotNull
    public static final ThisRef This = ThisRef.Obj;

    public int size();

    @NotNull
    public ImmutableSeq<String> ids();

    @NotNull
    public Qualified resolve(@NotNull String var1);

    @NotNull
    public ModuleName concat(@NotNull ModuleName var1);

    @NotNull
    public String toString();

    @NotNull
    public static ModuleName from(@NotNull ImmutableSeq<String> ids) {
        if (ids.isEmpty()) {
            return This;
        }
        return new Qualified(ids);
    }

    @NotNull
    public static Qualified qualified(@NotNull ImmutableSeq<String> ids) {
        if (ids.isEmpty()) {
            throw new InternalException("A valid module path cannot be empty");
        }
        return new Qualified(ids);
    }

    public static enum ThisRef implements ModuleName
    {
        Obj;


        @Override
        public int size() {
            return 0;
        }

        @Override
        @NotNull
        public ImmutableSeq<String> ids() {
            return ImmutableSeq.empty();
        }

        @Override
        @NotNull
        public Qualified resolve(@NotNull String name) {
            return new Qualified((ImmutableSeq<String>)ImmutableSeq.of((Object)name));
        }

        @Override
        @NotNull
        public ModuleName concat(@NotNull ModuleName path) {
            return path;
        }

        @Override
        @NotNull
        public String toString() {
            return "";
        }
    }

    public record Qualified(@NotNull ImmutableSeq<String> ids) implements ModuleName
    {
        public Qualified(String ... ids) {
            this((ImmutableSeq<String>)ImmutableSeq.of((Object[])ids));
        }

        public Qualified(@NotNull ImmutableSeq<String> ids) {
            assert (ids.isNotEmpty()) : "Otherwise please use `This`";
        }

        @Override
        public int size() {
            return this.ids.size();
        }

        @Override
        @NotNull
        public Qualified resolve(@NotNull String name) {
            return new Qualified((ImmutableSeq<String>)this.ids.appended((Object)name));
        }

        @Override
        @NotNull
        public Qualified concat(@NotNull ModuleName path) {
            return new Qualified((ImmutableSeq<String>)this.ids.concat(path.ids()));
        }

        @Override
        @NotNull
        public String toString() {
            return QualifiedID.join(this.ids);
        }
    }
}

