/*
 * Decompiled with CFR 0.152.
 */
package org.aya.resolve.context;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.BiConsumer;
import kala.collection.CollectionView;
import kala.collection.Map;
import kala.collection.MapLike;
import kala.collection.MapView;
import kala.collection.SetView;
import kala.collection.mutable.MutableMap;
import kala.control.Option;
import kala.control.Result;
import kala.tuple.Tuple2;
import org.aya.resolve.context.ModuleName;
import org.jetbrains.annotations.NotNull;

public record ModuleSymbol<T>(@NotNull MutableMap<String, MutableMap<ModuleName, T>> table) {
    public ModuleSymbol() {
        this(MutableMap.create());
    }

    public ModuleSymbol(@NotNull ModuleSymbol<T> other) {
        this((MutableMap)other.table.toImmutableSeq().collect(MutableMap.collector(Tuple2::component1, x -> MutableMap.from((MapLike)((MapLike)x.component2())))));
    }

    @NotNull
    public MutableMap<ModuleName, T> resolveUnqualified(@NotNull String unqualifiedName) {
        return (MutableMap)this.table.getOrPut((Object)unqualifiedName, MutableMap::create);
    }

    @NotNull
    public Option<T> getQualifiedMaybe(@NotNull ModuleName component, @NotNull String unqualifiedName) {
        return this.resolveUnqualified(unqualifiedName).getOption((Object)component);
    }

    @NotNull
    public Result<T, Error> getUnqualifiedMaybe(@NotNull String unqualifiedName) {
        MutableMap<ModuleName, T> candidates = this.resolveUnqualified(unqualifiedName);
        if (candidates.isEmpty()) {
            return Result.err((Object)((Object)Error.NotFound));
        }
        CollectionView uniqueCandidates = candidates.valuesView().distinct();
        if (uniqueCandidates.size() != 1) {
            return Result.err((Object)((Object)Error.Ambiguous));
        }
        return Result.ok(uniqueCandidates.iterator().next());
    }

    @NotNull
    public Result<T, Error> getMaybe(@NotNull ModuleName component, @NotNull String unqualifiedName) {
        ModuleName moduleName = component;
        Objects.requireNonNull(moduleName);
        ModuleName moduleName2 = moduleName;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ModuleName.Qualified.class, ModuleName.ThisRef.class}, (Object)moduleName2, n)) {
            default -> throw new RuntimeException(null, null);
            case 0 -> {
                ModuleName.Qualified qualified = (ModuleName.Qualified)moduleName2;
                yield this.getQualifiedMaybe(component, unqualifiedName).toResult((Object)Error.NotFound);
            }
            case 1 -> {
                ModuleName.ThisRef aThis = (ModuleName.ThisRef)moduleName2;
                yield this.getUnqualifiedMaybe(unqualifiedName);
            }
        };
    }

    public boolean contains(@NotNull String unqualified) {
        return this.resolveUnqualified(unqualified).isNotEmpty();
    }

    public boolean contains(@NotNull ModuleName component, @NotNull String unqualified) {
        return this.resolveUnqualified(unqualified).containsKey((Object)component);
    }

    public Option<T> add(@NotNull ModuleName componentName, @NotNull String name, @NotNull T ref) {
        MutableMap<ModuleName, T> candidates = this.resolveUnqualified(name);
        return candidates.put((Object)componentName, ref);
    }

    public Option<T> remove(@NotNull ModuleName component, @NotNull String unqualifiedName) {
        return this.table().getOption((Object)unqualifiedName).flatMap(x -> x.remove((Object)component));
    }

    public Result<T, Error> removeDefinitely(@NotNull String unqualifiedName) {
        MutableMap<ModuleName, T> candidates = this.resolveUnqualified(unqualifiedName);
        if (candidates.isEmpty()) {
            return Result.err((Object)((Object)Error.NotFound));
        }
        CollectionView uniqueCandidates = candidates.valuesView().distinct();
        if (uniqueCandidates.size() != 1) {
            return Result.err((Object)((Object)Error.Ambiguous));
        }
        Object result = uniqueCandidates.iterator().next();
        candidates.clear();
        return Result.ok(result);
    }

    public Result<T, Error> removeDefinitely(@NotNull ModuleName component, @NotNull String unqualifiedName) {
        ModuleName moduleName = component;
        Objects.requireNonNull(moduleName);
        ModuleName moduleName2 = moduleName;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ModuleName.Qualified.class, ModuleName.ThisRef.class}, (Object)moduleName2, n)) {
            default -> throw new RuntimeException(null, null);
            case 0 -> {
                ModuleName.Qualified qualified = (ModuleName.Qualified)moduleName2;
                Option<T> result = this.remove(component, unqualifiedName);
                if (result.isEmpty()) {
                    yield Result.err((Object)((Object)Error.NotFound));
                }
                yield Result.ok((Object)result.get());
            }
            case 1 -> {
                ModuleName.ThisRef aThis = (ModuleName.ThisRef)moduleName2;
                yield this.removeDefinitely(unqualifiedName);
            }
        };
    }

    @NotNull
    public SetView<String> keysView() {
        return this.table().keysView();
    }

    @NotNull
    public MapView<String, Map<ModuleName, T>> view() {
        return this.table().view().mapValues((k, v) -> v);
    }

    public void forEach(@NotNull BiConsumer<String, Map<ModuleName, T>> action) {
        this.table().forEach(action);
    }

    public static enum Error {
        NotFound,
        Ambiguous;

    }
}

