/*
 * Decompiled with CFR 0.152.
 */
package org.aya.resolve.error;

import kala.collection.SeqLike;
import kala.collection.immutable.ImmutableSeq;
import org.aya.core.def.PrimDef;
import org.aya.pretty.doc.Doc;
import org.aya.util.error.SourcePos;
import org.aya.util.prettier.PrettierOptions;
import org.aya.util.reporter.Problem;
import org.jetbrains.annotations.NotNull;

public interface PrimResolveError
extends Problem {
    @NotNull
    default public Problem.Stage stage() {
        return Problem.Stage.RESOLVE;
    }

    @NotNull
    default public Problem.Severity level() {
        return Problem.Severity.ERROR;
    }

    public record BadUsage(@NotNull String name, @NotNull SourcePos sourcePos) implements PrimResolveError
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"The primitive"), Doc.code((Doc)Doc.plain((String)this.name)), Doc.english((String)"is not designed to be used as a function")});
        }

        @NotNull
        public Doc hint(@NotNull PrettierOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"Use the projection syntax instead, like:"), Doc.code((Doc)Doc.plain((String)("." + this.name)))});
        }
    }

    public record Dependency(@NotNull String name, @NotNull ImmutableSeq<PrimDef.ID> lack, @NotNull SourcePos sourcePos) implements PrimResolveError
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            assert (this.lack.isNotEmpty());
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"The primitive"), Doc.code((Doc)Doc.plain((String)this.name)), Doc.english((String)"depends on undeclared primitive(s):"), Doc.commaList((SeqLike)this.lack.map(name -> Doc.code((Doc)Doc.plain((String)name.id))))});
        }
    }

    public record Redefinition(@NotNull String name, @NotNull SourcePos sourcePos) implements PrimResolveError
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"Redefinition of primitive"), Doc.code((Doc)Doc.plain((String)this.name))});
        }
    }

    public record UnknownPrim(@NotNull SourcePos sourcePos, @NotNull String name) implements PrimResolveError
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"Unknown primitive"), Doc.code((Doc)Doc.plain((String)this.name))});
        }
    }
}

