/*
 * Decompiled with CFR 0.152.
 */
package org.aya.resolve.visitor;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import kala.collection.SeqLike;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.control.Option;
import kala.control.Result;
import kala.tuple.Tuple;
import org.aya.concrete.stmt.BindBlock;
import org.aya.concrete.stmt.Command;
import org.aya.concrete.stmt.Generalize;
import org.aya.concrete.stmt.GeneralizedVar;
import org.aya.concrete.stmt.Stmt;
import org.aya.concrete.stmt.UseHide;
import org.aya.concrete.stmt.decl.ClassDecl;
import org.aya.concrete.stmt.decl.Decl;
import org.aya.concrete.stmt.decl.DeclInfo;
import org.aya.concrete.stmt.decl.TeleDecl;
import org.aya.core.def.PrimDef;
import org.aya.generic.util.InternalException;
import org.aya.ref.DefVar;
import org.aya.resolve.ResolveInfo;
import org.aya.resolve.context.Context;
import org.aya.resolve.context.ModuleContext;
import org.aya.resolve.context.ModuleExport;
import org.aya.resolve.context.ModuleName;
import org.aya.resolve.context.ModulePath;
import org.aya.resolve.context.ModuleSymbol;
import org.aya.resolve.context.NoExportContext;
import org.aya.resolve.context.PhysicalModuleContext;
import org.aya.resolve.error.NameProblem;
import org.aya.resolve.error.PrimResolveError;
import org.aya.resolve.module.ModuleLoader;
import org.aya.util.binop.Assoc;
import org.aya.util.binop.OpDecl;
import org.aya.util.error.SourcePos;
import org.jetbrains.annotations.NotNull;

public record StmtShallowResolver(@NotNull ModuleLoader loader, @NotNull ResolveInfo resolveInfo) {
    public void resolveStmt(@NotNull SeqLike<Stmt> stmts, ModuleContext context) {
        stmts.forEach(stmt -> this.resolveStmt((Stmt)stmt, context));
    }

    public void resolveStmt(@NotNull Stmt stmt, @NotNull ModuleContext context) {
        Stmt stmt2 = stmt;
        Objects.requireNonNull(stmt2);
        Stmt stmt3 = stmt2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Decl.class, Command.Module.class, Command.Import.class, Command.Open.class, Generalize.class}, (Object)stmt3, n)) {
            default: {
                throw new RuntimeException(null, null);
            }
            case 0: {
                Decl decl = (Decl)stmt3;
                this.resolveDecl(decl, context);
                break;
            }
            case 1: {
                Command.Module mod = (Command.Module)stmt3;
                ModulePath wholeModeName = context.modulePath().derive(mod.name());
                if (this.loader.existsFileLevelModule(wholeModeName.path())) {
                    context.reportAndThrow(new NameProblem.ClashModNameError(wholeModeName.path(), mod.sourcePos()));
                }
                PhysicalModuleContext newCtx = context.derive(mod.name());
                this.resolveStmt((SeqLike<Stmt>)mod.contents(), (ModuleContext)newCtx);
                context.importModule(ModuleName.This.resolve(mod.name()), newCtx, mod.accessibility(), mod.sourcePos());
                break;
            }
            case 2: {
                Command.Import cmd = (Command.Import)stmt3;
                ModulePath modulePath = cmd.path();
                ResolveInfo success = this.loader.load(modulePath.path());
                if (success == null) {
                    context.reportAndThrow(new NameProblem.ModNotFoundError(modulePath, cmd.sourcePos()));
                }
                ModuleContext mod = success.thisModule();
                String as = cmd.asName();
                ModuleName.Qualified importedName = as != null ? ModuleName.This.resolve(as) : modulePath.asName();
                context.importModule(importedName, mod, cmd.accessibility(), cmd.sourcePos());
                this.resolveInfo.imports().put((Object)importedName, (Object)Tuple.of((Object)success, (Object)(cmd.accessibility() == Stmt.Accessibility.Public ? 1 : 0)));
                break;
            }
            case 3: {
                Command.Open cmd = (Command.Open)stmt3;
                ModuleName.Qualified mod = cmd.path();
                Stmt.Accessibility acc = cmd.accessibility();
                UseHide useHide = cmd.useHide();
                ModuleContext ctx = cmd.openExample() ? this.exampleContext(context) : context;
                ctx.openModule(mod, acc, cmd.sourcePos(), useHide);
                this.resolveInfo.imports().getOption((Object)mod).ifDefined(modResolveInfo -> {
                    if (acc == Stmt.Accessibility.Public) {
                        this.resolveInfo.reExports().put((Object)mod, (Object)useHide);
                    }
                    this.resolveInfo.open((ResolveInfo)modResolveInfo.component1(), cmd.sourcePos(), acc);
                });
                if (useHide.strategy() != UseHide.Strategy.Using) break;
                useHide.list().forEach(use -> {
                    if (use.asAssoc() == Assoc.Invalid) {
                        return;
                    }
                    Result<DefVar<?, ?>, ModuleSymbol.Error> symbol = ((ModuleExport)ctx.modules().get((Object)mod)).symbols().getMaybe(use.id().component(), use.id().name());
                    assert (symbol.isOk());
                    String asName = (String)use.asName().getOrDefault((Object)use.id().name());
                    ResolveInfo.RenamedOpDecl renamedOpDecl = new ResolveInfo.RenamedOpDecl(new OpDecl.OpInfo(asName, use.asAssoc()));
                    BindBlock bind = use.asBind();
                    if (bind != BindBlock.EMPTY) {
                        bind.context().set((Object)ctx);
                    }
                    this.resolveInfo.renameOp((DefVar)symbol.get(), renamedOpDecl, bind, true);
                });
                break;
            }
            case 4: {
                Generalize variables = (Generalize)stmt3;
                variables.ctx = context;
                for (GeneralizedVar variable : variables.variables) {
                    context.defineSymbol(variable, Stmt.Accessibility.Private, variable.sourcePos);
                }
            }
        }
    }

    private void resolveDecl(@NotNull Decl predecl, @NotNull ModuleContext context) {
        Decl decl = predecl;
        Objects.requireNonNull(decl);
        Decl decl2 = decl;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ClassDecl.class, TeleDecl.DataDecl.class, TeleDecl.StructDecl.class, TeleDecl.FnDecl.class, TeleDecl.PrimDecl.class}, (Object)decl2, n)) {
            case 0: {
                ClassDecl classDecl = (ClassDecl)decl2;
                throw new UnsupportedOperationException("not implemented yet");
            }
            case 1: {
                TeleDecl.DataDecl decl3 = (TeleDecl.DataDecl)decl2;
                ModuleContext ctx = this.resolveTopLevelDecl(decl3, context);
                PhysicalModuleContext innerCtx = this.resolveChildren(decl3, decl3, ctx, d -> d.body.view(), (ctor, mCtx) -> {
                    ctor.ref().module = mCtx.modulePath().path();
                    mCtx.defineSymbol(ctor.ref, Stmt.Accessibility.Public, ctor.sourcePos());
                    this.resolveOpInfo((Decl)ctor, (Context)mCtx);
                });
                this.resolveOpInfo(decl3, innerCtx);
                break;
            }
            case 2: {
                TeleDecl.StructDecl decl4 = (TeleDecl.StructDecl)decl2;
                ModuleContext ctx = this.resolveTopLevelDecl(decl4, context);
                PhysicalModuleContext innerCtx = this.resolveChildren(decl4, decl4, ctx, s -> s.fields.view(), (field, mockCtx) -> {
                    field.ref().module = mockCtx.modulePath().path();
                    mockCtx.defineSymbol(field.ref, Stmt.Accessibility.Public, field.sourcePos());
                    this.resolveOpInfo((Decl)field, (Context)mockCtx);
                });
                this.resolveOpInfo(decl4, innerCtx);
                break;
            }
            case 3: {
                TeleDecl.FnDecl decl5 = (TeleDecl.FnDecl)decl2;
                ModuleContext ctx = this.resolveTopLevelDecl(decl5, context);
                this.resolveOpInfo(decl5, ctx);
                break;
            }
            case 4: {
                Option<ImmutableSeq<PrimDef.ID>> lack;
                TeleDecl.PrimDecl decl6 = (TeleDecl.PrimDecl)decl2;
                PrimDef.Factory factory = this.resolveInfo.primFactory();
                String name = decl6.ref.name();
                SourcePos sourcePos = decl6.sourcePos();
                PrimDef.ID primID = PrimDef.ID.find(name);
                if (primID == null) {
                    context.reportAndThrow(new PrimResolveError.UnknownPrim(sourcePos, name));
                }
                if ((lack = factory.checkDependency(primID)).isNotEmpty() && ((ImmutableSeq)lack.get()).isNotEmpty()) {
                    context.reportAndThrow(new PrimResolveError.Dependency(name, (ImmutableSeq<PrimDef.ID>)((ImmutableSeq)lack.get()), sourcePos));
                } else if (factory.have(primID) && !factory.suppressRedefinition()) {
                    context.reportAndThrow(new PrimResolveError.Redefinition(name, sourcePos));
                }
                factory.factory(primID, decl6.ref);
                this.resolveTopLevelDecl(decl6, context);
                break;
            }
            default: {
                throw new InternalException("\ud83e\udeb2");
            }
        }
    }

    private <D extends Decl, Child extends Decl> PhysicalModuleContext resolveChildren(@NotNull D decl, @NotNull Decl.TopLevel proof, @NotNull ModuleContext context, @NotNull Function<D, SeqView<Child>> childrenGet, @NotNull BiConsumer<Child, ModuleContext> childResolver) {
        assert (decl == proof);
        PhysicalModuleContext innerCtx = context.derive(decl.ref().name());
        childrenGet.apply(decl).forEach(child -> childResolver.accept(child, innerCtx));
        String module = decl.ref().name();
        context.importModule(ModuleName.This.resolve(module), innerCtx.exports, decl.accessibility(), decl.sourcePos());
        proof.setCtx(innerCtx);
        return innerCtx;
    }

    private void resolveOpInfo(@NotNull Decl decl, @NotNull Context context) {
        BindBlock bind = decl.bindBlock();
        if (bind != BindBlock.EMPTY) {
            bind.context().set((Object)context);
        }
        if (decl.opInfo() != null) {
            DefVar<?, ?> ref = decl.ref();
            ref.opDecl = decl;
        }
    }

    @NotNull
    private <D extends Decl & Decl.TopLevel> ModuleContext resolveTopLevelDecl(@NotNull D decl, @NotNull ModuleContext context) {
        ModuleContext ctx;
        block8: {
            block7: {
                ctx = switch (((Decl.TopLevel)decl).personality()) {
                    default -> throw new IncompatibleClassChangeError();
                    case DeclInfo.Personality.NORMAL -> context;
                    case DeclInfo.Personality.EXAMPLE -> this.exampleContext(context);
                    case DeclInfo.Personality.COUNTEREXAMPLE -> this.exampleContext(context).derive(decl.ref().name());
                };
                ((Decl.TopLevel)decl).setCtx(ctx);
                decl.ref().module = ctx.modulePath().path();
                if (!(decl instanceof TeleDecl.FnDecl)) break block7;
                TeleDecl.FnDecl fnDecl = (TeleDecl.FnDecl)decl;
                if (fnDecl.isAnonymous) break block8;
            }
            ctx.defineSymbol(decl.ref(), decl.accessibility(), decl.sourcePos());
        }
        return ctx;
    }

    @NotNull
    private NoExportContext exampleContext(@NotNull ModuleContext context) {
        if (context instanceof PhysicalModuleContext) {
            PhysicalModuleContext physical = (PhysicalModuleContext)context;
            return physical.exampleContext();
        }
        throw new InternalException("Invalid context: " + String.valueOf(context));
    }
}

