/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.error;

import kala.collection.SeqLike;
import kala.collection.mutable.MutableList;
import org.aya.concrete.Expr;
import org.aya.core.term.Term;
import org.aya.generic.ExprProblem;
import org.aya.guest0x0.cubical.Restr;
import org.aya.prettier.BasePrettier;
import org.aya.pretty.doc.Doc;
import org.aya.tyck.error.TyckError;
import org.aya.tyck.error.UnifyInfo;
import org.aya.util.error.SourcePos;
import org.aya.util.prettier.PrettierOptions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface CubicalError
extends ExprProblem,
TyckError {

    public record PathConDominateError(@NotNull SourcePos sourcePos) implements TyckError
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.english((String)"The path constructor must not be a constant path");
        }
    }

    public record CoeVaryingType(@NotNull Expr expr, @NotNull Term type, @Nullable Term typeInst, @NotNull Restr<Term> restr, boolean stuck) implements CubicalError
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            Doc typeDoc = this.type.toDoc(options);
            Doc under = this.typeInst != null ? this.typeInst.toDoc(options) : null;
            MutableList buf = MutableList.of((Object)Doc.english((String)"Under the cofibration:"), (Object)Doc.par((int)1, (Doc)BasePrettier.restr(options, this.restr)));
            if (this.stuck) {
                buf.append((Object)Doc.english((String)"I am not sure if the type is constant, as my normalization is blocked for type:"));
            } else {
                buf.append((Object)Doc.english((String)"The type in the body still depends on the interval parameter:"));
            }
            buf.append((Object)Doc.par((int)1, (Doc)typeDoc));
            if (under != null && !typeDoc.equals((Object)under)) {
                buf.append((Object)Doc.par((int)1, (Doc)Doc.parened((Doc)Doc.sep((Doc[])new Doc[]{Doc.plain((String)"Normalized under cofibration:"), under}))));
            }
            buf.append((Object)Doc.english((String)"which is not allowed in coercion"));
            return Doc.vcat((SeqLike)buf);
        }
    }

    public record FaceMismatch(@NotNull Expr expr, @NotNull Restr<Term> face, @NotNull Restr<Term> cof) implements CubicalError
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.vcat((Doc[])new Doc[]{Doc.english((String)"The face(s) in the partial element:"), Doc.par((int)1, (Doc)BasePrettier.restr(options, this.face)), Doc.english((String)"must cover the face(s) specified in type:"), Doc.par((int)1, (Doc)BasePrettier.restr(options, this.cof))});
        }
    }

    public record BoundaryDisagree(@NotNull Expr expr, @NotNull UnifyInfo.Comparison comparison, @NotNull UnifyInfo info) implements CubicalError
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return this.info.describeUnify(options, this.comparison, Doc.english((String)"The boundary"), Doc.english((String)"disagrees with"));
        }
    }
}

