/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.error;

import kala.collection.SeqLike;
import kala.collection.immutable.ImmutableSeq;
import org.aya.core.def.FieldDef;
import org.aya.prettier.BasePrettier;
import org.aya.pretty.doc.Doc;
import org.aya.ref.AnyVar;
import org.aya.tyck.error.TyckError;
import org.aya.util.error.SourcePos;
import org.aya.util.prettier.PrettierOptions;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface FieldError
extends TyckError {

    public record ArgMismatch(@NotNull SourcePos sourcePos, @NotNull FieldDef fieldDef, int supplied) implements FieldError
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"Expected"), Doc.plain((String)String.valueOf(((FieldDef)this.fieldDef.ref.core).selfTele.size())), Doc.english((String)"arguments, but found"), Doc.plain((String)String.valueOf(this.supplied)), Doc.english((String)"arguments for field"), BasePrettier.linkRef(this.fieldDef.ref, BasePrettier.FIELD)});
        }
    }

    public record UnknownField(@NotNull SourcePos sourcePos, @NotNull String name) implements FieldError
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"Unknown field"), Doc.code((Doc)Doc.plain((String)this.name)), Doc.english((String)"projected")});
        }
    }

    public record NoSuchField(@NotNull SourcePos sourcePos, @NotNull ImmutableSeq<String> notFound) implements FieldError
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"No such field(s):"), Doc.commaList((SeqLike)this.notFound.view().map(m -> Doc.code((Doc)Doc.plain((String)m))))});
        }
    }

    public record MissingField(@NotNull SourcePos sourcePos, @NotNull ImmutableSeq<AnyVar> missing) implements FieldError
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"Missing field(s):"), Doc.commaList((SeqLike)this.missing.view().map(BasePrettier::varDoc).map(Doc::code))});
        }
    }
}

