/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.error;

import org.aya.concrete.Expr;
import org.aya.concrete.stmt.decl.TeleDecl;
import org.aya.core.term.SortTerm;
import org.aya.core.term.Term;
import org.aya.generic.ExprProblem;
import org.aya.pretty.doc.Doc;
import org.aya.tyck.error.TyckError;
import org.aya.tyck.error.UnifyInfo;
import org.aya.util.error.SourcePos;
import org.aya.util.prettier.PrettierOptions;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface UnifyError
extends TyckError {

    public record PiDom(@NotNull Expr expr, Term result, SortTerm sort) implements UnifyError,
    ExprProblem
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.vcat((Doc[])new Doc[]{Doc.english((String)"The type"), Doc.par((int)1, (Doc)this.result.toDoc(options)), Doc.english((String)"is in the domain of a function whose type is"), Doc.par((int)1, (Doc)this.sort.toDoc(options))});
        }
    }

    public record ConReturn(@NotNull TeleDecl.DataCtor ctor, @NotNull UnifyInfo.Comparison comparison, @NotNull UnifyInfo info) implements UnifyError
    {
        @NotNull
        public SourcePos sourcePos() {
            return this.ctor.sourcePos();
        }

        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            Doc prologue = Doc.vcat((Doc[])new Doc[]{Doc.english((String)"Cannot make sense of the return type of the constructor"), Doc.par((int)1, (Doc)this.ctor.toDoc(options)), Doc.english((String)"which eventually returns")});
            return this.info.describeUnify(options, this.comparison, prologue, Doc.english((String)"while it should return"));
        }
    }

    public record Type(@NotNull Expr expr, @NotNull UnifyInfo.Comparison comparison, @NotNull UnifyInfo info) implements ExprProblem,
    UnifyError
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            Doc prologue = Doc.vcat((Doc[])new Doc[]{Doc.english((String)"Cannot check the expression"), Doc.par((int)1, (Doc)this.expr.toDoc(options)), Doc.english((String)"of type")});
            return this.info.describeUnify(options, this.comparison, prologue, Doc.english((String)"against the type"));
        }
    }
}

