/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.trace;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import kala.collection.SeqLike;
import kala.collection.mutable.MutableList;
import org.aya.prettier.AyaPrettierOptions;
import org.aya.prettier.BasePrettier;
import org.aya.pretty.doc.Doc;
import org.aya.tyck.trace.Trace;
import org.aya.util.prettier.PrettierOptions;
import org.jetbrains.annotations.NotNull;

public class MarkdownTrace {
    public final int indent;
    @NotNull
    public final PrettierOptions options;
    @NotNull
    public static final Doc plus = Doc.symbol((String)"+");
    @NotNull
    public static final Doc colon = Doc.symbol((String)":");
    @NotNull
    private final Doc vdash;
    @NotNull
    private final Doc equiv;
    @NotNull
    private final Doc uparr;

    public MarkdownTrace(int indent, @NotNull PrettierOptions options, boolean asciiOnly) {
        this.indent = indent;
        this.options = options;
        this.vdash = asciiOnly ? Doc.symbol((String)"|-") : Doc.symbol((String)"\u22a2");
        this.equiv = asciiOnly ? Doc.symbol((String)"==") : Doc.symbol((String)"\u2261");
        this.uparr = asciiOnly ? Doc.symbol((String)"^") : Doc.symbol((String)"\u2191");
    }

    public MarkdownTrace() {
        this(2, AyaPrettierOptions.informative(), false);
    }

    @NotNull
    private Doc indentedChildren(MutableList<@NotNull Trace> children) {
        return Doc.nest((int)this.indent, (Doc)Doc.vcatNonEmpty((SeqLike)children.view().map(this::docify)));
    }

    @NotNull
    public Doc docify(@NotNull Trace trace) {
        Trace trace2 = trace;
        Objects.requireNonNull(trace2);
        Trace trace3 = trace2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Trace.DeclT.class, Trace.LabelT.class, Trace.ExprT.class, Trace.PatT.class, Trace.TyckT.class, Trace.UnifyT.class}, (Object)trace3, n)) {
            default -> throw new RuntimeException(null, null);
            case 0 -> {
                Trace.DeclT t = (Trace.DeclT)trace3;
                yield Doc.vcatNonEmpty((Doc[])new Doc[]{Doc.sep((Doc[])new Doc[]{plus, BasePrettier.varDoc(t.var())}), this.indentedChildren(t.children())});
            }
            case 1 -> {
                Trace.LabelT t = (Trace.LabelT)trace3;
                yield Doc.vcatNonEmpty((Doc[])new Doc[]{Doc.sep((Doc[])new Doc[]{plus, Doc.english((String)t.label())}), this.indentedChildren(t.children())});
            }
            case 2 -> {
                Trace.ExprT t = (Trace.ExprT)trace3;
                MutableList buf = MutableList.of((Object)plus, (Object)this.vdash, (Object)Doc.code((Doc)t.expr().toDoc(this.options)));
                if (t.term() != null) {
                    buf.append((Object)colon);
                    buf.append((Object)Doc.code((Doc)t.term().toDoc(this.options)));
                }
                yield Doc.vcatNonEmpty((Doc[])new Doc[]{Doc.sep((SeqLike)buf), this.indentedChildren(t.children())});
            }
            case 3 -> {
                Trace.PatT t = (Trace.PatT)trace3;
                yield Doc.vcatNonEmpty((Doc[])new Doc[]{Doc.sep((Doc[])new Doc[]{plus, Doc.plain((String)"pat"), this.vdash, Doc.code((Doc)t.pat().toDoc(this.options)), colon, Doc.code((Doc)t.type().toDoc(this.options))}), this.indentedChildren(t.children())});
            }
            case 4 -> {
                Trace.TyckT t = (Trace.TyckT)trace3;
                if (!$assertionsDisabled && !t.children().isEmpty()) {
                    throw new AssertionError();
                }
                yield Doc.sep((Doc[])new Doc[]{plus, Doc.plain((String)"result"), this.vdash, Doc.code((Doc)t.term().toDoc(this.options)), this.uparr, Doc.code((Doc)t.type().toDoc(this.options))});
            }
            case 5 -> {
                Trace.UnifyT t = (Trace.UnifyT)trace3;
                MutableList buf = MutableList.of((Object)plus, (Object)this.vdash, (Object)Doc.code((Doc)t.lhs().toDoc(this.options)), (Object)this.equiv, (Object)Doc.code((Doc)t.rhs().toDoc(this.options)));
                if (t.type() != null) {
                    buf.append((Object)colon);
                    buf.append((Object)Doc.code((Doc)t.type().toDoc(this.options)));
                }
                yield Doc.vcatNonEmpty((Doc[])new Doc[]{Doc.sep((SeqLike)buf), this.indentedChildren(t.children())});
            }
        };
    }

    @NotNull
    public Doc docify(@NotNull Trace.Builder traceBuilder) {
        return Doc.vcatNonEmpty((SeqLike)traceBuilder.root().view().map(this::docify));
    }
}

