/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.tycker;

import java.util.Comparator;
import java.util.function.Function;
import java.util.function.Supplier;
import kala.collection.mutable.MutableTreeSet;
import kala.value.LazyValue;
import org.aya.concrete.Expr;
import org.aya.core.term.RefTerm;
import org.aya.core.term.Term;
import org.aya.core.visitor.Zonker;
import org.aya.guest0x0.cubical.Partial;
import org.aya.tyck.Result;
import org.aya.tyck.env.MapLocalCtx;
import org.aya.tyck.trace.Trace;
import org.aya.tyck.tycker.MockTycker;
import org.aya.tyck.tycker.TyckState;
import org.aya.util.error.SourceNode;
import org.aya.util.reporter.Reporter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class ConcreteAwareTycker
extends MockTycker {
    @NotNull
    public final MutableTreeSet<Expr.WithTerm> withTerms = MutableTreeSet.create(Comparator.comparing(SourceNode::sourcePos));

    protected ConcreteAwareTycker(@NotNull Reporter reporter, @Nullable Trace.Builder traceBuilder, @NotNull TyckState state) {
        super(reporter, traceBuilder, state, new MapLocalCtx());
    }

    public void solveMetas() {
        this.state.solveMetas(this.reporter, this.traceBuilder);
        this.withTerms.forEach(w -> w.theCore().update(r -> r.freezeHoles(this.state)));
    }

    @NotNull
    public Term zonk(@NotNull Term term) {
        this.solveMetas();
        return Zonker.make(this).apply(term);
    }

    @NotNull
    public Result zonk(@NotNull Result result) {
        return new Result.Default(this.zonk(result.wellTyped()), this.zonk(result.type()));
    }

    @NotNull
    public Partial<Term> zonk(@NotNull Partial<Term> term) {
        this.solveMetas();
        return term.fmap((Function)Zonker.make(this));
    }

    protected final <R extends Result> R traced(@NotNull Supplier<Trace> trace, @NotNull Expr expr, @NotNull Function<Expr, R> tyck) {
        this.tracing(builder -> builder.shift((Trace)trace.get()));
        Result result = (Result)tyck.apply(expr);
        this.traceExit(result, expr);
        return (R)result;
    }

    protected final void traceExit(Result result, @NotNull Expr expr) {
        Expr.Lift lift;
        Expr expr2;
        LazyValue frozen = LazyValue.of(() -> result.freezeHoles(this.state));
        this.tracing(builder -> {
            builder.append(new Trace.TyckT((Result)frozen.get(), expr.sourcePos()));
            builder.reduce();
        });
        if (expr instanceof Expr.WithTerm) {
            Expr.WithTerm wt = (Expr.WithTerm)((Object)expr);
            this.addWithTerm(wt, (Result)frozen.get());
        }
        if (expr instanceof Expr.Lift && (expr2 = (lift = (Expr.Lift)expr).expr()) instanceof Expr.WithTerm) {
            Expr.WithTerm wt = (Expr.WithTerm)((Object)expr2);
            this.addWithTerm(wt, (Result)frozen.get());
        }
    }

    protected final void addWithTerm(@NotNull Expr.WithTerm withTerm, @NotNull Result result) {
        this.withTerms.add((Object)withTerm);
        withTerm.theCore().set((Object)result);
    }

    public final void addWithTerm(@NotNull Expr.Param param, @NotNull Term type) {
        this.addWithTerm((Expr.WithTerm)param, new Result.Default(new RefTerm(param.ref()), type));
    }
}

