/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.tycker;

import java.lang.runtime.SwitchBootstraps;
import java.util.function.Supplier;
import org.aya.core.term.ErrorTerm;
import org.aya.core.term.SortTerm;
import org.aya.core.term.Term;
import org.aya.generic.util.InternalException;
import org.aya.prettier.AyaPrettierOptions;
import org.aya.tyck.trace.Trace;
import org.aya.tyck.tycker.TyckState;
import org.aya.tyck.tycker.UnifiedTycker;
import org.aya.util.reporter.Reporter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class PropTycker
extends UnifiedTycker {
    public boolean inProp = false;

    protected PropTycker(@NotNull Reporter reporter, @Nullable Trace.Builder traceBuilder, @NotNull TyckState state) {
        super(reporter, traceBuilder, state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final <T> T withInProp(boolean inProp, @NotNull Supplier<T> supplier) {
        boolean origin = this.inProp;
        this.inProp = inProp;
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            this.inProp = origin;
        }
    }

    public boolean inProp(@NotNull Term type) {
        Term term = this.synthesizer().tryPress(type);
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SortTerm.class, ErrorTerm.class, Term.class}, (Object)term, n)) {
            case -1 -> false;
            case 0 -> {
                SortTerm sort = (SortTerm)term;
                yield sort.isProp();
            }
            case 1 -> {
                ErrorTerm err = (ErrorTerm)term;
                yield true;
            }
            default -> {
                Term sort = term;
                throw new InternalException("Expected computeType() to produce a sort, got " + type.toDoc(AyaPrettierOptions.pretty()).debugRender() + " : " + sort.toDoc(AyaPrettierOptions.pretty()).debugRender());
            }
        };
    }
}

