/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.tycker;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.aya.core.def.PrimDef;
import org.aya.core.repr.AyaShape;
import org.aya.core.term.ErrorTerm;
import org.aya.core.term.Term;
import org.aya.generic.AyaDocile;
import org.aya.tyck.ExprTycker;
import org.aya.tyck.Result;
import org.aya.tyck.trace.Trace;
import org.aya.util.TreeBuilder;
import org.aya.util.reporter.Problem;
import org.aya.util.reporter.Reporter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class TracedTycker {
    @NotNull
    public final Reporter reporter;
    @Nullable
    public final Trace.Builder traceBuilder;

    protected TracedTycker(@NotNull Reporter reporter, @Nullable Trace.Builder traceBuilder) {
        this.reporter = reporter;
        this.traceBuilder = traceBuilder;
    }

    public void tracing(@NotNull @NotNull Consumer<@NotNull Trace.Builder> consumer) {
        if (this.traceBuilder != null) {
            consumer.accept(this.traceBuilder);
        }
    }

    public <R> R traced(@NotNull @NotNull Supplier<@NotNull Trace> trace, @NotNull Supplier<R> computation) {
        this.tracing(builder -> builder.shift((Trace)trace.get()));
        R res = computation.get();
        this.tracing(TreeBuilder::reduce);
        return res;
    }

    @NotNull
    protected final Result fail(@NotNull AyaDocile expr, @NotNull Problem prob) {
        return this.fail(expr, ErrorTerm.typeOf(expr), prob);
    }

    @NotNull
    protected final Result fail(@NotNull AyaDocile expr, @NotNull Term term, @NotNull Problem prob) {
        this.reporter.report(prob);
        return new Result.Default(new ErrorTerm(expr), term);
    }

    @NotNull
    public ExprTycker newTycker(@NotNull PrimDef.Factory primFactory, @NotNull AyaShape.Factory literalShapes) {
        return new ExprTycker(primFactory, literalShapes, this.reporter, this.traceBuilder);
    }
}

