/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.tycker;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.Function;
import kala.collection.Seq;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableArrayList;
import kala.collection.mutable.MutableList;
import org.aya.concrete.Expr;
import org.aya.core.term.ErrorTerm;
import org.aya.core.term.IntervalTerm;
import org.aya.core.term.LamTerm;
import org.aya.core.term.PAppTerm;
import org.aya.core.term.PLamTerm;
import org.aya.core.term.PathTerm;
import org.aya.core.term.PiTerm;
import org.aya.core.term.RefTerm;
import org.aya.core.term.Term;
import org.aya.core.visitor.Subst;
import org.aya.generic.AyaDocile;
import org.aya.guest0x0.cubical.CofThy;
import org.aya.guest0x0.cubical.Partial;
import org.aya.guest0x0.cubical.Restr;
import org.aya.ref.LocalVar;
import org.aya.tyck.Result;
import org.aya.tyck.env.LocalCtx;
import org.aya.tyck.error.CubicalError;
import org.aya.tyck.error.UnifyError;
import org.aya.tyck.error.UnifyInfo;
import org.aya.tyck.trace.Trace;
import org.aya.tyck.tycker.LetListTycker;
import org.aya.tyck.tycker.TyckState;
import org.aya.tyck.unify.TermComparator;
import org.aya.tyck.unify.Unifier;
import org.aya.util.Arg;
import org.aya.util.Ordering;
import org.aya.util.error.SourcePos;
import org.aya.util.reporter.Problem;
import org.aya.util.reporter.Reporter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class UnifiedTycker
extends LetListTycker {
    protected UnifiedTycker(@NotNull Reporter reporter, @Nullable Trace.Builder traceBuilder, @NotNull TyckState state) {
        super(reporter, traceBuilder, state);
    }

    public boolean unifyTyReported(@NotNull Term upper, @NotNull Term lower, Expr loc) {
        return this.unifyTyReported(upper, lower, loc, unification -> new UnifyError.Type(loc, (UnifyInfo.Comparison)unification, new UnifyInfo(this.state)));
    }

    public boolean unifyTyReported(@NotNull Term upper, @NotNull Term lower, Expr loc, Function<UnifyInfo.Comparison, Problem> p) {
        TermComparator.FailureData unification = this.unifyTy(upper, lower, loc.sourcePos());
        if (unification != null) {
            this.reporter.report(p.apply(new UnifyInfo.Comparison(lower.freezeHoles(this.state), upper.freezeHoles(this.state), unification)));
        }
        return unification == null;
    }

    protected final Result inheritFallbackUnify(@NotNull Term upper, @NotNull Result result, Expr loc) {
        Result inst = this.instImplicits(result, loc.sourcePos());
        Term term = inst.wellTyped();
        Term lower = inst.type();
        Term upperWHNF = this.whnf(upper);
        if (upperWHNF instanceof PathTerm) {
            PathTerm path = (PathTerm)upperWHNF;
            Result.Default res = this.tryEtaCompatiblePath(loc, term, lower, path);
            if (res != null) {
                return res;
            }
        } else {
            PiTerm pi;
            PathTerm cube;
            Term res = this.whnf(lower);
            if (res instanceof PathTerm && (cube = (PathTerm)res).params().sizeEquals(1) && upperWHNF instanceof PiTerm && (pi = (PiTerm)upperWHNF).param().explicit() && pi.param().type() == IntervalTerm.INSTANCE) {
                RefTerm lamBind = new RefTerm(new LocalVar(((LocalVar)cube.params().first()).name()));
                PAppTerm body = new PAppTerm(term, cube, new Arg((Object)lamBind, true));
                Result inner = this.inheritFallbackUnify(pi.substBody(lamBind), new Result.Default(body, cube.substType((SeqView<Term>)SeqView.of((Object)lamBind))), loc);
                LamTerm.Param lamParam = new LamTerm.Param(lamBind.var(), true);
                return new Result.Default(new LamTerm(lamParam, inner.wellTyped()), pi);
            }
        }
        if (this.unifyTyReported(upper, lower, loc)) {
            return inst;
        }
        return this.error(term.freezeHoles(this.state), upper.freezeHoles(this.state));
    }

    @NotNull
    protected final Result error(@NotNull AyaDocile expr, @NotNull Term term) {
        return new Result.Default(new ErrorTerm(expr), term);
    }

    public boolean unifyReported(@NotNull Term lhs, @NotNull Term rhs, @NotNull Term ty, @NotNull SourcePos pos, @NotNull LocalCtx ctx, Function<UnifyInfo.Comparison, Problem> p) {
        TermComparator.FailureData unification;
        this.tracing(builder -> builder.append(new Trace.UnifyT(lhs.freezeHoles(this.state), rhs.freezeHoles(this.state), pos)));
        Unifier unifier = this.unifier(pos, Ordering.Eq, ctx);
        boolean success = unifier.compare(lhs, rhs, ty);
        TermComparator.FailureData failureData = unification = success ? null : unifier.getFailure();
        if (!success) {
            this.reporter.report(p.apply(new UnifyInfo.Comparison(lhs.freezeHoles(this.state), rhs.freezeHoles(this.state), unification)));
        }
        return success;
    }

    public boolean unifyReported(@NotNull Term lhs, @NotNull Term rhs, @NotNull Term ty, Expr loc, Function<UnifyInfo.Comparison, Problem> p) {
        return this.unifyReported(lhs, rhs, ty, loc.sourcePos(), this.ctx, p);
    }

    protected final void confluence(@NotNull ImmutableSeq<Restr.Side<Term>> clauses, @NotNull Expr loc, @NotNull Term type) {
        for (int i = 1; i < clauses.size(); ++i) {
            Restr.Side lhs = (Restr.Side)clauses.get(i);
            for (int j = 0; j < i; ++j) {
                Restr.Side rhs = (Restr.Side)clauses.get(j);
                CofThy.conv((Restr.Conj)lhs.cof().and(rhs.cof()), (CofThy.SubstObj)new Subst(), subst -> this.boundary(loc, (Term)lhs.u(), (Term)rhs.u(), type, (Subst)subst));
            }
        }
    }

    protected final Result.Default checkBoundaries(Expr expr, PathTerm path, Subst subst, Term lambda) {
        Term applied = path.applyDimsTo(lambda);
        return this.ctx.withIntervals((SeqView<LocalVar>)path.params().view(), () -> {
            Partial<Term> partial = path.partial();
            Objects.requireNonNull(partial);
            Partial<Term> partial2 = partial;
            int n = 0;
            boolean happy = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Partial.Const.class, Partial.Split.class}, partial2, n)) {
                default -> throw new RuntimeException(null, null);
                case 0 -> {
                    Partial.Const sad = (Partial.Const)partial2;
                    yield this.boundary(expr, applied, (Term)sad.u(), path.type(), subst);
                }
                case 1 -> {
                    Partial.Split hap = (Partial.Split)partial2;
                    yield hap.clauses().allMatch(c -> CofThy.conv((Restr.Conj)c.cof(), (CofThy.SubstObj)subst, s -> this.boundary(expr, applied, (Term)c.u(), path.type(), (Subst)s)));
                }
            };
            return happy ? new Result.Default(new PLamTerm(path.params(), applied), path) : new Result.Default(ErrorTerm.unexpected(expr), path);
        });
    }

    @Nullable
    private Result.Default tryEtaCompatiblePath(Expr loc, Term term, Term lower, PathTerm path) {
        Result.Default default_;
        int sizeLimit = path.params().size();
        MutableArrayList list = MutableArrayList.create((int)sizeLimit);
        Result.Default innerMost = PiTerm.unpiOrPath(lower, term, this::whnf, (MutableList<LocalVar>)list, sizeLimit);
        if (!list.sizeEquals(sizeLimit)) {
            return null;
        }
        this.unifyTyReported(path.computePi(), PiTerm.makeIntervals((Seq<LocalVar>)list, innerMost.type()), loc);
        Result.Default checked = this.checkBoundaries(loc, path, new Subst(), LamTerm.makeIntervals((Seq<LocalVar>)list, innerMost.wellTyped()));
        if (lower instanceof PathTerm) {
            PathTerm actualPath = (PathTerm)lower;
            default_ = new Result.Default(actualPath.eta(checked.wellTyped()), actualPath);
        } else {
            default_ = new Result.Default(path.eta(checked.wellTyped()), checked.type());
        }
        return default_;
    }

    private boolean boundary(@NotNull Expr loc, @NotNull Term lhs, @NotNull Term rhs, @NotNull Term type, Subst subst) {
        return this.unifyReported(lhs.subst(subst), rhs.subst(subst), type.subst(subst), loc, comparison -> new CubicalError.BoundaryDisagree(loc, (UnifyInfo.Comparison)comparison, new UnifyInfo(this.state)));
    }

    protected final TermComparator.FailureData unifyTy(@NotNull Term upper, @NotNull Term lower, @NotNull SourcePos pos) {
        this.tracing(builder -> builder.append(new Trace.UnifyT(lower.freezeHoles(this.state), upper.freezeHoles(this.state), pos)));
        Unifier unifier = this.unifier(pos, Ordering.Lt);
        if (!unifier.compare(lower, upper, null)) {
            return unifier.getFailure();
        }
        return null;
    }
}

