/*
 * Decompiled with CFR 0.152.
 */
package org.aya.concrete;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import kala.control.Either;
import kala.function.TriFunction;
import kala.tuple.Tuple2;
import kala.value.MutableValue;
import org.aya.concrete.Pattern;
import org.aya.concrete.stmt.Command;
import org.aya.concrete.stmt.QualifiedID;
import org.aya.concrete.stmt.Stmt;
import org.aya.concrete.stmt.UseHide;
import org.aya.generic.AyaDocile;
import org.aya.generic.Nested;
import org.aya.generic.ParamLike;
import org.aya.generic.SortKind;
import org.aya.guest0x0.cubical.Restr;
import org.aya.prettier.BasePrettier;
import org.aya.prettier.ConcretePrettier;
import org.aya.pretty.doc.Doc;
import org.aya.ref.AnyVar;
import org.aya.ref.LocalVar;
import org.aya.resolve.context.ModuleContext;
import org.aya.resolve.context.ModuleName;
import org.aya.resolve.visitor.ExprResolver;
import org.aya.tyck.Result;
import org.aya.util.BinOpElem;
import org.aya.util.error.SourceNode;
import org.aya.util.error.SourcePos;
import org.aya.util.error.WithPos;
import org.aya.util.prettier.PrettierOptions;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Expr
extends AyaDocile,
SourceNode,
Restr.TermLike<Expr> {
    @NotNull
    public Expr descent(@NotNull @NotNull UnaryOperator<@NotNull Expr> var1);

    @Contract(pure=true)
    default public Expr resolveLax(@NotNull ModuleContext context) {
        ExprResolver resolver = new ExprResolver(context, ExprResolver.LAX);
        resolver.enterBody();
        Expr inner = resolver.apply(this);
        SeqView view = resolver.allowedGeneralizes().valuesView().toImmutableSeq().view();
        return Expr.buildLam(this.sourcePos(), (SeqView<Param>)view, inner);
    }

    @Override
    @NotNull
    default public Doc toDoc(@NotNull PrettierOptions options) {
        return new ConcretePrettier(options).term(BasePrettier.Outer.Free, this);
    }

    @NotNull
    public static Expr app(@NotNull Expr function, @NotNull SeqView<WithPos<NamedArg>> arguments) {
        return (Expr)arguments.foldLeft((Object)function, (f, arg) -> new App(arg.sourcePos(), (Expr)f, (NamedArg)arg.data()));
    }

    @NotNull
    public static Expr unapp(@NotNull Expr expr, @Nullable MutableList<NamedArg> args) {
        while (expr instanceof App) {
            App app = (App)expr;
            if (args != null) {
                args.append((Object)app.argument);
            }
            expr = app.function;
        }
        if (args != null) {
            args.reverse();
        }
        return expr;
    }

    @NotNull
    public static Expr buildPi(@NotNull SourcePos sourcePos, @NotNull SeqView<Param> params, @NotNull Expr body) {
        return Expr.buildNested(sourcePos, params, body, Pi::new);
    }

    @NotNull
    public static Expr buildLam(@NotNull SourcePos sourcePos, @NotNull SeqView<Param> params, @NotNull Expr body) {
        return Expr.buildNested(sourcePos, params, body, Lambda::new);
    }

    @NotNull
    public static Expr buildLet(@NotNull SourcePos sourcePos, @NotNull SeqView<LetBind> binds, @NotNull Expr body) {
        return Expr.buildNested(sourcePos, binds, body, Let::new);
    }

    @NotNull
    public static <P extends SourceNode> Expr buildNested(@NotNull SourcePos sourcePos, @NotNull SeqView<P> params, @NotNull Expr body, @NotNull TriFunction<SourcePos, P, Expr, Expr> constructor) {
        if (params.isEmpty()) {
            return body;
        }
        SeqView drop = params.drop(1);
        SourcePos subPos = body.sourcePos().sourcePosForSubExpr(sourcePos.file(), drop.map(SourceNode::sourcePos));
        return (Expr)constructor.apply((Object)sourcePos, (Object)((SourceNode)params.getFirst()), (Object)Expr.buildNested(subPos, drop, body, constructor));
    }

    public record App(@NotNull SourcePos sourcePos, @NotNull Expr function, @NotNull NamedArg argument) implements Expr
    {
        @NotNull
        public App update(@NotNull Expr function, @NotNull NamedArg argument) {
            return function == this.function() && argument == this.argument() ? this : new App(this.sourcePos, function, argument);
        }

        @Override
        @NotNull
        public App descent(@NotNull @NotNull UnaryOperator<@NotNull Expr> f) {
            return this.update((Expr)f.apply(this.function), this.argument.descent(f));
        }
    }

    public static final class NamedArg
    extends Record
    implements AyaDocile,
    SourceNode,
    BinOpElem<Expr> {
        private final boolean explicit;
        @Nullable
        private final String name;
        @NotNull
        private final Expr term;

        public NamedArg(boolean explicit, @NotNull Expr expr) {
            this(explicit, null, expr);
        }

        public NamedArg(boolean explicit, @Nullable String name, @NotNull Expr term) {
            this.explicit = explicit;
            this.name = name;
            this.term = term;
        }

        @NotNull
        public NamedArg update(@NotNull Expr expr) {
            return expr == this.term() ? this : new NamedArg(this.explicit, this.name, expr);
        }

        @NotNull
        public NamedArg descent(@NotNull @NotNull Function<@NotNull Expr, @NotNull Expr> f) {
            return this.update(f.apply(this.term));
        }

        @Override
        @NotNull
        public Doc toDoc(@NotNull PrettierOptions options) {
            Doc doc = this.name == null ? this.term.toDoc(options) : Doc.braced((Doc)Doc.sep((Doc[])new Doc[]{Doc.plain((String)this.name), Doc.symbol((String)"=>"), this.term.toDoc(options)}));
            return Doc.bracedUnless((Doc)doc, (boolean)this.explicit);
        }

        @NotNull
        public SourcePos sourcePos() {
            return this.term.sourcePos();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{NamedArg.class, "explicit;name;term", "explicit", "name", "term"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{NamedArg.class, "explicit;name;term", "explicit", "name", "term"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{NamedArg.class, "explicit;name;term", "explicit", "name", "term"}, this, o);
        }

        public boolean explicit() {
            return this.explicit;
        }

        @Nullable
        public String name() {
            return this.name;
        }

        @NotNull
        public Expr term() {
            return this.term;
        }
    }

    public record LetOpen(@NotNull SourcePos sourcePos, @NotNull ModuleName.Qualified componentName, @NotNull UseHide useHide, @NotNull Expr body) implements Expr
    {
        @NotNull
        public LetOpen update(@NotNull Expr body) {
            return this.body == body ? this : new LetOpen(this.sourcePos, this.componentName, this.useHide, body);
        }

        @Override
        @NotNull
        public Expr descent(@NotNull @NotNull UnaryOperator<@NotNull Expr> f) {
            return this.update((Expr)f.apply(this.body));
        }

        @NotNull
        public Command.Open openCmd() {
            return new Command.Open(this.sourcePos, Stmt.Accessibility.Private, this.componentName, this.useHide, false, true);
        }
    }

    public record LetBind(@NotNull SourcePos sourcePos, @NotNull LocalVar bindName, @NotNull ImmutableSeq<Param> telescope, @NotNull Expr result, @NotNull Expr definedAs) implements SourceNode
    {
        @NotNull
        public LetBind update(@NotNull ImmutableSeq<Param> telescope, @NotNull Expr result, @NotNull Expr definedAs) {
            return this.telescope().sameElements(telescope, true) && this.result() == result && this.definedAs() == definedAs ? this : new LetBind(this.sourcePos, this.bindName, telescope, result, definedAs);
        }

        @NotNull
        public LetBind descent(@NotNull @NotNull UnaryOperator<@NotNull Expr> f) {
            return this.update((ImmutableSeq<Param>)this.telescope().map(x -> x.descent(f)), (Expr)f.apply(this.result()), (Expr)f.apply(this.definedAs()));
        }
    }

    public static final class Let
    extends Record
    implements Expr,
    Nested<LetBind, Expr, Let> {
        @NotNull
        private final SourcePos sourcePos;
        @NotNull
        private final LetBind bind;
        @NotNull
        private final Expr body;

        public Let(@NotNull SourcePos sourcePos, @NotNull LetBind bind, @NotNull Expr body) {
            this.sourcePos = sourcePos;
            this.bind = bind;
            this.body = body;
        }

        @Override
        @NotNull
        public LetBind param() {
            return this.bind;
        }

        @NotNull
        public Let update(@NotNull LetBind bind, @NotNull Expr body) {
            return this.bind() == bind && this.body() == body ? this : new Let(this.sourcePos(), bind, body);
        }

        @Override
        @NotNull
        public Expr descent(@NotNull @NotNull UnaryOperator<@NotNull Expr> f) {
            return this.update(this.bind().descent(f), (Expr)f.apply(this.body()));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Let.class, "sourcePos;bind;body", "sourcePos", "bind", "body"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Let.class, "sourcePos;bind;body", "sourcePos", "bind", "body"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Let.class, "sourcePos;bind;body", "sourcePos", "bind", "body"}, this, o);
        }

        @NotNull
        public SourcePos sourcePos() {
            return this.sourcePos;
        }

        @NotNull
        public LetBind bind() {
            return this.bind;
        }

        @Override
        @NotNull
        public Expr body() {
            return this.body;
        }
    }

    public record Array(@NotNull SourcePos sourcePos, @NotNull Either<CompBlock, ElementList> arrayBlock) implements Expr
    {
        @NotNull
        public Array update(@NotNull Either<CompBlock, ElementList> arrayBlock) {
            if (arrayBlock.isLeft() && this.arrayBlock().isLeft() && arrayBlock.getLeftValue() == this.arrayBlock().getLeftValue()) {
                return this;
            }
            if (arrayBlock.isRight() && this.arrayBlock().isRight() && arrayBlock.getRightValue() == this.arrayBlock().getRightValue()) {
                return this;
            }
            return new Array(this.sourcePos, arrayBlock);
        }

        @Override
        @NotNull
        public Array descent(@NotNull @NotNull UnaryOperator<@NotNull Expr> f) {
            return this.update((Either<CompBlock, ElementList>)this.arrayBlock.map(comp -> comp.descent(f), list -> list.descent(f)));
        }

        public static Array newList(@NotNull SourcePos sourcePos, @NotNull ImmutableSeq<Expr> exprs) {
            return new Array(sourcePos, (Either<CompBlock, ElementList>)Either.right((Object)new ElementList(exprs)));
        }

        public static Array newGenerator(@NotNull SourcePos sourcePos, @NotNull Expr generator, @NotNull ImmutableSeq<DoBind> bindings, @NotNull ListCompNames names) {
            return new Array(sourcePos, (Either<CompBlock, ElementList>)Either.left((Object)new CompBlock(generator, bindings, names)));
        }

        public record ElementList(@NotNull ImmutableSeq<Expr> exprList) {
            @NotNull
            public ElementList update(@NotNull ImmutableSeq<Expr> exprList) {
                return exprList.sameElements(this.exprList(), true) ? this : new ElementList(exprList);
            }

            @NotNull
            public ElementList descent(@NotNull @NotNull UnaryOperator<@NotNull Expr> f) {
                return this.update((ImmutableSeq<Expr>)this.exprList.map(f));
            }
        }

        public record CompBlock(@NotNull Expr generator, @NotNull ImmutableSeq<DoBind> binds, @NotNull ListCompNames names) {
            @NotNull
            public CompBlock update(@NotNull Expr generator, @NotNull ImmutableSeq<DoBind> binds, @NotNull ListCompNames names) {
                return generator == this.generator() && binds.sameElements(this.binds(), true) && names.identical(this.names()) ? this : new CompBlock(generator, binds, names);
            }

            @NotNull
            public CompBlock descent(@NotNull @NotNull UnaryOperator<@NotNull Expr> f) {
                return this.update((Expr)f.apply(this.generator), (ImmutableSeq<DoBind>)this.binds.map(bind -> bind.descent(f)), this.names.fmap(f));
            }
        }

        public record ListCompNames(@NotNull Expr monadBind, @NotNull Expr functorPure) {
            public ListCompNames fmap(@NotNull Function<Expr, Expr> f) {
                return new ListCompNames(f.apply(this.monadBind), f.apply(this.functorPure));
            }

            public boolean identical(@NotNull ListCompNames names) {
                return this.monadBind == names.monadBind && this.functorPure == names.functorPure;
            }
        }
    }

    public static final class Param
    extends Record
    implements ParamLike<Expr>,
    SourceNode,
    WithTerm {
        @NotNull
        private final SourcePos sourcePos;
        @NotNull
        private final LocalVar ref;
        @NotNull
        private final Expr type;
        private final boolean explicit;
        private final MutableValue<Result> theCore;

        public Param(@NotNull SourcePos sourcePos, @NotNull LocalVar var, @NotNull Expr type, boolean explicit) {
            this(sourcePos, var, type, explicit, (MutableValue<Result>)MutableValue.create());
        }

        public Param(@NotNull SourcePos sourcePos, @NotNull LocalVar var, boolean explicit) {
            this(sourcePos, var, new Hole(sourcePos, false, null), explicit, (MutableValue<Result>)MutableValue.create());
        }

        public Param(@NotNull SourcePos sourcePos, @NotNull LocalVar ref, @NotNull Expr type, boolean explicit, MutableValue<Result> theCore) {
            this.sourcePos = sourcePos;
            this.ref = ref;
            this.type = type;
            this.explicit = explicit;
            this.theCore = theCore;
        }

        @NotNull
        public Param update(@NotNull Expr type) {
            return type == this.type() ? this : new Param(this.sourcePos, this.ref, type, this.explicit, this.theCore);
        }

        @NotNull
        public Param descent(@NotNull @NotNull Function<@NotNull Expr, @NotNull Expr> f) {
            return this.update(f.apply(this.type));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Param.class, "sourcePos;ref;type;explicit;theCore", "sourcePos", "ref", "type", "explicit", "theCore"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Param.class, "sourcePos;ref;type;explicit;theCore", "sourcePos", "ref", "type", "explicit", "theCore"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Param.class, "sourcePos;ref;type;explicit;theCore", "sourcePos", "ref", "type", "explicit", "theCore"}, this, o);
        }

        @NotNull
        public SourcePos sourcePos() {
            return this.sourcePos;
        }

        @Override
        @NotNull
        public LocalVar ref() {
            return this.ref;
        }

        @Override
        @NotNull
        public Expr type() {
            return this.type;
        }

        @Override
        public boolean explicit() {
            return this.explicit;
        }

        @Override
        public MutableValue<Result> theCore() {
            return this.theCore;
        }
    }

    public record Path(@NotNull SourcePos sourcePos, @NotNull ImmutableSeq<LocalVar> params, @NotNull Expr type, @NotNull PartEl partial) implements Expr
    {
        @NotNull
        public Path update(@NotNull Expr type, @NotNull PartEl partial) {
            return type == this.type() && partial == this.partial() ? this : new Path(this.sourcePos, this.params, type, partial);
        }

        @Override
        @NotNull
        public Path descent(@NotNull @NotNull UnaryOperator<@NotNull Expr> f) {
            return this.update((Expr)f.apply(this.type), (PartEl)this.partial.descent((UnaryOperator)f));
        }
    }

    public record PartEl(@NotNull SourcePos sourcePos, @NotNull ImmutableSeq<Tuple2<Expr, Expr>> clauses) implements Expr
    {
        @NotNull
        public PartEl update(@NotNull ImmutableSeq<Tuple2<Expr, Expr>> clauses) {
            return clauses.allMatchWith(this.clauses(), (l, r) -> l.component1() == r.component1() && l.component2() == r.component2()) ? this : new PartEl(this.sourcePos, clauses);
        }

        @Override
        @NotNull
        public PartEl descent(@NotNull @NotNull UnaryOperator<@NotNull Expr> f) {
            return this.update((ImmutableSeq<Tuple2<Expr, Expr>>)this.clauses.map(cls -> kala.tuple.Tuple.of((Object)((Expr)f.apply((Expr)cls.component1())), (Object)((Expr)f.apply((Expr)cls.component2())))));
        }
    }

    public record BinOpSeq(@NotNull SourcePos sourcePos, @NotNull ImmutableSeq<NamedArg> seq) implements Expr
    {
        @NotNull
        public BinOpSeq update(@NotNull ImmutableSeq<NamedArg> seq) {
            return seq.sameElements(this.seq(), true) ? this : new BinOpSeq(this.sourcePos, seq);
        }

        @Override
        @NotNull
        public BinOpSeq descent(@NotNull @NotNull UnaryOperator<@NotNull Expr> f) {
            return this.update((ImmutableSeq<NamedArg>)this.seq.map(arg -> arg.descent(f)));
        }
    }

    public record LitString(@NotNull SourcePos sourcePos, @NotNull String string) implements Expr
    {
        @Override
        @NotNull
        public LitString descent(@NotNull @NotNull UnaryOperator<@NotNull Expr> f) {
            return this;
        }
    }

    public record LitInt(@NotNull SourcePos sourcePos, int integer) implements Expr
    {
        @Override
        @NotNull
        public LitInt descent(@NotNull @NotNull UnaryOperator<@NotNull Expr> f) {
            return this;
        }
    }

    public record Match(@NotNull SourcePos sourcePos, @NotNull ImmutableSeq<Expr> discriminant, @NotNull ImmutableSeq<Pattern.Clause> clauses) implements Expr
    {
        @NotNull
        public Match update(@NotNull ImmutableSeq<Expr> discriminant, @NotNull ImmutableSeq<Pattern.Clause> clauses) {
            return discriminant.sameElements(this.discriminant(), true) && clauses.sameElements(this.clauses(), true) ? this : new Match(this.sourcePos, discriminant, clauses);
        }

        @Override
        @NotNull
        public Match descent(@NotNull @NotNull UnaryOperator<@NotNull Expr> f) {
            return this.update((ImmutableSeq<Expr>)this.discriminant.map(f), (ImmutableSeq<Pattern.Clause>)this.clauses.map(cl -> cl.descent(f)));
        }

        @NotNull
        public Match descent(@NotNull @NotNull UnaryOperator<@NotNull Expr> f, @NotNull @NotNull UnaryOperator<@NotNull Pattern> g) {
            return this.update((ImmutableSeq<Expr>)this.discriminant.map(f), (ImmutableSeq<Pattern.Clause>)this.clauses.map(cl -> cl.descent(f, g)));
        }
    }

    public record Field<Term extends AyaDocile>(@NotNull SourcePos sourcePos, @NotNull WithPos<String> name, @NotNull ImmutableSeq<WithPos<LocalVar>> bindings, @NotNull Term body, @NotNull MutableValue<AnyVar> resolvedField) {
        @NotNull
        public Field<Term> update(@NotNull Term body) {
            return body == this.body() ? this : new Field<Term>(this.sourcePos, this.name, this.bindings, body, this.resolvedField);
        }

        @NotNull
        public Field<Term> descent(@NotNull @NotNull UnaryOperator<@NotNull Term> f) {
            return this.update((AyaDocile)f.apply(this.body));
        }
    }

    public record New(@NotNull SourcePos sourcePos, @NotNull Expr struct, @NotNull ImmutableSeq<Field<Expr>> fields) implements Expr
    {
        @NotNull
        public New update(@NotNull Expr struct, @NotNull ImmutableSeq<Field<Expr>> fields) {
            return struct == this.struct() && fields.sameElements(this.fields(), true) ? this : new New(this.sourcePos, struct, fields);
        }

        @Override
        @NotNull
        public New descent(@NotNull @NotNull UnaryOperator<@NotNull Expr> f) {
            return this.update((Expr)f.apply(this.struct), (ImmutableSeq<Field<Expr>>)this.fields.map(field -> field.descent(f)));
        }
    }

    public record Proj(@NotNull SourcePos sourcePos, @NotNull Expr tup, @NotNull Either<Integer, QualifiedID> ix, @Nullable AnyVar resolvedVar, @NotNull MutableValue<Result> theCore) implements Expr,
    WithTerm
    {
        public Proj(@NotNull SourcePos sourcePos, @NotNull Expr tup, @NotNull Either<Integer, QualifiedID> ix) {
            this(sourcePos, tup, ix, null, (MutableValue<Result>)MutableValue.create());
        }

        @NotNull
        public Proj update(@NotNull Expr tup) {
            return tup == this.tup() ? this : new Proj(this.sourcePos, tup, this.ix, this.resolvedVar, this.theCore);
        }

        @Override
        @NotNull
        public Proj descent(@NotNull @NotNull UnaryOperator<@NotNull Expr> f) {
            return this.update((Expr)f.apply(this.tup));
        }
    }

    public record Tuple(@NotNull SourcePos sourcePos, @NotNull @NotNull ImmutableSeq<@NotNull Expr> items) implements Expr
    {
        @NotNull
        public Tuple update(@NotNull @NotNull ImmutableSeq<@NotNull Expr> items) {
            return items.sameElements(this.items(), true) ? this : new Tuple(this.sourcePos, items);
        }

        @Override
        @NotNull
        public Tuple descent(@NotNull @NotNull UnaryOperator<@NotNull Expr> f) {
            return this.update((ImmutableSeq<Expr>)this.items.map(f));
        }
    }

    public record ISet(@NotNull SourcePos sourcePos) implements Sort
    {
        @Override
        public int lift() {
            return 0;
        }

        @Override
        public SortKind kind() {
            return SortKind.ISet;
        }
    }

    public record Set(@NotNull SourcePos sourcePos, int lift) implements Sort
    {
        @Override
        public SortKind kind() {
            return SortKind.Set;
        }
    }

    public record Type(@NotNull SourcePos sourcePos, int lift) implements Sort
    {
        @Override
        public SortKind kind() {
            return SortKind.Type;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Sort
    extends Expr {
        public int lift();

        public SortKind kind();

        @Override
        @NotNull
        default public Sort descent(@NotNull @NotNull UnaryOperator<@NotNull Expr> f) {
            return this;
        }
    }

    public record RawSort(@NotNull SourcePos sourcePos, @NotNull SortKind kind) implements Expr
    {
        @Override
        @NotNull
        public RawSort descent(@NotNull @NotNull UnaryOperator<@NotNull Expr> f) {
            return this;
        }
    }

    public record Lift(@NotNull SourcePos sourcePos, @NotNull Expr expr, int lift) implements Expr
    {
        @NotNull
        public Lift update(@NotNull Expr expr) {
            return expr == this.expr() ? this : new Lift(this.sourcePos, expr, this.lift);
        }

        @Override
        @NotNull
        public Lift descent(@NotNull @NotNull UnaryOperator<@NotNull Expr> f) {
            return this.update((Expr)f.apply(this.expr));
        }
    }

    public record Ref(@NotNull SourcePos sourcePos, @NotNull AnyVar resolvedVar, @NotNull MutableValue<Result> theCore) implements Expr,
    WithTerm
    {
        public Ref(@NotNull SourcePos sourcePos, @NotNull AnyVar resolvedVar) {
            this(sourcePos, resolvedVar, (MutableValue<Result>)MutableValue.create());
        }

        @Override
        @NotNull
        public Ref descent(@NotNull @NotNull UnaryOperator<@NotNull Expr> f) {
            return this;
        }
    }

    public record Sigma(@NotNull SourcePos sourcePos, @NotNull @NotNull ImmutableSeq<@NotNull Param> params) implements Expr
    {
        @NotNull
        public Sigma update(@NotNull @NotNull ImmutableSeq<@NotNull Param> params) {
            return params.sameElements(this.params(), true) ? this : new Sigma(this.sourcePos, params);
        }

        @Override
        @NotNull
        public Sigma descent(@NotNull @NotNull UnaryOperator<@NotNull Expr> f) {
            return this.update((ImmutableSeq<Param>)this.params.map(param -> param.descent(f)));
        }
    }

    public static final class Lambda
    extends Record
    implements Expr,
    Nested<Param, Expr, Lambda> {
        @NotNull
        private final SourcePos sourcePos;
        @NotNull
        private final Param param;
        @NotNull
        private final Expr body;

        public Lambda(@NotNull SourcePos sourcePos, @NotNull Param param, @NotNull Expr body) {
            this.sourcePos = sourcePos;
            this.param = param;
            this.body = body;
        }

        @NotNull
        public Lambda update(@NotNull Param param, @NotNull Expr body) {
            return param == this.param() && body == this.body() ? this : new Lambda(this.sourcePos, param, body);
        }

        @Override
        @NotNull
        public Lambda descent(@NotNull @NotNull UnaryOperator<@NotNull Expr> f) {
            return this.update(this.param.descent(f), (Expr)f.apply(this.body));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Lambda.class, "sourcePos;param;body", "sourcePos", "param", "body"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Lambda.class, "sourcePos;param;body", "sourcePos", "param", "body"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Lambda.class, "sourcePos;param;body", "sourcePos", "param", "body"}, this, o);
        }

        @NotNull
        public SourcePos sourcePos() {
            return this.sourcePos;
        }

        @Override
        @NotNull
        public Param param() {
            return this.param;
        }

        @Override
        @NotNull
        public Expr body() {
            return this.body;
        }
    }

    public record IdiomNames(@NotNull Expr alternativeEmpty, @NotNull Expr alternativeOr, @NotNull Expr applicativeAp, @NotNull Expr applicativePure) {
        public IdiomNames fmap(@NotNull Function<Expr, Expr> f) {
            return new IdiomNames(f.apply(this.alternativeEmpty), f.apply(this.alternativeOr), f.apply(this.applicativeAp), f.apply(this.applicativePure));
        }

        public boolean identical(@NotNull IdiomNames names) {
            return this.alternativeEmpty == names.alternativeEmpty && this.alternativeOr == names.alternativeOr && this.applicativeAp == names.applicativeAp && this.applicativePure == names.applicativePure;
        }
    }

    public record Idiom(@NotNull SourcePos sourcePos, @NotNull IdiomNames names, @NotNull ImmutableSeq<Expr> barredApps) implements Expr
    {
        @NotNull
        public Idiom update(@NotNull IdiomNames names, @NotNull ImmutableSeq<Expr> barredApps) {
            return names.identical(this.names()) && barredApps.sameElements(this.barredApps(), true) ? this : new Idiom(this.sourcePos, names, barredApps);
        }

        @Override
        @NotNull
        public Idiom descent(@NotNull @NotNull UnaryOperator<@NotNull Expr> f) {
            return this.update(this.names.fmap(f), (ImmutableSeq<Expr>)this.barredApps.map(f));
        }
    }

    public record DoBind(@NotNull SourcePos sourcePos, @NotNull LocalVar var, @NotNull Expr expr) implements SourceNode
    {
        @NotNull
        public DoBind update(@NotNull Expr expr) {
            return expr == this.expr() ? this : new DoBind(this.sourcePos, this.var, expr);
        }

        @NotNull
        public DoBind descent(@NotNull @NotNull UnaryOperator<@NotNull Expr> f) {
            return this.update((Expr)f.apply(this.expr));
        }
    }

    public record Do(@NotNull SourcePos sourcePos, @NotNull Expr bindName, @NotNull ImmutableSeq<DoBind> binds) implements Expr
    {
        @NotNull
        public Do update(@NotNull Expr bindName, @NotNull ImmutableSeq<DoBind> binds) {
            return bindName == this.bindName() && binds.sameElements(this.binds(), true) ? this : new Do(this.sourcePos, bindName, binds);
        }

        @Override
        @NotNull
        public Do descent(@NotNull @NotNull UnaryOperator<@NotNull Expr> f) {
            return this.update((Expr)f.apply(this.bindName), (ImmutableSeq<DoBind>)this.binds.map(bind -> bind.descent(f)));
        }
    }

    public static final class Pi
    extends Record
    implements Expr,
    Nested<Param, Expr, Pi> {
        @NotNull
        private final SourcePos sourcePos;
        @NotNull
        private final Param param;
        @NotNull
        private final Expr last;

        public Pi(@NotNull SourcePos sourcePos, @NotNull Param param, @NotNull Expr last) {
            this.sourcePos = sourcePos;
            this.param = param;
            this.last = last;
        }

        @Override
        @NotNull
        public Expr body() {
            return this.last;
        }

        @NotNull
        public Pi update(@NotNull Param param, @NotNull Expr last) {
            return param == this.param() && last == this.last() ? this : new Pi(this.sourcePos, param, last);
        }

        @Override
        @NotNull
        public Pi descent(@NotNull @NotNull UnaryOperator<@NotNull Expr> f) {
            return this.update(this.param.descent(f), (Expr)f.apply(this.last));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Pi.class, "sourcePos;param;last", "sourcePos", "param", "last"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Pi.class, "sourcePos;param;last", "sourcePos", "param", "last"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Pi.class, "sourcePos;param;last", "sourcePos", "param", "last"}, this, o);
        }

        @NotNull
        public SourcePos sourcePos() {
            return this.sourcePos;
        }

        @Override
        @NotNull
        public Param param() {
            return this.param;
        }

        @NotNull
        public Expr last() {
            return this.last;
        }
    }

    public record Hole(@NotNull SourcePos sourcePos, boolean explicit, @Nullable Expr filling, MutableValue<ImmutableSeq<LocalVar>> accessibleLocal) implements Expr
    {
        public Hole(@NotNull SourcePos sourcePos, boolean explicit, @Nullable Expr filling) {
            this(sourcePos, explicit, filling, (MutableValue<ImmutableSeq<LocalVar>>)MutableValue.create());
        }

        @NotNull
        public Hole update(@Nullable Expr filling) {
            return filling == this.filling() ? this : new Hole(this.sourcePos, this.explicit, filling);
        }

        @Override
        @NotNull
        public Hole descent(@NotNull @NotNull UnaryOperator<@NotNull Expr> f) {
            return this.update(this.filling == null ? null : (Expr)f.apply(this.filling));
        }
    }

    public record Error(@NotNull SourcePos sourcePos, @NotNull AyaDocile description) implements Expr
    {
        public Error(@NotNull SourcePos sourcePos, @NotNull Doc description) {
            this(sourcePos, (PrettierOptions options) -> description);
        }

        @Override
        @NotNull
        public Error descent(@NotNull @NotNull UnaryOperator<@NotNull Expr> f) {
            return this;
        }
    }

    public record Unresolved(@NotNull SourcePos sourcePos, @NotNull QualifiedID name) implements Expr
    {
        public Unresolved(@NotNull SourcePos sourcePos, @NotNull String name) {
            this(sourcePos, new QualifiedID(sourcePos, name));
        }

        @Override
        @NotNull
        public Unresolved descent(@NotNull @NotNull UnaryOperator<@NotNull Expr> f) {
            return this;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface WithTerm
    extends SourceNode {
        @NotNull
        public MutableValue<Result> theCore();

        @Nullable
        default public Result core() {
            return (Result)this.theCore().get();
        }
    }
}

