/*
 * Decompiled with CFR 0.152.
 */
package org.aya.concrete;

import java.io.IOException;
import java.nio.file.Path;
import kala.collection.immutable.ImmutableSeq;
import org.aya.concrete.GenericAyaParser;
import org.aya.concrete.remark.AyaLiterate;
import org.aya.concrete.stmt.Stmt;
import org.aya.literate.Literate;
import org.aya.util.error.SourceFile;
import org.aya.util.error.SourceFileLocator;
import org.aya.util.error.SourcePos;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.NotNull;

public interface GenericAyaFile {
    @MustBeInvokedByOverriders
    @NotNull
    default public ImmutableSeq<Stmt> parseMe(@NotNull GenericAyaParser parser) throws IOException {
        return parser.program(this.codeFile(), this.originalFile());
    }

    @NotNull
    public SourceFile originalFile() throws IOException;

    @NotNull
    default public SourceFile codeFile() throws IOException {
        return this.originalFile();
    }

    @NotNull
    default public Literate literate() throws IOException {
        String code = this.originalFile().sourceCode();
        SourcePos mockPos = new SourcePos(this.originalFile(), 0, code.length(), -1, -1, -1, -1);
        return new AyaLiterate.AyaVisibleCodeBlock("aya", code, mockPos);
    }

    public static interface Factory {
        @NotNull
        public GenericAyaFile createAyaFile(@NotNull SourceFileLocator var1, @NotNull Path var2) throws IOException;
    }
}

