/*
 * Decompiled with CFR 0.152.
 */
package org.aya.concrete;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.function.UnaryOperator;
import kala.collection.immutable.ImmutableSeq;
import kala.control.Option;
import kala.value.MutableValue;
import org.aya.concrete.Expr;
import org.aya.concrete.stmt.QualifiedID;
import org.aya.core.def.CtorDef;
import org.aya.core.repr.ShapeRecognition;
import org.aya.core.term.DataCall;
import org.aya.core.term.Term;
import org.aya.generic.AyaDocile;
import org.aya.generic.Shaped;
import org.aya.prettier.BasePrettier;
import org.aya.prettier.ConcretePrettier;
import org.aya.pretty.doc.Doc;
import org.aya.ref.AnyVar;
import org.aya.ref.LocalVar;
import org.aya.util.Arg;
import org.aya.util.error.SourceNode;
import org.aya.util.error.SourcePos;
import org.aya.util.error.WithPos;
import org.aya.util.prettier.PrettierOptions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Pattern
extends AyaDocile,
SourceNode {
    @Override
    @NotNull
    default public Doc toDoc(@NotNull PrettierOptions options) {
        return new ConcretePrettier(options).pattern(this, true, BasePrettier.Outer.Free);
    }

    @NotNull
    public Pattern descent(@NotNull @NotNull UnaryOperator<@NotNull Pattern> var1);

    public static final class FakeShapedList
    extends Record
    implements Shaped.List<Pattern> {
        @NotNull
        private final SourcePos sourcePos;
        @NotNull
        private final ImmutableSeq<Pattern> repr;
        @NotNull
        private final ShapeRecognition recognition;
        @NotNull
        private final DataCall type;

        public FakeShapedList(@NotNull SourcePos sourcePos, @NotNull ImmutableSeq<Pattern> repr, @NotNull ShapeRecognition recognition, @NotNull DataCall type) {
            this.sourcePos = sourcePos;
            this.repr = repr;
            this.recognition = recognition;
            this.type = type;
        }

        @Override
        @NotNull
        public Pattern makeNil(@NotNull CtorDef nil, @NotNull Arg<Term> type) {
            return new Ctor(this.sourcePos, (WithPos<AnyVar>)new WithPos(this.sourcePos, nil.ref()), (ImmutableSeq<Arg<Pattern>>)ImmutableSeq.empty());
        }

        @Override
        @NotNull
        public Pattern makeCons(@NotNull CtorDef cons, @NotNull Arg<Term> type, Arg<Pattern> x, Arg<Pattern> xs) {
            return new Ctor(this.sourcePos, (WithPos<AnyVar>)new WithPos(this.sourcePos, cons.ref()), (ImmutableSeq<Arg<Pattern>>)ImmutableSeq.of(x, xs));
        }

        @Override
        @NotNull
        public Pattern destruct(@NotNull ImmutableSeq<Pattern> repr) {
            return (Pattern)new FakeShapedList(this.sourcePos, repr, this.recognition, this.type).constructorForm();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{FakeShapedList.class, "sourcePos;repr;recognition;type", "sourcePos", "repr", "recognition", "type"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{FakeShapedList.class, "sourcePos;repr;recognition;type", "sourcePos", "repr", "recognition", "type"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{FakeShapedList.class, "sourcePos;repr;recognition;type", "sourcePos", "repr", "recognition", "type"}, this, o);
        }

        @NotNull
        public SourcePos sourcePos() {
            return this.sourcePos;
        }

        @Override
        @NotNull
        public ImmutableSeq<Pattern> repr() {
            return this.repr;
        }

        @Override
        @NotNull
        public ShapeRecognition recognition() {
            return this.recognition;
        }

        @Override
        @NotNull
        public DataCall type() {
            return this.type;
        }
    }

    public static final class Clause
    implements SourceNode {
        @NotNull
        public final SourcePos sourcePos;
        @NotNull
        public final ImmutableSeq<Arg<Pattern>> patterns;
        @NotNull
        public final Option<Expr> expr;
        public boolean hasError = false;

        public Clause(@NotNull SourcePos sourcePos, @NotNull ImmutableSeq<Arg<Pattern>> patterns, @NotNull Option<Expr> expr) {
            this.sourcePos = sourcePos;
            this.patterns = patterns;
            this.expr = expr;
        }

        @NotNull
        public Clause update(@NotNull ImmutableSeq<Arg<Pattern>> pats, @NotNull Option<Expr> body) {
            return body.sameElements(this.expr, true) && pats.sameElements(this.patterns, true) ? this : new Clause(this.sourcePos, pats, body);
        }

        @NotNull
        public Clause descent(@NotNull @NotNull UnaryOperator<@NotNull Expr> f) {
            return this.update(this.patterns, (Option<Expr>)this.expr.map(f));
        }

        @NotNull
        public Clause descent(@NotNull @NotNull UnaryOperator<@NotNull Expr> f, @NotNull @NotNull UnaryOperator<@NotNull Pattern> g) {
            return this.update((ImmutableSeq<Arg<Pattern>>)this.patterns.map(p -> p.descent(g)), (Option<Expr>)this.expr.map(f));
        }

        @NotNull
        public SourcePos sourcePos() {
            return this.sourcePos;
        }
    }

    public record List(@NotNull SourcePos sourcePos, @NotNull ImmutableSeq<Pattern> elements) implements Pattern
    {
        @NotNull
        public List update(@NotNull ImmutableSeq<Pattern> elements) {
            return elements.sameElements(this.elements(), true) ? this : new List(this.sourcePos, elements);
        }

        @Override
        @NotNull
        public List descent(@NotNull @NotNull UnaryOperator<@NotNull Pattern> f) {
            return this.update((ImmutableSeq<Pattern>)this.elements.map(f));
        }
    }

    public record As(@NotNull SourcePos sourcePos, @NotNull Pattern pattern, @NotNull LocalVar as, @NotNull MutableValue<@Nullable Term> type) implements Pattern
    {
        public static Arg<Pattern> wrap(@NotNull SourcePos pos, @NotNull Arg<Pattern> pattern, @NotNull LocalVar var) {
            return new Arg((Object)new As(pos, (Pattern)pattern.term(), var, (MutableValue<Term>)MutableValue.create()), pattern.explicit());
        }

        @NotNull
        public As update(@NotNull Pattern pattern) {
            return pattern == this.pattern() ? this : new As(this.sourcePos, pattern, this.as, this.type);
        }

        @Override
        @NotNull
        public As descent(@NotNull @NotNull UnaryOperator<@NotNull Pattern> f) {
            return this.update((Pattern)f.apply(this.pattern));
        }
    }

    public record BinOpSeq(@NotNull SourcePos sourcePos, @NotNull ImmutableSeq<Arg<Pattern>> seq) implements Pattern
    {
        @NotNull
        public BinOpSeq update(@NotNull ImmutableSeq<Arg<Pattern>> seq) {
            return seq.sameElements(this.seq(), true) ? this : new BinOpSeq(this.sourcePos, seq);
        }

        @Override
        @NotNull
        public BinOpSeq descent(@NotNull @NotNull UnaryOperator<@NotNull Pattern> f) {
            return this.update((ImmutableSeq<Arg<Pattern>>)this.seq.map(a -> a.descent(f)));
        }
    }

    public record Ctor(@NotNull SourcePos sourcePos, @NotNull @NotNull WithPos<@NotNull AnyVar> resolved, @NotNull ImmutableSeq<Arg<Pattern>> params) implements Pattern
    {
        public Ctor(@NotNull Bind bind, @NotNull AnyVar maybe) {
            this(bind.sourcePos(), (WithPos<AnyVar>)new WithPos(bind.sourcePos(), (Object)maybe), (ImmutableSeq<Arg<Pattern>>)ImmutableSeq.empty());
        }

        public Ctor(@NotNull QualifiedRef qref, @NotNull AnyVar maybe) {
            this(qref.sourcePos(), (WithPos<AnyVar>)new WithPos(qref.sourcePos(), (Object)maybe), (ImmutableSeq<Arg<Pattern>>)ImmutableSeq.empty());
        }

        @NotNull
        public Ctor update(@NotNull ImmutableSeq<Arg<Pattern>> params) {
            return params.sameElements(this.params(), true) ? this : new Ctor(this.sourcePos, this.resolved, params);
        }

        @Override
        @NotNull
        public Ctor descent(@NotNull @NotNull UnaryOperator<@NotNull Pattern> f) {
            return this.update((ImmutableSeq<Arg<Pattern>>)this.params.map(a -> a.descent(f)));
        }
    }

    public record QualifiedRef(@NotNull SourcePos sourcePos, @NotNull QualifiedID qualifiedID, @Nullable Expr userType, @NotNull MutableValue<@Nullable Term> type) implements Pattern
    {
        public QualifiedRef(@NotNull SourcePos sourcePos, @NotNull QualifiedID qualifiedID) {
            this(sourcePos, qualifiedID, null, (MutableValue<Term>)MutableValue.create());
        }

        @Override
        @NotNull
        public QualifiedRef descent(@NotNull @NotNull UnaryOperator<@NotNull Pattern> f) {
            return this;
        }
    }

    public record Bind(@NotNull SourcePos sourcePos, @NotNull LocalVar bind, @Nullable Expr userType, @NotNull MutableValue<@Nullable Term> type) implements Pattern
    {
        public Bind(@NotNull SourcePos sourcePos, @NotNull LocalVar bind) {
            this(sourcePos, bind, null, (MutableValue<Term>)MutableValue.create());
        }

        @Override
        @NotNull
        public Bind descent(@NotNull @NotNull UnaryOperator<@NotNull Pattern> f) {
            return this;
        }
    }

    public record CalmFace(@NotNull SourcePos sourcePos) implements Pattern
    {
        @Override
        @NotNull
        public CalmFace descent(@NotNull @NotNull UnaryOperator<@NotNull Pattern> f) {
            return this;
        }
    }

    public record Absurd(@NotNull SourcePos sourcePos) implements Pattern
    {
        @Override
        @NotNull
        public Absurd descent(@NotNull @NotNull UnaryOperator<@NotNull Pattern> f) {
            return this;
        }
    }

    public record Number(@NotNull SourcePos sourcePos, int number) implements Pattern
    {
        @Override
        @NotNull
        public Number descent(@NotNull @NotNull UnaryOperator<@NotNull Pattern> f) {
            return this;
        }
    }

    public record Tuple(@NotNull SourcePos sourcePos, @NotNull ImmutableSeq<Arg<Pattern>> patterns) implements Pattern
    {
        @NotNull
        public Tuple update(@NotNull ImmutableSeq<Arg<Pattern>> patterns) {
            return patterns.sameElements(this.patterns(), true) ? this : new Tuple(this.sourcePos, patterns);
        }

        @Override
        @NotNull
        public Tuple descent(@NotNull @NotNull UnaryOperator<@NotNull Pattern> f) {
            return this.update((ImmutableSeq<Arg<Pattern>>)this.patterns.map(a -> a.descent(f)));
        }
    }
}

