/*
 * Decompiled with CFR 0.152.
 */
package org.aya.concrete.remark;

import kala.collection.immutable.ImmutableSeq;
import org.aya.concrete.Expr;
import org.aya.concrete.remark.CodeOptions;
import org.aya.literate.Literate;
import org.aya.literate.parser.InterestingLanguage;
import org.aya.pretty.doc.Doc;
import org.aya.pretty.doc.Language;
import org.aya.tyck.Result;
import org.aya.util.error.SourcePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface AyaLiterate {
    @NotNull
    public static final InterestingLanguage<AyaVisibleCodeBlock> VISIBLE_AYA = InterestingLanguage.of("aya"::equalsIgnoreCase, AyaVisibleCodeBlock::new);
    @NotNull
    public static final InterestingLanguage<AyaHiddenCodeBlock> HIDDEN_AYA = InterestingLanguage.of("aya-hidden"::equalsIgnoreCase, AyaHiddenCodeBlock::new);
    @NotNull
    public static final ImmutableSeq<InterestingLanguage<?>> AYA = ImmutableSeq.of(VISIBLE_AYA, HIDDEN_AYA);

    public static final class AyaInlineCode
    extends Literate.InlineCode {
        @Nullable
        public Expr expr;
        @Nullable
        public Result tyckResult;
        @NotNull
        public final CodeOptions options;

        public AyaInlineCode(@NotNull String code, @NotNull SourcePos sourcePos, @NotNull CodeOptions options) {
            super(code, sourcePos);
            this.options = options;
        }

        @NotNull
        public Doc toDoc() {
            if (this.tyckResult == null) {
                if (this.expr != null) {
                    return Doc.code((Language)Language.Builtin.Aya, (Doc)this.expr.toDoc(this.options.options()));
                }
                return Doc.code((String)"Error");
            }
            assert (this.expr != null);
            return Doc.code((Language)Language.Builtin.Aya, (Doc)(switch (this.options.showCode()) {
                default -> throw new RuntimeException(null, null);
                case CodeOptions.ShowCode.Concrete -> this.expr;
                case CodeOptions.ShowCode.Core -> this.tyckResult.wellTyped();
                case CodeOptions.ShowCode.Type -> this.tyckResult.type();
            }).toDoc(this.options.options()));
        }
    }

    public static final class AyaHiddenCodeBlock
    extends AyaCodeBlock {
        public AyaHiddenCodeBlock(@NotNull String language, @NotNull String code, @Nullable SourcePos sourcePos) {
            super(language, code, sourcePos);
        }

        @NotNull
        public Doc toDoc() {
            return Doc.empty();
        }
    }

    public static final class AyaVisibleCodeBlock
    extends AyaCodeBlock {
        public AyaVisibleCodeBlock(@NotNull String language, @NotNull String code, @Nullable SourcePos sourcePos) {
            super(language, code, sourcePos);
        }
    }

    public static class AyaCodeBlock
    extends Literate.CodeBlock {
        public AyaCodeBlock(@NotNull String language, @NotNull String code, @Nullable SourcePos sourcePos) {
            super(language, code, sourcePos);
        }
    }
}

