/*
 * Decompiled with CFR 0.152.
 */
package org.aya.concrete.stmt.decl;

import java.util.EnumSet;
import java.util.function.UnaryOperator;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import kala.control.Option;
import org.aya.concrete.Expr;
import org.aya.concrete.Pattern;
import org.aya.concrete.stmt.BindBlock;
import org.aya.concrete.stmt.Stmt;
import org.aya.concrete.stmt.decl.ClassDecl;
import org.aya.concrete.stmt.decl.CommonDecl;
import org.aya.concrete.stmt.decl.Decl;
import org.aya.concrete.stmt.decl.DeclInfo;
import org.aya.core.def.ClassDef;
import org.aya.core.def.CtorDef;
import org.aya.core.def.DataDef;
import org.aya.core.def.Def;
import org.aya.core.def.FnDef;
import org.aya.core.def.MemberDef;
import org.aya.core.def.PrimDef;
import org.aya.core.term.DataCall;
import org.aya.core.term.SortTerm;
import org.aya.core.term.Term;
import org.aya.generic.Modifier;
import org.aya.ref.DefVar;
import org.aya.resolve.context.Context;
import org.aya.util.Arg;
import org.aya.util.error.SourcePos;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class TeleDecl<RetTy extends Term>
extends CommonDecl {
    @Nullable
    public Expr result;
    @NotNull
    public ImmutableSeq<Expr.Param> telescope;
    @Nullable
    public Def.Signature<RetTy> signature;

    public void modifyResult(@NotNull UnaryOperator<Expr> f) {
        if (this.result != null) {
            this.result = (Expr)f.apply(this.result);
        }
    }

    public void modifyTelescope(@NotNull UnaryOperator<ImmutableSeq<Expr.Param>> f) {
        this.telescope = (ImmutableSeq)f.apply(this.telescope);
    }

    protected TeleDecl(@NotNull DeclInfo info, @NotNull ImmutableSeq<Expr.Param> telescope, @Nullable Expr result) {
        super(info);
        this.result = result;
        this.telescope = telescope;
    }

    @Contract(pure=true)
    @NotNull
    public abstract DefVar<? extends Def, ? extends TeleDecl<RetTy>> ref();

    public static final class FnDecl
    extends TopLevel<Term> {
        @NotNull
        public final EnumSet<Modifier> modifiers;
        @NotNull
        public final DefVar<FnDef, FnDecl> ref;
        public final boolean isAnonymous;
        @NotNull
        public FnBody body;

        public FnDecl(@NotNull DeclInfo info, @NotNull EnumSet<Modifier> modifiers, @NotNull String name, @NotNull ImmutableSeq<Expr.Param> telescope, @Nullable Expr result, @NotNull FnBody body, @NotNull DeclInfo.Personality personality, boolean isAnonymous) {
            super(info, telescope, result, personality);
            assert (!isAnonymous || personality != DeclInfo.Personality.NORMAL);
            this.modifiers = modifiers;
            this.ref = DefVar.concrete(this, name);
            this.isAnonymous = isAnonymous;
            this.body = body;
        }

        @Override
        @NotNull
        public DefVar<FnDef, FnDecl> ref() {
            return this.ref;
        }
    }

    public record BlockBody(ImmutableSeq<Pattern.Clause> clauses) implements FnBody
    {
        @Override
        public BlockBody map(@NotNull UnaryOperator<Expr> f, @NotNull UnaryOperator<Pattern.Clause> g) {
            return new BlockBody((ImmutableSeq<Pattern.Clause>)this.clauses.map(g));
        }
    }

    public record ExprBody(Expr expr) implements FnBody
    {
        @Override
        public ExprBody map(@NotNull UnaryOperator<Expr> f, @NotNull UnaryOperator<Pattern.Clause> g) {
            return new ExprBody((Expr)f.apply(this.expr));
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface FnBody {
        public FnBody map(@NotNull UnaryOperator<Expr> var1, @NotNull UnaryOperator<Pattern.Clause> var2);
    }

    public static final class ClassMember
    extends TeleDecl<Term> {
        @NotNull
        public final DefVar<MemberDef, ClassMember> ref;
        public DefVar<ClassDef, ClassDecl> classDef;
        @NotNull
        public Option<Expr> body;
        public final boolean coerce;

        public ClassMember(@NotNull DeclInfo info, @NotNull String name, @NotNull ImmutableSeq<Expr.Param> telescope, @NotNull Expr result, @NotNull Option<Expr> body, boolean coerce) {
            super(info, telescope, result);
            this.coerce = coerce;
            this.body = body;
            this.ref = DefVar.concrete(this, name);
        }

        @Override
        @NotNull
        public DefVar<MemberDef, ClassMember> ref() {
            return this.ref;
        }
    }

    public static final class DataDecl
    extends TopLevel<SortTerm> {
        @NotNull
        public final DefVar<DataDef, DataDecl> ref;
        @NotNull
        public final ImmutableSeq<DataCtor> body;
        @NotNull
        public final @NotNull MutableList<@NotNull CtorDef> checkedBody = MutableList.create();

        public DataDecl(@NotNull DeclInfo info, @NotNull String name, @NotNull ImmutableSeq<Expr.Param> telescope, @Nullable Expr result, @NotNull ImmutableSeq<DataCtor> body, @NotNull DeclInfo.Personality personality) {
            super(info, telescope, result, personality);
            this.body = body;
            this.ref = DefVar.concrete(this, name);
            body.forEach(ctors -> {
                ctors.dataRef = this.ref;
            });
        }

        @Override
        @NotNull
        public DefVar<DataDef, DataDecl> ref() {
            return this.ref;
        }
    }

    public static final class DataCtor
    extends TeleDecl<DataCall> {
        @NotNull
        public final DefVar<CtorDef, DataCtor> ref;
        public DefVar<DataDef, DataDecl> dataRef;
        @NotNull
        public Expr.PartEl clauses;
        @NotNull
        public ImmutableSeq<Arg<Pattern>> patterns;
        public final boolean coerce;

        public DataCtor(@NotNull DeclInfo info, @NotNull String name, @NotNull ImmutableSeq<Expr.Param> telescope, @NotNull Expr.PartEl clauses, @NotNull ImmutableSeq<Arg<Pattern>> patterns, boolean coerce, @Nullable Expr result) {
            super(info, telescope, result);
            this.clauses = clauses;
            this.coerce = coerce;
            this.patterns = patterns;
            this.ref = DefVar.concrete(this, name);
            this.telescope = telescope;
        }

        @Override
        @NotNull
        public DefVar<CtorDef, DataCtor> ref() {
            return this.ref;
        }
    }

    public static final class PrimDecl
    extends TopLevel<Term> {
        @NotNull
        public final DefVar<PrimDef, PrimDecl> ref;

        public PrimDecl(@NotNull SourcePos sourcePos, @NotNull SourcePos entireSourcePos, @NotNull String name, @NotNull ImmutableSeq<Expr.Param> telescope, @Nullable Expr result) {
            super(new DeclInfo(Stmt.Accessibility.Public, sourcePos, entireSourcePos, null, BindBlock.EMPTY), telescope, result, DeclInfo.Personality.NORMAL);
            this.ref = DefVar.concrete(this, name);
        }

        @Override
        public boolean needTyck(@NotNull ImmutableSeq<String> currentMod) {
            return this.ref.isInModule(currentMod) && this.signature == null;
        }

        @Override
        @NotNull
        public DefVar<PrimDef, PrimDecl> ref() {
            return this.ref;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static abstract class TopLevel<RetTy extends Term>
    extends TeleDecl<RetTy>
    implements Decl.TopLevel {
        @NotNull
        private final DeclInfo.Personality personality;
        @Nullable
        public Context ctx = null;

        protected TopLevel(@NotNull DeclInfo info, @NotNull ImmutableSeq<Expr.Param> telescope, @Nullable Expr result, @NotNull DeclInfo.Personality personality) {
            super(info, telescope, result);
            this.personality = personality;
        }

        @Override
        @NotNull
        public DeclInfo.Personality personality() {
            return this.personality;
        }

        @Override
        @Nullable
        public Context getCtx() {
            return this.ctx;
        }

        @Override
        public void setCtx(@NotNull Context ctx) {
            this.ctx = ctx;
        }
    }
}

