/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.def;

import java.util.EnumMap;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import kala.collection.Map;
import kala.collection.immutable.ImmutableMap;
import kala.collection.immutable.ImmutableSeq;
import kala.control.Option;
import kala.tuple.Tuple;
import org.aya.concrete.stmt.decl.TeleDecl;
import org.aya.core.def.Def;
import org.aya.core.def.TopLevelDef;
import org.aya.core.pat.Pat;
import org.aya.core.term.AppTerm;
import org.aya.core.term.CoeTerm;
import org.aya.core.term.FormulaTerm;
import org.aya.core.term.HCompTerm;
import org.aya.core.term.InTerm;
import org.aya.core.term.IntervalTerm;
import org.aya.core.term.OutTerm;
import org.aya.core.term.PartialTerm;
import org.aya.core.term.PartialTyTerm;
import org.aya.core.term.PiTerm;
import org.aya.core.term.PrimCall;
import org.aya.core.term.RefTerm;
import org.aya.core.term.SortTerm;
import org.aya.core.term.StringTerm;
import org.aya.core.term.Term;
import org.aya.core.visitor.AyaRestrSimplifier;
import org.aya.generic.util.NormalizeMode;
import org.aya.guest0x0.cubical.Restr;
import org.aya.ref.DefVar;
import org.aya.ref.LocalVar;
import org.aya.tyck.tycker.TyckState;
import org.aya.util.Arg;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PrimDef
extends TopLevelDef<Term> {
    @NotNull
    public final @NotNull DefVar<@NotNull PrimDef, TeleDecl.PrimDecl> ref;
    @NotNull
    public final ID id;

    public PrimDef(@NotNull @NotNull DefVar<@NotNull PrimDef, @NotNull TeleDecl.PrimDecl> ref, @NotNull ImmutableSeq<Term.Param> telescope, @NotNull Term result, @NotNull ID name) {
        super(telescope, result);
        this.ref = ref;
        this.id = name;
        ref.core = this;
    }

    public PrimDef(@NotNull @NotNull DefVar<@NotNull PrimDef, @NotNull TeleDecl.PrimDecl> ref, @NotNull Term result, @NotNull ID name) {
        this(ref, (ImmutableSeq<Term.Param>)ImmutableSeq.empty(), result, name);
    }

    @Override
    @NotNull
    public ImmutableSeq<Term.Param> telescope() {
        Def.Signature signature;
        if (this.telescope.isEmpty()) {
            return this.telescope;
        }
        if (this.ref.concrete != null && (signature = ((TeleDecl.PrimDecl)this.ref.concrete).signature) != null) {
            return signature.param();
        }
        return this.telescope;
    }

    @Override
    @NotNull
    public Term result() {
        Def.Signature signature;
        if (this.ref.concrete != null && (signature = ((TeleDecl.PrimDecl)this.ref.concrete).signature) != null) {
            return signature.result();
        }
        return this.result;
    }

    @Override
    public void descentConsume(@NotNull Consumer<Term> f, @NotNull Consumer<Pat> g) {
        this.telescope.forEach(p -> p.descentConsume(f));
        f.accept(this.result);
    }

    @NotNull
    public static Term intervalToType() {
        return new PiTerm(IntervalTerm.param(LocalVar.IGNORED), SortTerm.Type0);
    }

    @NotNull
    public static PiTerm familyI2J(Term term, Term i, Term j) {
        return new PiTerm(new Term.Param(LocalVar.IGNORED, new AppTerm(term, (Arg<Term>)new Arg((Object)i, true)), true), new AppTerm(term, (Arg<Term>)new Arg((Object)j, true)));
    }

    @NotNull
    public @NotNull DefVar<@NotNull PrimDef, TeleDecl.PrimDecl> ref() {
        return this.ref;
    }

    public static enum ID {
        IMIN("intervalMin"),
        IMAX("intervalMax"),
        INVOL("intervalInv"),
        STRING("String"),
        STRCONCAT("strcat"),
        I("I"),
        PARTIAL("Partial"),
        COE("coe"),
        HCOMP("hcomp"),
        SUB("Sub"),
        INS("inS"),
        OUTS("outS");

        @NotNull
        @NonNls
        public final String id;

        public String toString() {
            return this.id;
        }

        @Nullable
        public static ID find(@NotNull String id) {
            for (ID value : ID.values()) {
                if (!Objects.equals(value.id, id)) continue;
                return value;
            }
            return null;
        }

        private ID(String id) {
            this.id = id;
        }
    }

    public static class Factory {
        @NotNull
        private final @NotNull EnumMap<@NotNull ID, @NotNull PrimDef> defs = new EnumMap(ID.class);
        @NotNull
        private final @NotNull Map<@NotNull ID, @NotNull PrimSeed> seeds;

        public Factory() {
            Initializer init = new Initializer();
            this.seeds = ImmutableMap.from((Iterable)ImmutableSeq.of((Object[])new PrimSeed[]{init.intervalMin, init.intervalMax, init.intervalInv, init.stringType, init.stringConcat, init.intervalType, init.partialType, init.coe, init.hcomp, init.outS, init.inS, init.sub}).map(seed -> Tuple.of((Object)((Object)seed.name), (Object)seed)));
        }

        @NotNull
        public PrimDef factory(@NotNull ID name, @NotNull DefVar<PrimDef, TeleDecl.PrimDecl> ref) {
            assert (this.suppressRedefinition() || !this.have(name));
            PrimDef rst = ((PrimSeed)this.seeds.get((Object)name)).supply(ref);
            this.defs.put(name, rst);
            return rst;
        }

        @NotNull
        public PrimCall getCall(@NotNull ID id, @NotNull ImmutableSeq<Arg<Term>> args) {
            return new PrimCall(((PrimDef)this.getOption(id).get()).ref(), 0, args);
        }

        @NotNull
        public PrimCall getCall(@NotNull ID id) {
            return this.getCall(id, (ImmutableSeq<Arg<Term>>)ImmutableSeq.empty());
        }

        @NotNull
        public Option<PrimDef> getOption(@NotNull ID name) {
            return Option.ofNullable((Object)this.defs.get((Object)name));
        }

        public boolean have(@NotNull ID name) {
            return this.defs.containsKey((Object)name);
        }

        public boolean suppressRedefinition() {
            return false;
        }

        @NotNull
        public PrimDef getOrCreate(@NotNull ID name, @NotNull DefVar<PrimDef, TeleDecl.PrimDecl> ref) {
            return (PrimDef)this.getOption(name).getOrElse(() -> this.factory(name, ref));
        }

        @NotNull
        public @NotNull Option<ImmutableSeq<@NotNull ID>> checkDependency(@NotNull ID name) {
            return this.seeds.getOption((Object)name).map(seed -> seed.dependency().filterNot(this::have));
        }

        @NotNull
        public Term unfold(@NotNull ID name, @NotNull PrimCall primCall, @NotNull TyckState state) {
            return (Term)((PrimSeed)this.seeds.get((Object)((Object)name))).unfold.apply(primCall, state);
        }

        public void clear() {
            this.defs.clear();
        }

        public void clear(@NotNull ID name) {
            this.defs.remove((Object)name);
        }

        private final class Initializer {
            @NotNull
            public final PrimSeed coe = new PrimSeed(ID.COE, this::coe, ref -> {
                Term.Param r = IntervalTerm.param("r");
                Term.Param s = IntervalTerm.param("s");
                Term.Param paramA = new Term.Param(new LocalVar("A"), PrimDef.intervalToType(), true);
                PiTerm result = PrimDef.familyI2J(paramA.toTerm(), r.toTerm(), s.toTerm());
                return new PrimDef((DefVar<PrimDef, TeleDecl.PrimDecl>)ref, (ImmutableSeq<Term.Param>)ImmutableSeq.of((Object)r, (Object)s, (Object)paramA), result, ID.COE);
            }, (ImmutableSeq<ID>)ImmutableSeq.of((Object)((Object)ID.I)));
            @NotNull
            public final PrimSeed sub = new PrimSeed(ID.SUB, this::primCall, ref -> {
                LocalVar varA = new LocalVar("A");
                LocalVar varU = new LocalVar("u");
                Term.Param paramA = new Term.Param(varA, SortTerm.Type0, true);
                Term.Param phi = IntervalTerm.param("phi");
                Term.Param paramU = new Term.Param(varU, new PartialTyTerm(new RefTerm(varA), (Restr<Term>)AyaRestrSimplifier.INSTANCE.isOne(phi.toTerm())), true);
                return new PrimDef((DefVar<PrimDef, TeleDecl.PrimDecl>)ref, (ImmutableSeq<Term.Param>)ImmutableSeq.of((Object)paramA, (Object)phi, (Object)paramU), SortTerm.Set0, ID.SUB);
            }, (ImmutableSeq<ID>)ImmutableSeq.of((Object)((Object)ID.I), (Object)((Object)ID.PARTIAL)));
            @NotNull
            public final PrimSeed outS = new PrimSeed(ID.OUTS, this::outS, ref -> {
                LocalVar varA = new LocalVar("A");
                LocalVar varU = new LocalVar("u");
                Term.Param paramA = new Term.Param(varA, SortTerm.Type0, false);
                Term.Param paramPhi = IntervalTerm.paramImplicit("phi");
                RefTerm phi = paramPhi.toTerm();
                RefTerm A = new RefTerm(varA);
                Term.Param paramU = new Term.Param(varU, new PartialTyTerm(A, (Restr<Term>)AyaRestrSimplifier.INSTANCE.isOne(phi)), false);
                Term.Param paramSub = new Term.Param(LocalVar.IGNORED, Factory.this.getCall(ID.SUB, (ImmutableSeq<Arg<Term>>)ImmutableSeq.of((Object)new Arg((Object)A, true), (Object)new Arg((Object)phi, true), (Object)new Arg((Object)new RefTerm(varU), true))), true);
                return new PrimDef((DefVar<PrimDef, TeleDecl.PrimDecl>)ref, (ImmutableSeq<Term.Param>)ImmutableSeq.of((Object)paramA, (Object)paramPhi, (Object)paramU, (Object)paramSub), A, ID.OUTS);
            }, (ImmutableSeq<ID>)ImmutableSeq.of((Object)((Object)ID.PARTIAL), (Object)((Object)ID.SUB)));
            @NotNull
            public final PrimSeed inS = new PrimSeed(ID.INS, this::inS, ref -> {
                LocalVar varA = new LocalVar("A");
                LocalVar varU = new LocalVar("u");
                Term.Param paramA = new Term.Param(varA, SortTerm.Type0, false);
                Term.Param paramPhi = IntervalTerm.paramImplicit("phi");
                RefTerm phi = paramPhi.toTerm();
                RefTerm A = new RefTerm(varA);
                Term.Param paramU = new Term.Param(varU, A, true);
                RefTerm u = new RefTerm(varU);
                PartialTerm par = PartialTerm.from(phi, u, A);
                PrimCall ret = Factory.this.getCall(ID.SUB, (ImmutableSeq<Arg<Term>>)ImmutableSeq.of((Object)new Arg((Object)A, true), (Object)new Arg((Object)phi, true), (Object)new Arg((Object)par, true)));
                return new PrimDef((DefVar<PrimDef, TeleDecl.PrimDecl>)ref, (ImmutableSeq<Term.Param>)ImmutableSeq.of((Object)paramA, (Object)paramPhi, (Object)paramU), ret, ID.INS);
            }, (ImmutableSeq<ID>)ImmutableSeq.of((Object)((Object)ID.PARTIAL), (Object)((Object)ID.SUB)));
            @NotNull
            public final PrimSeed stringType = new PrimSeed(ID.STRING, this::primCall, ref -> new PrimDef((DefVar<PrimDef, TeleDecl.PrimDecl>)ref, SortTerm.Type0, ID.STRING), (ImmutableSeq<ID>)ImmutableSeq.empty());
            @NotNull
            public final PrimSeed partialType = new PrimSeed(ID.PARTIAL, (prim, state) -> {
                Term iExp = (Term)((Arg)prim.args().get(0)).term();
                Term ty = (Term)((Arg)prim.args().get(1)).term();
                return new PartialTyTerm(ty, (Restr<Term>)AyaRestrSimplifier.INSTANCE.isOne(iExp));
            }, ref -> new PrimDef((DefVar<PrimDef, TeleDecl.PrimDecl>)ref, (ImmutableSeq<Term.Param>)ImmutableSeq.of((Object)IntervalTerm.param("phi"), (Object)new Term.Param(new LocalVar("A"), SortTerm.Type0, true)), SortTerm.Set0, ID.PARTIAL), (ImmutableSeq<ID>)ImmutableSeq.of((Object)((Object)ID.I)));
            @NotNull
            private final PrimSeed hcomp = new PrimSeed(ID.HCOMP, this::hcomp, ref -> {
                LocalVar varA = new LocalVar("A");
                Term.Param paramA = new Term.Param(varA, SortTerm.Type0, false);
                Term.Param restr = IntervalTerm.paramImplicit("phi");
                LocalVar varU = new LocalVar("u");
                Term.Param paramFuncU = new Term.Param(varU, new PiTerm(IntervalTerm.param(LocalVar.IGNORED), new PartialTyTerm(new RefTerm(varA), (Restr<Term>)AyaRestrSimplifier.INSTANCE.isOne(restr.toTerm()))), true);
                LocalVar varU0 = new LocalVar("u0");
                Term.Param paramU0 = new Term.Param(varU0, new RefTerm(varA), true);
                RefTerm result = new RefTerm(varA);
                return new PrimDef((DefVar<PrimDef, TeleDecl.PrimDecl>)ref, (ImmutableSeq<Term.Param>)ImmutableSeq.of((Object)paramA, (Object)restr, (Object)paramFuncU, (Object)paramU0), result, ID.HCOMP);
            }, (ImmutableSeq<ID>)ImmutableSeq.of((Object)((Object)ID.I)));
            @NotNull
            public final PrimSeed intervalMin = this.formula(ID.IMIN, prim -> {
                ImmutableSeq<Arg<Term>> args = prim.args();
                return FormulaTerm.and((Term)((Arg)args.getFirst()).term(), (Term)((Arg)args.getLast()).term());
            }, "i", "j");
            @NotNull
            public final PrimSeed intervalMax = this.formula(ID.IMAX, prim -> {
                ImmutableSeq<Arg<Term>> args = prim.args();
                return FormulaTerm.or((Term)((Arg)args.getFirst()).term(), (Term)((Arg)args.getLast()).term());
            }, "i", "j");
            @NotNull
            public final PrimSeed intervalInv = this.formula(ID.INVOL, prim -> FormulaTerm.inv((Term)((Arg)prim.args().getFirst()).term()), "i");
            @NotNull
            public final PrimSeed stringConcat = new PrimSeed(ID.STRCONCAT, Initializer::concat, ref -> new PrimDef((DefVar<PrimDef, TeleDecl.PrimDecl>)ref, (ImmutableSeq<Term.Param>)ImmutableSeq.of((Object)new Term.Param(new LocalVar("str1"), Factory.this.getCall(ID.STRING, (ImmutableSeq<Arg<Term>>)ImmutableSeq.empty()), true), (Object)new Term.Param(new LocalVar("str2"), Factory.this.getCall(ID.STRING, (ImmutableSeq<Arg<Term>>)ImmutableSeq.empty()), true)), Factory.this.getCall(ID.STRING, (ImmutableSeq<Arg<Term>>)ImmutableSeq.empty()), ID.STRCONCAT), (ImmutableSeq<ID>)ImmutableSeq.of((Object)((Object)ID.STRING)));
            @NotNull
            public final PrimSeed intervalType = new PrimSeed(ID.I, (prim, state) -> IntervalTerm.INSTANCE, ref -> new PrimDef((DefVar<PrimDef, TeleDecl.PrimDecl>)ref, SortTerm.ISet, ID.I), (ImmutableSeq<ID>)ImmutableSeq.empty());

            private Initializer() {
            }

            @Contract(value="_, _ -> new")
            @NotNull
            private Term coe(@NotNull PrimCall prim, @NotNull TyckState state) {
                Term r = (Term)((Arg)prim.args().get(0)).term();
                Term s = (Term)((Arg)prim.args().get(1)).term();
                Term type = (Term)((Arg)prim.args().get(2)).term();
                return new CoeTerm(type, r, s);
            }

            @NotNull
            private PrimSeed formula(ID id, Function<PrimCall, Term> unfold, String ... tele) {
                return new PrimSeed(id, (prim, state) -> (Term)unfold.apply((PrimCall)prim), ref -> new PrimDef((DefVar<PrimDef, TeleDecl.PrimDecl>)ref, (ImmutableSeq<Term.Param>)ImmutableSeq.of((Object[])tele).map(IntervalTerm::param), IntervalTerm.INSTANCE, id), (ImmutableSeq<ID>)ImmutableSeq.of((Object)((Object)ID.I)));
            }

            private Term inS(@NotNull PrimCall prim, @NotNull TyckState tyckState) {
                Term phi = (Term)((Arg)prim.args().get(1)).term();
                Term u = (Term)((Arg)prim.args().getLast()).term();
                return InTerm.make(phi, u);
            }

            private Term outS(@NotNull PrimCall prim, @NotNull TyckState tyckState) {
                Term phi = (Term)((Arg)prim.args().get(1)).term();
                Term par = (Term)((Arg)prim.args().get(2)).term();
                Term u = (Term)((Arg)prim.args().getLast()).term();
                return OutTerm.make(phi, par, u);
            }

            @NotNull
            private static Term concat(@NotNull PrimCall prim, @NotNull TyckState state) {
                Term first = ((Term)((Arg)prim.args().get(0)).term()).normalize(state, NormalizeMode.WHNF);
                Term second = ((Term)((Arg)prim.args().get(1)).term()).normalize(state, NormalizeMode.WHNF);
                if (first instanceof StringTerm) {
                    StringTerm str1 = (StringTerm)first;
                    if (second instanceof StringTerm) {
                        StringTerm str2 = (StringTerm)second;
                        return new StringTerm(str1.string() + str2.string());
                    }
                }
                return new PrimCall((DefVar<PrimDef, TeleDecl.PrimDecl>)prim.ref(), prim.ulift(), (ImmutableSeq<Arg<Term>>)ImmutableSeq.of((Object)new Arg((Object)first, true), (Object)new Arg((Object)second, true)));
            }

            @NotNull
            private Term hcomp(@NotNull PrimCall prim, @NotNull TyckState state) {
                Term A = (Term)((Arg)prim.args().get(0)).term();
                Term phi = (Term)((Arg)prim.args().get(1)).term();
                Term u = (Term)((Arg)prim.args().get(2)).term();
                Term u0 = (Term)((Arg)prim.args().get(3)).term();
                return new HCompTerm(A, (Restr<Term>)AyaRestrSimplifier.INSTANCE.isOne(phi), u, u0);
            }

            @NotNull
            private PrimCall primCall(@NotNull PrimCall prim, @NotNull TyckState tyckState) {
                return prim;
            }
        }
    }

    record PrimSeed(@NotNull ID name, @NotNull Unfolder unfold, @NotNull @NotNull Function<@NotNull DefVar<PrimDef, TeleDecl.PrimDecl>, @NotNull PrimDef> supplier, @NotNull @NotNull ImmutableSeq<@NotNull ID> dependency) {
        @NotNull
        public PrimDef supply(@NotNull DefVar<PrimDef, TeleDecl.PrimDecl> ref) {
            return this.supplier.apply(ref);
        }
    }

    @FunctionalInterface
    static interface Unfolder
    extends BiFunction<PrimCall, TyckState, Term> {
    }
}

