/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.pat;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.function.IntUnaryOperator;
import java.util.function.UnaryOperator;
import kala.collection.SeqLike;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.control.Option;
import kala.value.MutableValue;
import org.aya.concrete.stmt.decl.TeleDecl;
import org.aya.core.def.CtorDef;
import org.aya.core.pat.PatToTerm;
import org.aya.core.repr.ShapeRecognition;
import org.aya.core.term.DataCall;
import org.aya.core.term.Term;
import org.aya.core.visitor.Subst;
import org.aya.generic.AyaDocile;
import org.aya.generic.Shaped;
import org.aya.prettier.AyaPrettierOptions;
import org.aya.prettier.BasePrettier;
import org.aya.prettier.CorePrettier;
import org.aya.pretty.doc.Doc;
import org.aya.ref.DefVar;
import org.aya.ref.LocalVar;
import org.aya.tyck.env.LocalCtx;
import org.aya.tyck.env.SeqLocalCtx;
import org.aya.tyck.pat.ClauseTycker;
import org.aya.tyck.tycker.ConcreteAwareTycker;
import org.aya.util.Arg;
import org.aya.util.error.InternalException;
import org.aya.util.error.SourcePos;
import org.aya.util.prettier.PrettierOptions;
import org.jetbrains.annotations.Debug;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Debug.Renderer(text="toTerm().toDoc(AyaPrettierOptions.debug()).debugRender()")
public interface Pat
extends AyaDocile {
    @NotNull
    public Pat descent(@NotNull UnaryOperator<Pat> var1, @NotNull UnaryOperator<Term> var2);

    @NotNull
    default public Term toTerm() {
        return PatToTerm.INSTANCE.visit(this);
    }

    @Override
    @NotNull
    default public Doc toDoc(@NotNull PrettierOptions options) {
        return new CorePrettier(options).pat(this, true, BasePrettier.Outer.Free);
    }

    @NotNull
    public Pat zonk(@NotNull ConcreteAwareTycker var1);

    @NotNull
    public Pat inline(@Nullable LocalCtx var1);

    public void storeBindings(@NotNull LocalCtx var1, @NotNull Subst var2);

    @NotNull
    public static ImmutableSeq<Term.Param> extractTele(@NotNull SeqLike<Pat> pats) {
        SeqLocalCtx localCtx = new SeqLocalCtx();
        for (Pat pat : pats) {
            pat.storeBindings(localCtx, Subst.EMPTY);
        }
        return localCtx.extract();
    }

    public record Preclause<T extends AyaDocile>(@NotNull SourcePos sourcePos, @NotNull ImmutableSeq<Arg<Pat>> patterns, @NotNull Option<T> expr) implements AyaDocile
    {
        @Override
        @NotNull
        public Doc toDoc(@NotNull PrettierOptions options) {
            CorePrettier prettier = new CorePrettier(options);
            SeqView pats = (Boolean)options.map.get((Object)AyaPrettierOptions.Key.ShowImplicitPats) != false ? this.patterns : this.patterns.view().filter(Arg::explicit);
            Doc doc = Doc.emptyIf((boolean)pats.isEmpty(), () -> Preclause.lambda$toDoc$1((SeqLike)pats, prettier));
            return (Doc)this.expr.getOrDefault(it -> Doc.sep((Doc[])new Doc[]{doc, Doc.symbol((String)"=>"), it.toDoc(options)}), (Object)doc);
        }

        @NotNull
        public static Preclause<Term> weaken(@NotNull Term.Matching clause) {
            return new Preclause<Term>(clause.sourcePos(), clause.patterns(), Option.some((Object)clause.body()));
        }

        @NotNull
        public static @NotNull Option<@NotNull Term.Matching> lift(@NotNull Preclause<Term> clause) {
            return clause.expr.map(term -> new Term.Matching(clause.sourcePos, clause.patterns, (Term)term));
        }

        private static /* synthetic */ Doc lambda$toDoc$1(SeqLike pats, CorePrettier prettier) {
            return Doc.cat((Doc[])new Doc[]{Doc.ONE_WS, Doc.commaList((SeqLike)pats.view().map(p -> prettier.pat((Arg<Pat>)p, BasePrettier.Outer.Free)))});
        }
    }

    public static final class ShapedInt
    extends Record
    implements Pat,
    Shaped.Nat<Pat> {
        private final int repr;
        @NotNull
        private final ShapeRecognition recognition;
        @NotNull
        private final DataCall type;

        public ShapedInt(int repr, @NotNull ShapeRecognition recognition, @NotNull DataCall type) {
            this.repr = repr;
            this.recognition = recognition;
            this.type = type;
        }

        public ShapedInt update(DataCall type) {
            return type == this.type() ? this : new ShapedInt(this.repr, this.recognition, type);
        }

        @Override
        @NotNull
        public ShapedInt descent(@NotNull UnaryOperator<Pat> f, @NotNull UnaryOperator<Term> g) {
            return this.update((DataCall)g.apply(this.type));
        }

        @Override
        @NotNull
        public Pat zonk(@NotNull ConcreteAwareTycker tycker) {
            return new ShapedInt(this.repr, this.recognition, (DataCall)tycker.zonk(this.type));
        }

        @Override
        @NotNull
        public Pat inline(@Nullable LocalCtx ctx) {
            return this;
        }

        @Override
        public void storeBindings(@NotNull LocalCtx ctx, @NotNull Subst rhsSubst) {
        }

        @Override
        @NotNull
        public Pat makeZero(@NotNull CtorDef zero) {
            return new Ctor(zero.ref, (ImmutableSeq<Arg<Pat>>)ImmutableSeq.empty(), this.recognition, this.type);
        }

        @Override
        @NotNull
        public Pat makeSuc(@NotNull CtorDef suc, @NotNull Arg<Pat> pat) {
            return new Ctor(suc.ref, (ImmutableSeq<Arg<Pat>>)ImmutableSeq.of(pat), this.recognition, this.type);
        }

        @Override
        @NotNull
        public Pat destruct(int repr) {
            return new ShapedInt(repr, this.recognition, this.type);
        }

        @NotNull
        public ShapedInt map(@NotNull IntUnaryOperator f) {
            return new ShapedInt(f.applyAsInt(this.repr), this.recognition, this.type);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ShapedInt.class, "repr;recognition;type", "repr", "recognition", "type"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ShapedInt.class, "repr;recognition;type", "repr", "recognition", "type"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ShapedInt.class, "repr;recognition;type", "repr", "recognition", "type"}, this, o);
        }

        @Override
        public int repr() {
            return this.repr;
        }

        @Override
        @NotNull
        public ShapeRecognition recognition() {
            return this.recognition;
        }

        @Override
        @NotNull
        public DataCall type() {
            return this.type;
        }
    }

    public record Ctor(@NotNull DefVar<CtorDef, TeleDecl.DataCtor> ref, @NotNull ImmutableSeq<Arg<Pat>> params, @Nullable ShapeRecognition typeRecog, @NotNull DataCall type) implements Pat
    {
        @NotNull
        public Ctor update(@NotNull ImmutableSeq<Arg<Pat>> params, @NotNull DataCall type) {
            return type == this.type() && params.sameElements(this.params(), true) ? this : new Ctor(this.ref, params, this.typeRecog, type);
        }

        @Override
        @NotNull
        public Ctor descent(@NotNull UnaryOperator<Pat> f, @NotNull UnaryOperator<Term> g) {
            return this.update((ImmutableSeq<Arg<Pat>>)this.params.map(p -> p.descent(f)), (DataCall)g.apply(this.type));
        }

        @Override
        public void storeBindings(@NotNull LocalCtx ctx, @NotNull Subst rhsSubst) {
            this.params.forEach(pat -> ((Pat)pat.term()).storeBindings(ctx, rhsSubst));
        }

        @Override
        @NotNull
        public Pat zonk(@NotNull ConcreteAwareTycker tycker) {
            return new Ctor(this.ref, (ImmutableSeq<Arg<Pat>>)this.params.map(pat -> pat.descent(x -> x.zonk(tycker))), this.typeRecog, (DataCall)tycker.zonk(this.type));
        }

        @Override
        @NotNull
        public Pat inline(@Nullable LocalCtx ctx) {
            ImmutableSeq params = this.params.map(p -> p.descent(x -> x.inline(ctx)));
            return new Ctor(this.ref, (ImmutableSeq<Arg<Pat>>)params, this.typeRecog, (DataCall)ClauseTycker.inlineTerm(this.type));
        }
    }

    public record Tuple(@NotNull ImmutableSeq<Arg<Pat>> pats) implements Pat
    {
        @NotNull
        public Tuple update(@NotNull ImmutableSeq<Arg<Pat>> pats) {
            return pats.sameElements(this.pats(), true) ? this : new Tuple(pats);
        }

        @Override
        @NotNull
        public Tuple descent(@NotNull UnaryOperator<Pat> f, @NotNull UnaryOperator<Term> g) {
            return this.update((ImmutableSeq<Arg<Pat>>)this.pats.map(a -> a.descent(f)));
        }

        @Override
        public void storeBindings(@NotNull LocalCtx ctx, @NotNull Subst rhsSubst) {
            this.pats.forEach(pat -> ((Pat)pat.term()).storeBindings(ctx, rhsSubst));
        }

        @Override
        @NotNull
        public Tuple zonk(@NotNull ConcreteAwareTycker tycker) {
            return new Tuple((ImmutableSeq<Arg<Pat>>)Arg.mapSeq(this.pats, t -> t.zonk(tycker)));
        }

        @Override
        @NotNull
        public Tuple inline(@Nullable LocalCtx ctx) {
            return new Tuple((ImmutableSeq<Arg<Pat>>)Arg.mapSeq(this.pats, t -> t.inline(ctx)));
        }
    }

    public static enum Absurd implements Pat
    {
        INSTANCE;


        @Override
        @NotNull
        public Absurd descent(@NotNull UnaryOperator<Pat> f, @NotNull UnaryOperator<Term> g) {
            return this;
        }

        @Override
        public void storeBindings(@NotNull LocalCtx ctx, @NotNull Subst rhsSubst) {
            throw new InternalException("unreachable");
        }

        @Override
        @NotNull
        public Pat zonk(@NotNull ConcreteAwareTycker tycker) {
            return this;
        }

        @Override
        @NotNull
        public Pat inline(@Nullable LocalCtx ctx) {
            return this;
        }
    }

    public record Meta(@NotNull MutableValue<Pat> solution, @NotNull LocalVar fakeBind, @NotNull Term type) implements Pat
    {
        @NotNull
        public Meta update(@NotNull Pat solution, @NotNull Term type) {
            return solution == this.solution().get() && type == this.type() ? this : new Meta((MutableValue<Pat>)MutableValue.create((Object)solution), this.fakeBind, type);
        }

        @Override
        @NotNull
        public Meta descent(@NotNull UnaryOperator<Pat> f, @NotNull UnaryOperator<Term> g) {
            Pat solution = (Pat)this.solution().get();
            return solution == null ? this : this.update((Pat)f.apply(solution), (Term)g.apply(this.type));
        }

        @Override
        public void storeBindings(@NotNull LocalCtx ctx, @NotNull Subst rhsSubst) {
        }

        @Override
        @NotNull
        public Pat zonk(@NotNull ConcreteAwareTycker tycker) {
            throw new InternalException("unreachable");
        }

        @Override
        @NotNull
        public Pat inline(@Nullable LocalCtx ctx) {
            Pat value = (Pat)this.solution.get();
            if (value == null) {
                Term type = ClauseTycker.inlineTerm(this.type);
                Bind bind = new Bind(this.fakeBind, type);
                assert (ctx != null) : "Pre-inline patterns must be inlined with ctx";
                this.solution.set((Object)bind);
                ctx.put(this.fakeBind, type);
                return bind;
            }
            return value.inline(ctx);
        }
    }

    public record Bind(@NotNull LocalVar bind, @NotNull Term type) implements Pat
    {
        @NotNull
        public Bind update(@NotNull Term type) {
            return type == this.type() ? this : new Bind(this.bind, type);
        }

        @Override
        @NotNull
        public Bind descent(@NotNull UnaryOperator<Pat> f, @NotNull UnaryOperator<Term> g) {
            return this.update((Term)g.apply(this.type));
        }

        @Override
        public void storeBindings(@NotNull LocalCtx ctx, @NotNull Subst rhsSubst) {
            ctx.put(this.bind, this.type.subst(rhsSubst));
        }

        @Override
        @NotNull
        public Pat zonk(@NotNull ConcreteAwareTycker tycker) {
            return new Bind(this.bind, tycker.zonk(this.type));
        }

        @Override
        @NotNull
        public Pat inline(@Nullable LocalCtx ctx) {
            Term newTy = ClauseTycker.inlineTerm(this.type);
            if (newTy == this.type) {
                return this;
            }
            return new Bind(this.bind, newTy);
        }
    }
}

