/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.pat;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import org.aya.core.pat.Pat;
import org.aya.core.term.RefTerm;
import org.aya.core.visitor.Subst;
import org.aya.prettier.AyaPrettierOptions;
import org.aya.pretty.doc.Doc;
import org.aya.ref.LocalVar;
import org.aya.tyck.env.LocalCtx;
import org.aya.util.Arg;
import org.aya.util.error.InternalException;
import org.jetbrains.annotations.NotNull;

public record PatUnify(@NotNull Subst lhsSubst, @NotNull Subst rhsSubst, @NotNull LocalCtx ctx) {
    private void unify(@NotNull Pat lhs, @NotNull Pat rhs) {
        Pat pat = lhs;
        Objects.requireNonNull(pat);
        Pat pat2 = pat;
        int n = 0;
        block0 : switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Pat.Bind.class, Pat.Meta.class, Pat.Tuple.class, Pat.Ctor.class, Pat.ShapedInt.class}, (Object)pat2, n)) {
            case 0: {
                Pat.Bind bind = (Pat.Bind)pat2;
                this.visitAs(bind.bind(), rhs);
                break;
            }
            case 1: {
                Pat.Meta meta = (Pat.Meta)pat2;
                this.visitAs(meta.fakeBind(), rhs);
                break;
            }
            case 2: {
                Pat.Tuple tuple = (Pat.Tuple)pat2;
                if (rhs instanceof Pat.Tuple) {
                    Pat.Tuple tuple1 = (Pat.Tuple)rhs;
                    this.visitList(tuple.pats(), tuple1.pats());
                    break;
                }
                this.reportError(lhs, rhs);
                break;
            }
            case 3: {
                Pat.Ctor ctor = (Pat.Ctor)pat2;
                Pat pat3 = rhs;
                Objects.requireNonNull(pat3);
                Pat pat4 = pat3;
                int n2 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Pat.Ctor.class, Pat.ShapedInt.class}, (Object)pat4, n2)) {
                    case 0: {
                        Pat.Ctor ctor1 = (Pat.Ctor)pat4;
                        assert (ctor.ref() == ctor1.ref());
                        this.visitList(ctor.params(), ctor1.params());
                        break block0;
                    }
                    case 1: {
                        Pat.ShapedInt lit = (Pat.ShapedInt)pat4;
                        this.unifyLitWithCtor(ctor, lit, lhs);
                        break block0;
                    }
                }
                this.reportError(lhs, rhs);
                break;
            }
            case 4: {
                Pat.ShapedInt lhsInt = (Pat.ShapedInt)pat2;
                Pat pat5 = rhs;
                Objects.requireNonNull(pat5);
                Pat pat6 = pat5;
                int n3 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Pat.ShapedInt.class, Pat.Ctor.class}, (Object)pat6, n3)) {
                    case 0: {
                        Pat.ShapedInt rhsInt = (Pat.ShapedInt)pat6;
                        if (lhsInt.compareUntyped(rhsInt)) break block0;
                        this.reportError(lhs, rhs);
                        break;
                    }
                    case 1: {
                        Pat.Ctor ctor = (Pat.Ctor)pat6;
                        this.unifyLitWithCtor(ctor, lhsInt, lhs);
                        break;
                    }
                    default: {
                        this.unify((Pat)lhsInt.constructorForm(), rhs);
                        break;
                    }
                }
                break;
            }
            default: {
                throw new InternalException();
            }
        }
    }

    private void unifyLitWithCtor(@NotNull Pat.Ctor ctor, @NotNull Pat.ShapedInt lit, @NotNull Pat lhs) {
        if (lhs == ctor) {
            this.unify(ctor, (Pat)lit.constructorForm());
        }
        if (lhs == lit) {
            this.unify((Pat)lit.constructorForm(), ctor);
        }
    }

    private void visitList(ImmutableSeq<Arg<Pat>> lpats, ImmutableSeq<Arg<Pat>> rpats) {
        assert (rpats.sizeEquals(lpats.size()));
        lpats.forEachWith(rpats, (lp, rp) -> {
            assert (lp.explicit() == rp.explicit());
            PatUnify.unifyPat((Pat)lp.term(), (Pat)rp.term(), this.lhsSubst, this.rhsSubst, this.ctx);
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void visitAs(@NotNull LocalVar as, Pat rhs) {
        LocalVar fresh;
        LocalVar bind2;
        if (!(rhs instanceof Pat.Bind)) {
            rhs.storeBindings(this.ctx, this.rhsSubst);
            this.lhsSubst.add(as, rhs.toTerm().subst(this.rhsSubst));
            return;
        }
        Pat.Bind bind = (Pat.Bind)rhs;
        try {
            Object object = bind.bind();
            bind2 = object;
            Object ty = object = bind.type();
            fresh = new LocalVar(as.name() + bind2.name());
            this.ctx.put(fresh, ty.subst(this.rhsSubst));
            this.lhsSubst.add(as, new RefTerm(fresh));
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.toString(), throwable);
        }
        this.rhsSubst.add(bind2, new RefTerm(fresh));
    }

    private void reportError(@NotNull Pat lhs, @NotNull Pat pat) {
        Doc doc = Doc.sep((Doc[])new Doc[]{lhs.toDoc(AyaPrettierOptions.debug()), Doc.plain((String)"and"), pat.toDoc(AyaPrettierOptions.debug())});
        throw new InternalException(doc.debugRender() + " are patterns of different types!");
    }

    private static void unifyPat(Pat lhs, Pat rhs, Subst lhsSubst, Subst rhsSubst, LocalCtx ctx) {
        if (rhs instanceof Pat.Bind) {
            PatUnify unify = new PatUnify(rhsSubst, lhsSubst, ctx);
            unify.unify(rhs, lhs);
        } else {
            PatUnify unify = new PatUnify(lhsSubst, rhsSubst, ctx);
            unify.unify(lhs, rhs);
        }
    }

    @NotNull
    public static LocalCtx unifyPat(@NotNull SeqView<Pat> lpats, @NotNull SeqView<Pat> rpats, @NotNull Subst lhsSubst, @NotNull Subst rhsSubst, @NotNull LocalCtx ctx) {
        assert (rpats.sizeEquals(lpats));
        lpats.forEachWith(rpats, (lp, rp) -> PatUnify.unifyPat(lp, rp, lhsSubst, rhsSubst, ctx));
        return ctx;
    }
}

