/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.repr;

import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableLinkedHashMap;
import kala.collection.mutable.MutableMap;
import kala.control.Either;
import kala.control.Option;
import kala.tuple.Tuple;
import kala.tuple.Tuple2;
import org.aya.core.def.GenericDef;
import org.aya.core.repr.CodeShape;
import org.aya.core.repr.ParamShape;
import org.aya.core.repr.PatShape;
import org.aya.core.repr.ShapeMatcher;
import org.aya.core.repr.ShapeRecognition;
import org.aya.core.repr.TermShape;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface AyaShape {
    @NotNull
    public static final AyaShape NAT_SHAPE = AyaIntShape.INSTANCE;
    @NotNull
    public static final AyaShape LIST_SHAPE = AyaListShape.INSTANCE;
    @NotNull
    public static final AyaShape PLUS_LEFT_SHAPE = AyaPlusFnLeftShape.INSTANCE;
    @NotNull
    public static final AyaShape PLUS_RIGHT_SHAPE = AyaPlusFnShape.INSTANCE;
    @NotNull
    public static final ImmutableSeq<AyaShape> LITERAL_SHAPES = ImmutableSeq.of((Object)NAT_SHAPE, (Object)LIST_SHAPE, (Object)PLUS_RIGHT_SHAPE);

    @NotNull
    public CodeShape codeShape();

    public static enum AyaIntShape implements AyaShape
    {
        INSTANCE;

        @NotNull
        public static final CodeShape DATA_NAT;

        @Override
        @NotNull
        public CodeShape codeShape() {
            return DATA_NAT;
        }

        static {
            DATA_NAT = new CodeShape.DataShape(CodeShape.LocalId.DATA, (ImmutableSeq<ParamShape>)ImmutableSeq.empty(), (ImmutableSeq<CodeShape.CtorShape>)ImmutableSeq.of((Object)new CodeShape.CtorShape(CodeShape.GlobalId.ZERO, (ImmutableSeq<ParamShape>)ImmutableSeq.empty()), (Object)new CodeShape.CtorShape(CodeShape.GlobalId.SUC, (ImmutableSeq<ParamShape>)ImmutableSeq.of((Object)ParamShape.explicit(TermShape.NameCall.of(CodeShape.LocalId.DATA))))));
        }
    }

    public static enum AyaListShape implements AyaShape
    {
        INSTANCE;

        @NotNull
        public static final CodeShape.LocalId A;
        @NotNull
        public static final CodeShape DATA_LIST;

        @Override
        @NotNull
        public CodeShape codeShape() {
            return DATA_LIST;
        }

        static {
            A = new CodeShape.LocalId("A");
            DATA_LIST = new CodeShape.DataShape(CodeShape.LocalId.DATA, (ImmutableSeq<ParamShape>)ImmutableSeq.of((Object)ParamShape.explicit(A, new TermShape.Sort(null, 0))), (ImmutableSeq<CodeShape.CtorShape>)ImmutableSeq.of((Object)new CodeShape.CtorShape(CodeShape.GlobalId.NIL, (ImmutableSeq<ParamShape>)ImmutableSeq.empty()), (Object)new CodeShape.CtorShape(CodeShape.GlobalId.CONS, (ImmutableSeq<ParamShape>)ImmutableSeq.of((Object)ParamShape.explicit(TermShape.NameCall.of(A)), (Object)ParamShape.explicit(new TermShape.NameCall(CodeShape.LocalId.DATA, (ImmutableSeq<TermShape>)ImmutableSeq.of((Object)TermShape.NameCall.of(A))))))));
        }
    }

    public static enum AyaPlusFnLeftShape implements AyaShape
    {
        INSTANCE;

        @NotNull
        public static final CodeShape FN_PLUS;

        @Override
        @NotNull
        public CodeShape codeShape() {
            return FN_PLUS;
        }

        static {
            FN_PLUS = new CodeShape.FnShape(CodeShape.LocalId.FUNC, (ImmutableSeq<ParamShape>)ImmutableSeq.of((Object)ParamShape.explicit(new TermShape.ShapeCall(CodeShape.LocalId.TYPE, AyaIntShape.DATA_NAT, (ImmutableSeq<TermShape>)ImmutableSeq.empty())), (Object)ParamShape.explicit(TermShape.NameCall.of(CodeShape.LocalId.TYPE))), TermShape.NameCall.of(CodeShape.LocalId.TYPE), (Either<TermShape, ImmutableSeq<CodeShape.ClauseShape>>)Either.right((Object)ImmutableSeq.of((Object)new CodeShape.ClauseShape((ImmutableSeq<PatShape>)ImmutableSeq.of((Object)PatShape.ShapedCtor.of(CodeShape.LocalId.TYPE, CodeShape.GlobalId.ZERO), (Object)new PatShape.Bind(CodeShape.LocalId.RHS)), TermShape.NameCall.of(CodeShape.LocalId.RHS)), (Object)new CodeShape.ClauseShape((ImmutableSeq<PatShape>)ImmutableSeq.of((Object)new PatShape.ShapedCtor(CodeShape.LocalId.TYPE, CodeShape.GlobalId.SUC, (ImmutableSeq<PatShape>)ImmutableSeq.of((Object)new PatShape.Bind(CodeShape.LocalId.LHS))), (Object)new PatShape.Bind(CodeShape.LocalId.RHS)), new TermShape.CtorCall(CodeShape.LocalId.TYPE, CodeShape.GlobalId.SUC, (ImmutableSeq<TermShape>)ImmutableSeq.of((Object)new TermShape.NameCall(CodeShape.LocalId.FUNC, (ImmutableSeq<TermShape>)ImmutableSeq.of((Object)TermShape.NameCall.of(CodeShape.LocalId.LHS), (Object)TermShape.NameCall.of(CodeShape.LocalId.RHS)))))))));
        }
    }

    public static enum AyaPlusFnShape implements AyaShape
    {
        INSTANCE;

        @NotNull
        public static final CodeShape FN_PLUS;

        @Override
        @NotNull
        public CodeShape codeShape() {
            return FN_PLUS;
        }

        static {
            FN_PLUS = new CodeShape.FnShape(CodeShape.LocalId.FUNC, (ImmutableSeq<ParamShape>)ImmutableSeq.of((Object)ParamShape.explicit(new TermShape.ShapeCall(CodeShape.LocalId.TYPE, AyaIntShape.DATA_NAT, (ImmutableSeq<TermShape>)ImmutableSeq.empty())), (Object)ParamShape.explicit(TermShape.NameCall.of(CodeShape.LocalId.TYPE))), TermShape.NameCall.of(CodeShape.LocalId.TYPE), (Either<TermShape, ImmutableSeq<CodeShape.ClauseShape>>)Either.right((Object)ImmutableSeq.of((Object)new CodeShape.ClauseShape((ImmutableSeq<PatShape>)ImmutableSeq.of((Object)new PatShape.Bind(CodeShape.LocalId.LHS), (Object)PatShape.ShapedCtor.of(CodeShape.LocalId.TYPE, CodeShape.GlobalId.ZERO)), TermShape.NameCall.of(CodeShape.LocalId.LHS)), (Object)new CodeShape.ClauseShape((ImmutableSeq<PatShape>)ImmutableSeq.of((Object)new PatShape.Bind(CodeShape.LocalId.LHS), (Object)new PatShape.ShapedCtor(CodeShape.LocalId.TYPE, CodeShape.GlobalId.SUC, (ImmutableSeq<PatShape>)ImmutableSeq.of((Object)new PatShape.Bind(CodeShape.LocalId.RHS)))), new TermShape.CtorCall(CodeShape.LocalId.TYPE, CodeShape.GlobalId.SUC, (ImmutableSeq<TermShape>)ImmutableSeq.of((Object)new TermShape.NameCall(CodeShape.LocalId.FUNC, (ImmutableSeq<TermShape>)ImmutableSeq.of((Object)TermShape.NameCall.of(CodeShape.LocalId.LHS), (Object)TermShape.NameCall.of(CodeShape.LocalId.RHS)))))))));
        }
    }

    public static class Factory {
        @NotNull
        public MutableMap<GenericDef, ShapeRecognition> discovered = MutableLinkedHashMap.of();

        @NotNull
        public ImmutableSeq<Tuple2<GenericDef, ShapeRecognition>> findImpl(@NotNull AyaShape shape) {
            return this.discovered.view().map(Tuple::of).filter(t -> ((ShapeRecognition)t.component2()).shape() == shape).toImmutableSeq();
        }

        @NotNull
        public Option<ShapeRecognition> find(@NotNull GenericDef def) {
            return this.discovered.getOption((Object)def);
        }

        public void bonjour(@NotNull GenericDef def, @NotNull ShapeRecognition shape) {
            this.discovered.put((Object)def, (Object)shape);
        }

        public void bonjour(@NotNull GenericDef def) {
            LITERAL_SHAPES.view().flatMap(shape -> new ShapeMatcher().match((AyaShape)shape, def)).forEach(shape -> this.bonjour(def, (ShapeRecognition)shape));
        }

        public void importAll(@NotNull Factory other) {
            this.discovered.putAll(other.discovered);
        }
    }
}

