/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.repr;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import org.aya.core.repr.CodeShape;
import org.aya.core.repr.TermShape;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ParamShape {
    @NotNull
    public static ParamShape explicit(@NotNull TermShape type) {
        return ParamShape.explicit(CodeShape.LocalId.IGNORED, type);
    }

    @NotNull
    public static ParamShape explicit(@NotNull CodeShape.LocalId name, @NotNull TermShape type) {
        return new Licit(name, type, Licit.Kind.Ex);
    }

    @NotNull
    public static ParamShape implicit(@NotNull TermShape type) {
        return new Licit(CodeShape.LocalId.IGNORED, type, Licit.Kind.Im);
    }

    @NotNull
    public static ParamShape anyLicit(@NotNull CodeShape.LocalId name, @NotNull TermShape type) {
        return new Licit(name, type, Licit.Kind.Any);
    }

    @NotNull
    public static ParamShape anyLicit(@NotNull TermShape type) {
        return ParamShape.anyLicit(CodeShape.LocalId.IGNORED, type);
    }

    @NotNull
    public static ParamShape anyEx() {
        return ParamShape.explicit(TermShape.Any.INSTANCE);
    }

    @NotNull
    public static ParamShape anyIm() {
        return ParamShape.implicit(TermShape.Any.INSTANCE);
    }

    public static final class Licit
    extends Record
    implements ParamShape,
    CodeShape.Moment {
        @NotNull
        private final CodeShape.LocalId name;
        @NotNull
        private final TermShape type;
        private final Kind kind;

        public Licit(@NotNull CodeShape.LocalId name, @NotNull TermShape type, Kind kind) {
            this.name = name;
            this.type = type;
            this.kind = kind;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Licit.class, "name;type;kind", "name", "type", "kind"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Licit.class, "name;type;kind", "name", "type", "kind"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Licit.class, "name;type;kind", "name", "type", "kind"}, this, o);
        }

        @Override
        @NotNull
        public CodeShape.LocalId name() {
            return this.name;
        }

        @NotNull
        public TermShape type() {
            return this.type;
        }

        public Kind kind() {
            return this.kind;
        }

        static enum Kind {
            Any,
            Ex,
            Im;

        }
    }

    public static enum Any implements ParamShape
    {
        INSTANCE;

    }
}

