/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.repr;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import kala.collection.SeqLike;
import kala.collection.immutable.ImmutableMap;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableLinkedList;
import kala.collection.mutable.MutableMap;
import kala.control.Option;
import kala.tuple.Tuple;
import kala.tuple.Tuple2;
import kala.value.MutableValue;
import org.aya.core.def.CtorDef;
import org.aya.core.def.DataDef;
import org.aya.core.def.FnDef;
import org.aya.core.def.GenericDef;
import org.aya.core.pat.Pat;
import org.aya.core.repr.AyaShape;
import org.aya.core.repr.CodeShape;
import org.aya.core.repr.ParamShape;
import org.aya.core.repr.PatShape;
import org.aya.core.repr.ShapeRecognition;
import org.aya.core.repr.TermShape;
import org.aya.core.term.Callable;
import org.aya.core.term.RefTerm;
import org.aya.core.term.SortTerm;
import org.aya.core.term.Term;
import org.aya.generic.Modifier;
import org.aya.ref.AnyVar;
import org.aya.ref.DefVar;
import org.aya.util.Arg;
import org.aya.util.Pair;
import org.aya.util.RepoLike;
import org.aya.util.error.InternalException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record ShapeMatcher(@NotNull Captures captures, @NotNull MutableMap<AnyVar, AnyVar> teleSubst, @NotNull ImmutableMap<DefVar<?, ?>, ShapeRecognition> discovered) {
    public ShapeMatcher() {
        this(Captures.create(), (MutableMap<AnyVar, AnyVar>)MutableMap.create(), ImmutableMap.empty());
    }

    public ShapeMatcher(@NotNull ImmutableMap<DefVar<?, ?>, ShapeRecognition> discovered) {
        this(Captures.create(), (MutableMap<AnyVar, AnyVar>)MutableMap.create(), discovered);
    }

    public Option<ShapeRecognition> match(@NotNull AyaShape shape, @NotNull GenericDef def) {
        if (this.matchDecl(new MatchDecl(shape.codeShape(), def))) {
            return Option.some((Object)new ShapeRecognition(shape, this.captures.extractGlobal()));
        }
        return Option.none();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean matchDecl(@NotNull MatchDecl params) {
        MatchDecl matchDecl = params;
        Objects.requireNonNull(matchDecl);
        MatchDecl matchDecl2 = matchDecl;
        int n = 0;
        block11: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MatchDecl.class}, (Object)matchDecl2, n)) {
                case 0: {
                    int n2;
                    CodeShape codeShape;
                    MatchDecl matchDecl3 = matchDecl2;
                    try {
                        codeShape = matchDecl3.shape();
                        n2 = 0;
                    }
                    catch (Throwable throwable) {
                        throw new RuntimeException(throwable.toString(), throwable);
                    }
                    block12: while (true) {
                        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CodeShape.DataShape.class, CodeShape.FnShape.class}, (Object)codeShape, n2)) {
                            case 0: {
                                boolean bl;
                                GenericDef genericDef;
                                CodeShape.DataShape dataShape = (CodeShape.DataShape)codeShape;
                                {
                                    genericDef = matchDecl3.def();
                                }
                                if (genericDef instanceof DataDef) {
                                    DataDef data = (DataDef)genericDef;
                                    bl = this.matchData(dataShape, data);
                                    return bl;
                                }
                                n2 = 1;
                                continue block12;
                            }
                            case 1: {
                                boolean bl;
                                GenericDef genericDef;
                                CodeShape.FnShape fnShape = (CodeShape.FnShape)codeShape;
                                {
                                    genericDef = matchDecl3.def();
                                }
                                if (genericDef instanceof FnDef) {
                                    FnDef fn = (FnDef)genericDef;
                                    bl = this.matchFn(fnShape, fn);
                                    return bl;
                                }
                                n2 = 2;
                                continue block12;
                            }
                        }
                        break;
                    }
                    n = 1;
                    continue block11;
                }
            }
            break;
        }
        return false;
    }

    private boolean matchFn(@NotNull CodeShape.FnShape shape, @NotNull FnDef def) {
        boolean teleResult;
        boolean bl = teleResult = this.matchTele(shape.tele(), (ImmutableSeq<Term.Param>)def.telescope) && this.matchTerm(shape.result(), def.result);
        if (!teleResult) {
            return false;
        }
        return (Boolean)shape.body().fold(termShape -> {
            if (!def.body.isLeft()) {
                return false;
            }
            Term term = (Term)def.body.getLeftValue();
            return this.matchInside(() -> this.captures.put(shape.name(), def.ref), () -> this.matchTerm((TermShape)termShape, term));
        }, clauseShapes -> {
            if (!def.body.isRight()) {
                return false;
            }
            ImmutableSeq clauses = (ImmutableSeq)def.body.getRightValue();
            MatchMode mode = def.modifiers.contains((Object)Modifier.Overlap) ? MatchMode.Sub : MatchMode.Eq;
            return this.matchInside(() -> this.captures.put(shape.name(), def.ref), () -> ShapeMatcher.matchMany(mode, clauseShapes, clauses, this::matchClause));
        });
    }

    private boolean matchClause(@NotNull CodeShape.ClauseShape shape, @NotNull Term.Matching clause) {
        boolean patsResult = ShapeMatcher.matchMany(MatchMode.OrderedEq, shape.pats(), clause.patterns(), (ps, ap) -> this.matchPat(new MatchPat((PatShape)ps, (Pat)ap.term())));
        if (!patsResult) {
            return false;
        }
        return this.matchTerm(shape.body(), clause.body());
    }

    /*
     * Loose catch block
     */
    private boolean matchPat(@NotNull MatchPat matchPat) {
        boolean bl;
        if (matchPat.shape == PatShape.Any.INSTANCE) {
            return true;
        }
        MatchPat matchPat2 = matchPat;
        Objects.requireNonNull(matchPat2);
        MatchPat matchPat3 = matchPat2;
        int n = 0;
        block12: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MatchPat.class}, (Object)matchPat3, n)) {
                case 0: {
                    MatchPat matchPat4 = matchPat3;
                    PatShape patShape = matchPat4.shape();
                    int n2 = 0;
                    block13: while (true) {
                        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PatShape.Bind.class, PatShape.CtorLike.class}, (Object)patShape, n2)) {
                            case 0: {
                                Object name;
                                Pat.Bind ignored;
                                PatShape.Bind bind = (PatShape.Bind)patShape;
                                Object object = matchPat4.pat();
                                if (object instanceof Pat.Bind) {
                                    ignored = (Pat.Bind)object;
                                    name = object = bind.name();
                                } else {
                                    n2 = 1;
                                    continue block13;
                                }
                                this.captures.put((CodeShape.MomentId)name, ignored.bind());
                                bl = true;
                                break block12;
                            }
                            case 1: {
                                PatShape.CtorLike ctorLike = (PatShape.CtorLike)patShape;
                                Object object = matchPat4.pat();
                                if (!(object instanceof Pat.Ctor)) {
                                    n2 = 2;
                                    continue block13;
                                }
                                Pat.Ctor ctor = (Pat.Ctor)object;
                                boolean matched = true;
                                if (ctorLike instanceof PatShape.ShapedCtor) {
                                    PatShape.ShapedCtor shapedCtor = (PatShape.ShapedCtor)ctorLike;
                                    AnyVar data = this.captures.resolve(shapedCtor.dataId());
                                    if (!(data instanceof DefVar)) {
                                        throw new InternalException("Invalid name: " + String.valueOf(shapedCtor.dataId()));
                                    }
                                    DefVar defVar = (DefVar)data;
                                    ShapeRecognition recognition = (ShapeRecognition)this.discovered.getOrThrow((Object)defVar, () -> new InternalException("Not a shaped data"));
                                    DefVar realShapedCtor = (DefVar)recognition.captures().getOrThrow((Object)shapedCtor.ctorId(), () -> new InternalException("Invalid moment id: " + String.valueOf(shapedCtor.ctorId()) + " in recognition" + String.valueOf(recognition)));
                                    boolean bl2 = matched = realShapedCtor == ctor.ref();
                                }
                                if (!matched) {
                                    bl = false;
                                    break block12;
                                }
                                bl = ShapeMatcher.matchMany(MatchMode.OrderedEq, ctorLike.innerPats(), ctor.params().view().map(Arg::term), (ps, pt) -> this.matchPat(new MatchPat((PatShape)ps, (Pat)pt)));
                                break block12;
                            }
                        }
                        break;
                    }
                    n = 1;
                    continue block12;
                }
                default: {
                    bl = false;
                    break block12;
                }
            }
            break;
        }
        return bl;
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.toString(), throwable);
        }
    }

    private boolean matchData(@NotNull CodeShape.DataShape shape, @NotNull DataDef data) {
        if (!this.matchTele(shape.tele(), (ImmutableSeq<Term.Param>)data.telescope)) {
            return false;
        }
        return this.matchInside(() -> this.captures.put(shape.name(), data.ref), () -> ShapeMatcher.matchMany(MatchMode.Eq, shape.ctors(), data.body, (s, c) -> this.captureIfMatches((CodeShape.Moment)s, (Object)c, this::matchCtor, CtorDef::ref)));
    }

    private boolean matchCtor(@NotNull CodeShape.CtorShape shape, @NotNull CtorDef ctor) {
        if (ctor.pats.isNotEmpty()) {
            throw new InternalException("Don't try to do this, ask @ice1000 why");
        }
        return this.matchTele(shape.tele(), (ImmutableSeq<Term.Param>)ctor.selfTele);
    }

    private boolean matchTerm(@NotNull TermShape shape, @NotNull Term term) {
        boolean bl;
        TermShape termShape = shape;
        Objects.requireNonNull(termShape);
        TermShape termShape2 = termShape;
        int n = 0;
        block11: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TermShape.Any.class, TermShape.NameCall.class, TermShape.Callable.class, TermShape.Sort.class}, (Object)termShape2, n)) {
                case 0: {
                    TermShape.Any any = (TermShape.Any)termShape2;
                    bl = true;
                    break block11;
                }
                case 1: {
                    TermShape.NameCall call = (TermShape.NameCall)termShape2;
                    if (!call.args().isEmpty() || !(term instanceof RefTerm)) {
                        n = 2;
                        continue block11;
                    }
                    RefTerm ref = (RefTerm)term;
                    if (this.captures.resolve(call.name()) == ref.var()) {
                        bl = true;
                        break block11;
                    }
                    bl = false;
                    break block11;
                }
                case 2: {
                    boolean success;
                    TermShape.Callable call = (TermShape.Callable)termShape2;
                    if (!(term instanceof Callable)) {
                        n = 3;
                        continue block11;
                    }
                    Callable callable = (Callable)term;
                    TermShape.Callable callable2 = call;
                    Objects.requireNonNull(callable2);
                    TermShape.Callable callable3 = callable2;
                    int n2 = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TermShape.NameCall.class, TermShape.ShapeCall.class, TermShape.CtorCall.class}, (Object)callable3, n2)) {
                        default: {
                            throw new RuntimeException(null, null);
                        }
                        case 0: {
                            boolean bl2;
                            TermShape.NameCall nameCall = (TermShape.NameCall)callable3;
                            if (this.captures.resolve(nameCall.name()) == callable.ref()) {
                                bl2 = true;
                                break;
                            }
                            bl2 = false;
                            break;
                        }
                        case 1: {
                            boolean bl2;
                            TermShape.ShapeCall shapeCall = (TermShape.ShapeCall)callable3;
                            AnyVar anyVar = callable.ref();
                            if (anyVar instanceof DefVar) {
                                DefVar defVar = (DefVar)anyVar;
                                bl2 = this.captureIfMatches(shapeCall.name(), defVar, () -> this.discovered.getOption((Object)defVar).map(x -> x.shape().codeShape()).getOrNull() == shapeCall.shape());
                                break;
                            }
                            bl2 = false;
                            break;
                        }
                        case 2: {
                            TermShape.CtorCall ctorCall = (TermShape.CtorCall)callable3;
                            boolean bl2 = success = this.resolveCtor(ctorCall.dataId(), ctorCall.ctorId()) == callable.ref();
                        }
                    }
                    if (!success) {
                        bl = false;
                        break block11;
                    }
                    bl = ShapeMatcher.matchMany(MatchMode.OrderedEq, call.args(), callable.args(), (s, c) -> this.matchTerm((TermShape)s, (Term)c.term()));
                    break block11;
                }
                case 3: {
                    TermShape.Sort sort = (TermShape.Sort)termShape2;
                    if (!(term instanceof SortTerm)) {
                        n = 4;
                        continue block11;
                    }
                    SortTerm sortTerm = (SortTerm)term;
                    if (sort.kind() == null) {
                        bl = true;
                        break block11;
                    }
                    if (sortTerm.kind() == sort.kind()) {
                        bl = true;
                        break block11;
                    }
                    bl = false;
                    break block11;
                }
                default: {
                    bl = false;
                    break block11;
                }
            }
            break;
        }
        return bl;
    }

    private boolean matchTele(@NotNull ImmutableSeq<ParamShape> shape, @NotNull ImmutableSeq<Term.Param> tele) {
        return shape.sizeEquals(tele) && shape.allMatchWith(tele, this::matchParam);
    }

    private boolean matchParam(@NotNull ParamShape shape, @NotNull Term.Param param) {
        ParamShape paramShape = shape;
        Objects.requireNonNull(paramShape);
        ParamShape paramShape2 = paramShape;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ParamShape.Any.class, ParamShape.Licit.class}, (Object)paramShape2, n)) {
            default -> throw new RuntimeException(null, null);
            case 0 -> {
                ParamShape.Any any = (ParamShape.Any)paramShape2;
                yield true;
            }
            case 1 -> {
                ParamShape.Licit licit = (ParamShape.Licit)paramShape2;
                yield !this.matchLicit(licit.kind(), param.explicit()) ? false : this.captureIfMatches(licit.name(), param.ref(), () -> this.matchTerm(licit.type(), param.type()));
            }
        };
    }

    private boolean matchLicit(@NotNull ParamShape.Licit.Kind xlicit, boolean isExplicit) {
        return xlicit == ParamShape.Licit.Kind.Any || xlicit == ParamShape.Licit.Kind.Ex == isExplicit;
    }

    private boolean matchInside(@NotNull Runnable prepare, @NotNull BooleanSupplier matcher) {
        this.captures.fork();
        prepare.run();
        boolean ok = matcher.getAsBoolean();
        if (ok) {
            this.captures.merge();
        } else {
            this.captures.discard();
        }
        return ok;
    }

    private boolean captureIfMatches(@NotNull CodeShape.MomentId name, @NotNull AnyVar var, @NotNull BooleanSupplier matcher) {
        boolean ok = matcher.getAsBoolean();
        if (ok) {
            this.captures.put(name, var);
        }
        return ok;
    }

    private <S extends CodeShape.Moment, C> boolean captureIfMatches(@NotNull S shape, @NotNull C core, @NotNull BiPredicate<S, C> matcher, @NotNull Function<C, DefVar<?, ?>> extract) {
        return this.captureIfMatches(shape.name(), extract.apply(core), () -> matcher.test(shape, core));
    }

    private static <S, C> boolean matchMany(@NotNull MatchMode mode, @NotNull SeqLike<S> shapes, @NotNull SeqLike<C> cores, @NotNull BiFunction<S, C, Boolean> matcher) {
        if (mode == MatchMode.Eq && !shapes.sizeEquals(cores)) {
            return false;
        }
        if (mode == MatchMode.OrderedEq) {
            return shapes.allMatchWith(cores, matcher::apply);
        }
        MutableLinkedList remainingShapes = MutableLinkedList.from(shapes);
        for (Object core : cores) {
            if (remainingShapes.isEmpty()) {
                return mode == MatchMode.Sub;
            }
            int index = remainingShapes.indexWhere(shape -> (Boolean)matcher.apply(shape, core));
            if (index == -1) {
                if (mode == MatchMode.Sub) continue;
                return false;
            }
            remainingShapes.removeAt(index);
        }
        return remainingShapes.isEmpty() || mode == MatchMode.Sup;
    }

    @NotNull
    private DefVar<?, ?> resolveCtor(@NotNull CodeShape.MomentId data, @NotNull CodeShape.GlobalId ctorId) {
        AnyVar anyVar = this.captures.resolve(data);
        if (!(anyVar instanceof DefVar)) {
            throw new InternalException("Not a data");
        }
        DefVar defVar = (DefVar)anyVar;
        ShapeRecognition recog = (ShapeRecognition)this.discovered.getOrThrow((Object)defVar, () -> new InternalException("Not a recognized data"));
        return (DefVar)recog.captures().getOrThrow((Object)ctorId, () -> new InternalException("No such ctor"));
    }

    public record Captures(@NotNull MutableMap<CodeShape.MomentId, AnyVar> map, @NotNull MutableValue<Captures> future) implements RepoLike<Captures>
    {
        @NotNull
        public static Captures create() {
            return new Captures((MutableMap<CodeShape.MomentId, AnyVar>)MutableMap.create(), (MutableValue<Captures>)MutableValue.create());
        }

        @NotNull
        public ImmutableMap<CodeShape.GlobalId, DefVar<?, ?>> extractGlobal() {
            return ImmutableMap.from((Iterable)this.map.toImmutableSeq().view().mapNotNull(x -> {
                Pair pair = new Pair((Object)((CodeShape.MomentId)x.component1()), (Object)((AnyVar)x.component2()));
                Objects.requireNonNull(pair);
                Pair selector1$temp = pair;
                int index$2 = 0;
                block6: while (true) {
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Pair.class}, (Object)selector1$temp, index$2)) {
                        case 0: {
                            CodeShape.MomentId patt3$temp;
                            Pair $b$0 = selector1$temp;
                            try {
                                patt3$temp = (CodeShape.MomentId)$b$0.component1();
                            }
                            catch (Throwable throwable) {
                                throw new RuntimeException(throwable.toString(), throwable);
                            }
                            if (patt3$temp instanceof CodeShape.GlobalId) {
                                CodeShape.GlobalId gid = (CodeShape.GlobalId)patt3$temp;
                                AnyVar patt4$temp = (AnyVar)$b$0.component2();
                                if (patt4$temp instanceof DefVar) {
                                    DefVar dv = (DefVar)patt4$temp;
                                    Tuple2 tuple2 = Tuple.of((Object)gid, (Object)dv);
                                    return tuple2;
                                }
                            }
                            index$2 = 1;
                            continue block6;
                        }
                    }
                    break;
                }
                return null;
            }));
        }

        public void setDownstream(@Nullable Captures downstream) {
            this.future.set((Object)downstream);
        }

        public void fork() {
            super.fork((Object)new Captures((MutableMap<CodeShape.MomentId, AnyVar>)MutableMap.from(this.map), (MutableValue<Captures>)MutableValue.create()));
        }

        public void discard() {
            super.merge();
        }

        public void merge() {
            Captures f = (Captures)this.future.get();
            if (f != null) {
                this.map.putAll(f.map);
            }
            super.merge();
        }

        @NotNull
        private MutableMap<CodeShape.MomentId, AnyVar> choose() {
            Captures f = (Captures)this.future.get();
            return f != null ? f.map : this.map;
        }

        @NotNull
        public AnyVar resolve(@NotNull CodeShape.MomentId id) {
            return (AnyVar)this.choose().getOrThrow((Object)id, () -> new InternalException("Invalid moment id " + String.valueOf(id)));
        }

        public void put(@NotNull CodeShape.MomentId id, @NotNull AnyVar var) {
            this.choose().put((Object)id, (Object)var);
        }
    }

    record MatchDecl(@NotNull CodeShape shape, @NotNull GenericDef def) {
    }

    public static enum MatchMode {
        OrderedEq,
        Sub,
        Eq,
        Sup;

    }

    record MatchPat(@NotNull PatShape shape, @NotNull Pat pat) {
    }
}

