/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.serde;

import java.io.Serializable;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import kala.collection.CollectionView;
import kala.collection.immutable.ImmutableMap;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.immutable.ImmutableSet;
import kala.collection.mutable.MutableList;
import kala.tuple.Tuple;
import kala.tuple.Tuple2;
import kala.tuple.Tuple3;
import org.aya.concrete.desugar.AyaBinOpSet;
import org.aya.concrete.stmt.BindBlock;
import org.aya.concrete.stmt.QualifiedID;
import org.aya.concrete.stmt.Stmt;
import org.aya.concrete.stmt.UseHide;
import org.aya.core.def.ClassDef;
import org.aya.core.def.DataDef;
import org.aya.core.def.GenericDef;
import org.aya.core.repr.AyaShape;
import org.aya.core.serde.SerDef;
import org.aya.core.serde.SerShapable;
import org.aya.core.serde.SerTerm;
import org.aya.core.serde.Serializer;
import org.aya.ref.DefVar;
import org.aya.resolve.ResolveInfo;
import org.aya.resolve.context.Context;
import org.aya.resolve.context.ModuleContext;
import org.aya.resolve.context.ModuleName;
import org.aya.resolve.context.ModulePath;
import org.aya.resolve.context.PhysicalModuleContext;
import org.aya.resolve.error.NameProblem;
import org.aya.resolve.module.ModuleLoader;
import org.aya.util.binop.Assoc;
import org.aya.util.binop.OpDecl;
import org.aya.util.error.SourcePos;
import org.aya.util.error.WithPos;
import org.aya.util.reporter.Problem;
import org.jetbrains.annotations.NotNull;

public record CompiledAya(@NotNull ImmutableSeq<SerImport> imports, @NotNull SerExport exports, @NotNull ImmutableMap<ModulePath, SerUseHide> reExports, @NotNull ImmutableSeq<SerDef> serDefs, @NotNull ImmutableSeq<SerDef.SerOp> serOps, @NotNull ImmutableMap<SerDef.QName, SerDef.SerRenamedOp> opRename) implements Serializable
{
    @NotNull
    public static CompiledAya from(@NotNull ResolveInfo resolveInfo, @NotNull ImmutableSeq<GenericDef> defs, @NotNull Serializer.State state) {
        ModuleContext moduleContext = resolveInfo.thisModule();
        if (!(moduleContext instanceof PhysicalModuleContext)) {
            throw new UnsupportedOperationException();
        }
        PhysicalModuleContext ctx = (PhysicalModuleContext)moduleContext;
        Serialization serialization = new Serialization(state, resolveInfo, (MutableList<SerDef>)MutableList.create(), (MutableList<SerDef.SerOp>)MutableList.create());
        serialization.ser(defs);
        CollectionView exports = ctx.exports().symbols().view().map((k, vs) -> Tuple.of((Object)k, (Object)ImmutableSet.from((Iterable)vs.keysView().map(ModuleName::ids))));
        ImmutableSeq imports = resolveInfo.imports().view().map((k, v) -> new SerImport(((ResolveInfo)v.component1()).thisModule().modulePath(), k.ids(), (Boolean)v.component2())).toImmutableSeq();
        return new CompiledAya((ImmutableSeq<SerImport>)imports, new SerExport((ImmutableMap<String, ImmutableSet<ImmutableSeq<String>>>)ImmutableMap.from((Iterable)exports)), (ImmutableMap<ModulePath, SerUseHide>)ImmutableMap.from((Iterable)resolveInfo.reExports().view().map((k, v) -> Tuple.of((Object)((ResolveInfo)((Tuple2)resolveInfo.imports().get(k)).component1()).thisModule().modulePath(), (Object)SerUseHide.from(v)))), (ImmutableSeq<SerDef>)serialization.serDefs.toImmutableSeq(), (ImmutableSeq<SerDef.SerOp>)serialization.serOps.toImmutableSeq(), (ImmutableMap<SerDef.QName, SerDef.SerRenamedOp>)ImmutableMap.from((Iterable)resolveInfo.opRename().view().map((k, v) -> {
            SerDef.QName name = state.def((DefVar<?, ?>)k);
            OpDecl.OpInfo info = ((ResolveInfo.RenamedOpDecl)v.component1()).opInfo();
            SerDef.SerRenamedOp renamed = new SerDef.SerRenamedOp(info.name(), info.assoc(), serialization.serBind((BindBlock)v.component2()));
            return Tuple.of((Object)((Boolean)v.component3()), (Object)name, (Object)renamed);
        }).filter(Tuple3::head).map(Tuple3::tail)));
    }

    private static SerDef.QName nameOf(@NotNull SerDef def) {
        SerDef serDef = def;
        Objects.requireNonNull(serDef);
        SerDef serDef2 = serDef;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SerDef.Fn.class, SerDef.Clazz.class, SerDef.Field.class, SerDef.Data.class, SerDef.Ctor.class, SerDef.Prim.class}, (Object)serDef2, n)) {
            default -> throw new RuntimeException(null, null);
            case 0 -> {
                SerDef.Fn fn = (SerDef.Fn)serDef2;
                yield fn.name();
            }
            case 1 -> {
                SerDef.Clazz clazz = (SerDef.Clazz)serDef2;
                yield clazz.name();
            }
            case 2 -> {
                SerDef.Field field = (SerDef.Field)serDef2;
                yield field.self();
            }
            case 3 -> {
                SerDef.Data data = (SerDef.Data)serDef2;
                yield data.name();
            }
            case 4 -> {
                SerDef.Ctor ctor = (SerDef.Ctor)serDef2;
                yield ctor.self();
            }
            case 5 -> {
                SerDef.Prim prim = (SerDef.Prim)serDef2;
                yield new SerDef.QName((ImmutableSeq<String>)ImmutableSeq.empty(), (ImmutableSeq<String>)ImmutableSeq.empty(), prim.name().name());
            }
        };
    }

    @NotNull
    public ResolveInfo toResolveInfo(@NotNull ModuleLoader loader, @NotNull PhysicalModuleContext context, @NotNull SerTerm.DeState state) {
        ResolveInfo resolveInfo = new ResolveInfo(state.primFactory(), context, (ImmutableSeq<Stmt>)ImmutableSeq.empty());
        this.shallowResolve(loader, resolveInfo);
        this.serDefs.forEach(serDef -> this.de(resolveInfo.shapeFactory(), context, (SerDef)serDef, state));
        this.deOp(state, resolveInfo);
        return resolveInfo;
    }

    private void shallowResolve(@NotNull ModuleLoader loader, @NotNull ResolveInfo thisResolve) {
        for (SerImport anImport : this.imports) {
            ModulePath modName = anImport.path;
            ModuleName.Qualified modRename = ModuleName.qualified(anImport.rename);
            boolean isPublic = anImport.isPublic;
            ResolveInfo success = loader.load(modName.path());
            if (success == null) {
                thisResolve.thisModule().reportAndThrow(new NameProblem.ModNotFoundError(modName, SourcePos.SER));
            }
            thisResolve.imports().put((Object)modRename, (Object)Tuple.of((Object)success, (Object)isPublic));
            ModuleContext mod = success.thisModule();
            thisResolve.thisModule().importModule(modRename, mod, isPublic ? Stmt.Accessibility.Public : Stmt.Accessibility.Private, SourcePos.SER);
            this.reExports.getOption((Object)modName).forEach(useHide -> thisResolve.thisModule().openModule(modRename, Stmt.Accessibility.Public, (ImmutableSeq<QualifiedID>)useHide.names().map(x -> new QualifiedID(SourcePos.SER, (ImmutableSeq<String>)x)), (ImmutableSeq<WithPos<UseHide.Rename>>)useHide.renames().map(x -> new WithPos(SourcePos.SER, x)), SourcePos.SER, useHide.isUsing() ? UseHide.Strategy.Using : UseHide.Strategy.Hiding));
            Stmt.Accessibility acc = this.reExports.containsKey((Object)modName) ? Stmt.Accessibility.Public : Stmt.Accessibility.Private;
            thisResolve.open(success, SourcePos.SER, acc);
        }
    }

    private void deOp(@NotNull SerTerm.DeState state, @NotNull ResolveInfo resolveInfo) {
        this.serOps.forEach(serOp -> {
            Object defVar = state.resolve(serOp.name());
            OpDecl.OpInfo opInfo = new OpDecl.OpInfo(serOp.name().name(), serOp.assoc());
            ((DefVar)defVar).opDecl = new SerDef.SerOpDecl(opInfo);
        });
        this.opRename.view().forEach((name, serOp) -> {
            Object defVar = state.resolve((SerDef.QName)name);
            String asName = serOp.name();
            Assoc asAssoc = serOp.assoc();
            ResolveInfo.RenamedOpDecl opDecl = new ResolveInfo.RenamedOpDecl(new OpDecl.OpInfo(asName, asAssoc));
            resolveInfo.renameOp((DefVar<?, ?>)defVar, opDecl, BindBlock.EMPTY, true);
        });
        this.serOps.view().forEach(serOp -> {
            Object defVar = state.resolve(serOp.name());
            OpDecl opDecl = ((DefVar)defVar).opDecl;
            assert (opDecl != null);
            this.deBindDontCare(resolveInfo, state, opDecl, serOp.bind());
        });
        this.opRename.view().forEach((name, serOp) -> {
            Object defVar = state.resolve((SerDef.QName)name);
            SerDef.SerBind asBind = serOp.bind();
            ResolveInfo.RenamedOpDecl opDecl = (ResolveInfo.RenamedOpDecl)((Tuple3)resolveInfo.opRename().get(defVar)).component1();
            this.deBindDontCare(resolveInfo, state, opDecl, asBind);
        });
    }

    private void deBindDontCare(@NotNull ResolveInfo resolveInfo, @NotNull SerTerm.DeState state, @NotNull OpDecl opDecl, @NotNull SerDef.SerBind bind) {
        AyaBinOpSet opSet = resolveInfo.opSet();
        opSet.ensureHasElem(opDecl);
        bind.loosers().forEach(looser -> {
            OpDecl target = this.resolveOp(resolveInfo, state, (SerDef.QName)looser);
            opSet.bind(opDecl, OpDecl.BindPred.Looser, target, SourcePos.SER);
        });
        bind.tighters().forEach(tighter -> {
            OpDecl target = this.resolveOp(resolveInfo, state, (SerDef.QName)tighter);
            opSet.bind(opDecl, OpDecl.BindPred.Tighter, target, SourcePos.SER);
        });
    }

    @NotNull
    private OpDecl resolveOp(@NotNull ResolveInfo resolveInfo, @NotNull SerTerm.DeState state, @NotNull SerDef.QName name) {
        OpDecl opDecl;
        Object original = state.resolve(name);
        Tuple3 renamed = (Tuple3)resolveInfo.opRename().getOrNull(original);
        OpDecl opDecl2 = opDecl = renamed != null ? (OpDecl)renamed.component1() : ((DefVar)original).opDecl;
        if (opDecl != null) {
            return opDecl;
        }
        resolveInfo.opSet().reporter.report((Problem)new NameProblem.OperatorNameNotFound(SourcePos.SER, name.toString()));
        throw new Context.ResolvingInterruptedException();
    }

    private void de(@NotNull AyaShape.Factory shapeFactory, @NotNull PhysicalModuleContext context, @NotNull SerDef serDef, @NotNull SerTerm.DeState state) {
        SerShapable serShapeDef;
        ModulePath mod = context.modulePath();
        GenericDef def = serDef.de(state);
        assert (def.ref().core != null);
        if (serDef instanceof SerShapable && (serShapeDef = (SerShapable)((Object)serDef)).shapeResult() != null) {
            shapeFactory.discovered.put((Object)def, (Object)serShapeDef.shapeResult().de(state));
        }
        shapeFactory.bonjour(def);
        SerDef serDef2 = serDef;
        Objects.requireNonNull(serDef2);
        SerDef serDef3 = serDef2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SerDef.Fn.class, SerDef.Data.class, SerDef.Clazz.class, SerDef.Prim.class}, (Object)serDef3, n)) {
            case 0: {
                SerDef.Fn fn = (SerDef.Fn)serDef3;
                if (!this.isExported(mod, fn.name())) break;
                this.export(context, fn.name(), def.ref());
                break;
            }
            case 1: {
                SerDef.Data data = (SerDef.Data)serDef3;
                PhysicalModuleContext innerCtx = context.derive(def.ref().name());
                if (this.isExported(mod, data.name())) {
                    this.export(context, data.name(), def.ref());
                }
                data.bodies().forEachWith(((DataDef)def).body, (ctor, ctorDef) -> {
                    if (this.isExported(mod, ctor.self())) {
                        this.export(context, ctor.self(), ctorDef.ref);
                    }
                    innerCtx.defineSymbol(ctorDef.ref(), Stmt.Accessibility.Public, SourcePos.SER);
                });
                context.importModule(ModuleName.This.resolve(def.ref().name()), innerCtx, Stmt.Accessibility.Public, SourcePos.SER);
                break;
            }
            case 2: {
                SerDef.Clazz clazz = (SerDef.Clazz)serDef3;
                PhysicalModuleContext innerCtx = context.derive(def.ref().name());
                if (this.isExported(mod, clazz.name())) {
                    this.export(context, clazz.name(), def.ref());
                }
                clazz.fields().forEachWith(((ClassDef)def).members, (field, fieldDef) -> {
                    if (this.isExported(mod, field.self())) {
                        this.export(context, field.self(), fieldDef.ref);
                    }
                    innerCtx.defineSymbol(fieldDef.ref, Stmt.Accessibility.Public, SourcePos.SER);
                });
                context.importModule(ModuleName.This.resolve(def.ref().name()), innerCtx, Stmt.Accessibility.Public, SourcePos.SER);
                break;
            }
            case 3: {
                SerDef.Prim prim = (SerDef.Prim)serDef3;
                this.export(context, ModuleName.This, prim.name().id, def.ref());
                break;
            }
        }
    }

    private void export(@NotNull PhysicalModuleContext context, @NotNull SerDef.QName qname, @NotNull DefVar<?, ?> ref) {
        ModulePath modName = context.modulePath();
        ModuleName qmodName = ModuleName.from((ImmutableSeq<String>)qname.mod().drop(modName.path().size()));
        this.export(context, qmodName, qname.name(), ref);
    }

    private void export(@NotNull PhysicalModuleContext context, @NotNull ModuleName component, @NotNull String name, @NotNull DefVar<?, ?> var) {
        boolean success = context.exportSymbol(component, name, var);
        assert (success) : "DuplicateExportError should not happen in CompiledAya";
    }

    private boolean isExported(@NotNull ModulePath module, @NotNull SerDef.QName qname) {
        return this.exports.isExported(module, qname);
    }

    record SerExport(@NotNull ImmutableMap<String, ImmutableSet<ImmutableSeq<String>>> exports) implements Serializable
    {
        public boolean isExported(@NotNull ModulePath module, @NotNull SerDef.QName qname) {
            assert (qname.mod().sizeGreaterThanOrEquals(module.path().size()));
            ImmutableSeq<String> qmod = qname.mod();
            ModuleName component = ModuleName.from((ImmutableSeq<String>)qmod.drop(module.path().size()));
            return (Boolean)this.exports.getOption((Object)qname.name()).map(components -> components.contains(component.ids())).getOrDefault((Object)false);
        }
    }

    private record Serialization(@NotNull Serializer.State state, @NotNull ResolveInfo resolveInfo, @NotNull MutableList<SerDef> serDefs, @NotNull MutableList<SerDef.SerOp> serOps) {
        private void ser(@NotNull ImmutableSeq<GenericDef> defs) {
            AyaShape.Factory factory = this.resolveInfo.shapeFactory();
            defs.forEach(x -> this.serDef(factory, (GenericDef)x));
        }

        private void serDef(@NotNull AyaShape.Factory factory, @NotNull GenericDef def) {
            SerDef serDef = new Serializer(this.state, factory).serialize(def);
            this.serDefs.append((Object)serDef);
            this.serOp(serDef, def);
            SerDef serDef2 = serDef;
            Objects.requireNonNull(serDef2);
            SerDef serDef3 = serDef2;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SerDef.Data.class, SerDef.Clazz.class}, (Object)serDef3, n)) {
                case 0: {
                    SerDef.Data data = (SerDef.Data)serDef3;
                    data.bodies().forEachWith(((DataDef)def).body, this::serOp);
                    break;
                }
                case 1: {
                    SerDef.Clazz clazz = (SerDef.Clazz)serDef3;
                    clazz.fields().forEachWith(((ClassDef)def).members, this::serOp);
                    break;
                }
            }
        }

        private void serOp(@NotNull SerDef serDef, @NotNull GenericDef def) {
            Object concrete = def.ref().concrete;
            OpDecl.OpInfo opInfo = concrete.opInfo();
            if (opInfo != null) {
                this.serOps.append((Object)new SerDef.SerOp(CompiledAya.nameOf(serDef), opInfo.assoc(), this.serBind(concrete.bindBlock())));
            }
        }

        @NotNull
        private SerDef.SerBind serBind(@NotNull BindBlock bindBlock) {
            if (bindBlock == BindBlock.EMPTY) {
                return SerDef.SerBind.EMPTY;
            }
            ImmutableSeq loosers = ((ImmutableSeq)bindBlock.resolvedLoosers().get()).map(this.state::def);
            ImmutableSeq tighters = ((ImmutableSeq)bindBlock.resolvedTighters().get()).map(this.state::def);
            return new SerDef.SerBind((ImmutableSeq<SerDef.QName>)loosers, (ImmutableSeq<SerDef.QName>)tighters);
        }
    }

    record SerImport(@NotNull ModulePath path, @NotNull ImmutableSeq<String> rename, boolean isPublic) implements Serializable
    {
    }

    record SerUseHide(boolean isUsing, @NotNull ImmutableSeq<ImmutableSeq<String>> names, @NotNull ImmutableSeq<UseHide.Rename> renames) implements Serializable
    {
        @NotNull
        public static SerUseHide from(@NotNull UseHide useHide) {
            return new SerUseHide(useHide.strategy() == UseHide.Strategy.Using, (ImmutableSeq<ImmutableSeq<String>>)useHide.list().map(x -> x.id().ids()), (ImmutableSeq<UseHide.Rename>)useHide.renaming().map(WithPos::data));
        }
    }
}

