/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.serde;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import kala.collection.immutable.ImmutableMap;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableMap;
import kala.control.Either;
import kala.tuple.Tuple;
import org.aya.concrete.stmt.decl.TeleDecl;
import org.aya.core.def.ClassDef;
import org.aya.core.def.CtorDef;
import org.aya.core.def.DataDef;
import org.aya.core.def.FnDef;
import org.aya.core.def.GenericDef;
import org.aya.core.def.MemberDef;
import org.aya.core.def.PrimDef;
import org.aya.core.pat.Pat;
import org.aya.core.repr.AyaShape;
import org.aya.core.repr.ShapeRecognition;
import org.aya.core.serde.SerDef;
import org.aya.core.serde.SerPat;
import org.aya.core.serde.SerTerm;
import org.aya.core.term.AppTerm;
import org.aya.core.term.ClassCall;
import org.aya.core.term.CoeTerm;
import org.aya.core.term.ConCall;
import org.aya.core.term.DataCall;
import org.aya.core.term.ErrorTerm;
import org.aya.core.term.FieldTerm;
import org.aya.core.term.FnCall;
import org.aya.core.term.FormulaTerm;
import org.aya.core.term.HCompTerm;
import org.aya.core.term.InTerm;
import org.aya.core.term.IntegerOps;
import org.aya.core.term.IntegerTerm;
import org.aya.core.term.IntervalTerm;
import org.aya.core.term.LamTerm;
import org.aya.core.term.ListTerm;
import org.aya.core.term.MatchTerm;
import org.aya.core.term.MetaLitTerm;
import org.aya.core.term.MetaPatTerm;
import org.aya.core.term.MetaTerm;
import org.aya.core.term.NewTerm;
import org.aya.core.term.OutTerm;
import org.aya.core.term.PAppTerm;
import org.aya.core.term.PLamTerm;
import org.aya.core.term.PartialTerm;
import org.aya.core.term.PartialTyTerm;
import org.aya.core.term.PathTerm;
import org.aya.core.term.PiTerm;
import org.aya.core.term.PrimCall;
import org.aya.core.term.ProjTerm;
import org.aya.core.term.RefTerm;
import org.aya.core.term.RuleReducer;
import org.aya.core.term.SigmaTerm;
import org.aya.core.term.SortTerm;
import org.aya.core.term.StringTerm;
import org.aya.core.term.Term;
import org.aya.core.term.TupTerm;
import org.aya.generic.Shaped;
import org.aya.guest0x0.cubical.Formula;
import org.aya.guest0x0.cubical.Partial;
import org.aya.guest0x0.cubical.Restr;
import org.aya.ref.DefVar;
import org.aya.ref.LocalVar;
import org.aya.util.Arg;
import org.aya.util.error.InternalException;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public record Serializer(@NotNull State state, @NotNull AyaShape.Factory factory) {
    @NotNull
    public SerDef serialize(@NotNull GenericDef def) {
        GenericDef genericDef = def;
        Objects.requireNonNull(genericDef);
        GenericDef genericDef2 = genericDef;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FnDef.class, MemberDef.class, ClassDef.class, DataDef.class, PrimDef.class, CtorDef.class}, (Object)genericDef2, n)) {
            default -> throw new RuntimeException(null, null);
            case 0 -> {
                FnDef fn = (FnDef)genericDef2;
                yield new SerDef.Fn(this.state.def(fn.ref), this.serializeParams((ImmutableSeq<Term.Param>)fn.telescope), (Either<SerTerm, ImmutableSeq<SerPat.Clause>>)fn.body.map(this::serialize, matchings -> matchings.map(this::serialize)), fn.modifiers, this.serialize(fn.result), (SerDef.SerShapeResult)this.factory.find(def).map(x -> SerDef.SerShapeResult.serialize(this.state, x)).getOrNull());
            }
            case 1 -> {
                MemberDef field = (MemberDef)genericDef2;
                yield new SerDef.Field(this.state.def(field.classRef), this.state.def(field.ref), this.serializeParams((ImmutableSeq<Term.Param>)field.telescope), this.serialize(field.result), field.coerce);
            }
            case 2 -> {
                ClassDef clazz = (ClassDef)genericDef2;
                yield new SerDef.Clazz(this.state.def(clazz.ref()), (ImmutableSeq<SerDef.Field>)clazz.members.map(field -> (SerDef.Field)this.serialize((GenericDef)field)));
            }
            case 3 -> {
                DataDef data = (DataDef)genericDef2;
                yield new SerDef.Data(this.state.def(data.ref), this.serializeParams((ImmutableSeq<Term.Param>)data.telescope), this.serialize((SortTerm)data.result), (ImmutableSeq<SerDef.Ctor>)data.body.map(ctor -> (SerDef.Ctor)this.serialize((GenericDef)ctor)));
            }
            case 4 -> {
                PrimDef prim = (PrimDef)genericDef2;
                if (!$assertionsDisabled && prim.ref.module == null) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && prim.ref.fileModule == null) {
                    throw new AssertionError();
                }
                yield new SerDef.Prim(prim.ref.module, prim.ref.fileModule, prim.id);
            }
            case 5 -> {
                CtorDef ctor = (CtorDef)genericDef2;
                yield new SerDef.Ctor(this.state.def(ctor.dataRef), this.state.def(ctor.ref), this.serializePats(ctor.pats), this.serializeParams((ImmutableSeq<Term.Param>)ctor.ownerTele), this.serializeParams((ImmutableSeq<Term.Param>)ctor.selfTele), (Partial.Split<SerTerm>)ctor.clauses.fmap(this::serialize), this.serialize(ctor.result), ctor.coerce);
            }
        };
    }

    @NotNull
    private SerTerm.Sort serialize(@NotNull SortTerm term) {
        return new SerTerm.Sort(term.kind(), term.lift());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private SerTerm serialize(@NotNull Term term) {
        SerTerm serTerm;
        Term term2 = term;
        Objects.requireNonNull(term2);
        Term term3 = term2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IntegerTerm.class, ListTerm.class, FormulaTerm.class, StringTerm.class, RefTerm.class, RefTerm.Field.class, IntervalTerm.class, PiTerm.class, SigmaTerm.class, ConCall.class, ClassCall.class, DataCall.class, PrimCall.class, FieldTerm.class, FnCall.class, RuleReducer.Fn.class, RuleReducer.Con.class, ProjTerm.class, AppTerm.class, MatchTerm.class, TupTerm.class, LamTerm.class, NewTerm.class, PartialTerm.class, PartialTyTerm.class, PathTerm.class, PLamTerm.class, PAppTerm.class, CoeTerm.class, SortTerm.class, MetaTerm.class, MetaPatTerm.class, ErrorTerm.class, MetaLitTerm.class, HCompTerm.class, InTerm.class, OutTerm.class}, (Object)term3, n)) {
            default: {
                throw new RuntimeException(null, null);
            }
            case 0: {
                IntegerTerm lit = (IntegerTerm)term3;
                serTerm = new SerTerm.ShapedInt(lit.repr(), SerDef.SerShapeResult.serialize(this.state, lit.recognition()), (SerTerm.Data)this.serialize(lit.type()));
                return serTerm;
            }
            case 1: {
                ListTerm lit = (ListTerm)term3;
                serTerm = new SerTerm.ShapedList((ImmutableSeq<SerTerm>)lit.repr().map(this::serialize), SerDef.SerShapeResult.serialize(this.state, lit.recognition()), (SerTerm.Data)this.serialize(lit.type()));
                return serTerm;
            }
            case 2: {
                FormulaTerm end = (FormulaTerm)term3;
                serTerm = new SerTerm.Mula((Formula<SerTerm>)end.asFormula().fmap(this::serialize));
                return serTerm;
            }
            case 3: {
                StringTerm str = (StringTerm)term3;
                serTerm = new SerTerm.Str(str.string());
                return serTerm;
            }
            case 4: {
                RefTerm ref = (RefTerm)term3;
                serTerm = new SerTerm.Ref(this.state.local(ref.var()));
                return serTerm;
            }
            case 5: {
                RefTerm.Field ref = (RefTerm.Field)term3;
                serTerm = new SerTerm.FieldRef(this.state.def(ref.ref()));
                return serTerm;
            }
            case 6: {
                IntervalTerm interval = (IntervalTerm)term3;
                serTerm = SerTerm.Interval.INSTANCE;
                return serTerm;
            }
            case 7: {
                PiTerm pi = (PiTerm)term3;
                serTerm = new SerTerm.Pi(this.serialize(pi.param()), this.serialize(pi.body()));
                return serTerm;
            }
            case 8: {
                SigmaTerm sigma = (SigmaTerm)term3;
                serTerm = new SerTerm.Sigma(this.serializeParams(sigma.params()));
                return serTerm;
            }
            case 9: {
                ConCall conCall = (ConCall)term3;
                serTerm = new SerTerm.Con(this.state.def(conCall.head().dataRef()), this.state.def(conCall.head().ref()), this.serializeCall(conCall.head().ulift(), conCall.head().dataArgs()), this.serializeArgs(conCall.conArgs()));
                return serTerm;
            }
            case 10: {
                ClassCall classCall = (ClassCall)term3;
                serTerm = this.serializeClassCall(classCall);
                return serTerm;
            }
            case 11: {
                DataCall dataCall = (DataCall)term3;
                serTerm = this.serializeDataCall(dataCall);
                return serTerm;
            }
            case 12: {
                PrimCall prim = (PrimCall)term3;
                serTerm = new SerTerm.Prim(this.state.def((DefVar<?, ?>)prim.ref()), prim.id(), this.serializeCall(prim.ulift(), prim.args()));
                return serTerm;
            }
            case 13: {
                FieldTerm access = (FieldTerm)term3;
                serTerm = new SerTerm.Access(this.serialize(access.of()), this.state.def((DefVar<?, ?>)access.ref()), this.serializeArgs(access.args()));
                return serTerm;
            }
            case 14: {
                FnCall fnCall = (FnCall)term3;
                serTerm = new SerTerm.Fn(this.state.def((DefVar<?, ?>)fnCall.ref()), this.serializeCall(fnCall.ulift(), fnCall.args()));
                return serTerm;
            }
            case 15: {
                RuleReducer.Fn fn = (RuleReducer.Fn)term3;
                try {
                    ImmutableSeq<Arg<Term>> immutableSeq;
                    int n2;
                    Shaped.Applicable<Term, FnDef, TeleDecl.FnDecl> applicable;
                    Shaped.Applicable<Term, FnDef, TeleDecl.FnDecl> head = applicable = fn.rule();
                    int ulift = n2 = fn.ulift();
                    ImmutableSeq<Arg<Term>> args = immutableSeq = fn.args();
                    serTerm = new SerTerm.FnReduceRule(this.serializeShapedApplicable(head), this.serializeCall(ulift, args));
                    return serTerm;
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable.toString(), throwable);
                }
            }
            case 16: {
                RuleReducer.Con con = (RuleReducer.Con)term3;
                {
                    ImmutableSeq<Arg<Term>> immutableSeq;
                    int n3;
                    Shaped.Applicable<Term, CtorDef, TeleDecl.DataCtor> applicable;
                    Shaped.Applicable<Term, CtorDef, TeleDecl.DataCtor> head = applicable = con.rule();
                    int ulift = n3 = con.ulift();
                    ImmutableSeq<Arg<Term>> dataArgs = immutableSeq = con.dataArgs();
                    ImmutableSeq<Arg<Term>> conArgs = immutableSeq = con.conArgs();
                    serTerm = new SerTerm.ConReduceRule(this.serializeShapedApplicable(head), this.serializeCall(ulift, dataArgs), (ImmutableSeq<SerTerm.SerArg>)conArgs.map(this::serialize));
                    return serTerm;
                }
            }
            case 17: {
                ProjTerm proj = (ProjTerm)term3;
                serTerm = new SerTerm.Proj(this.serialize(proj.of()), proj.ix());
                return serTerm;
            }
            case 18: {
                AppTerm app = (AppTerm)term3;
                serTerm = new SerTerm.App(this.serialize(app.of()), this.serialize(app.arg()));
                return serTerm;
            }
            case 19: {
                MatchTerm matchTerm = (MatchTerm)term3;
                {
                    Object object;
                    ImmutableSeq<Term> disc = object = matchTerm.discriminant();
                    Object clauses = object = matchTerm.clauses();
                    serTerm = new SerTerm.Match((ImmutableSeq<SerTerm>)disc.map(this::serialize), (ImmutableSeq<SerPat.Clause>)clauses.map(this::serialize));
                    return serTerm;
                }
            }
            case 20: {
                TupTerm tuple = (TupTerm)term3;
                serTerm = new SerTerm.Tup(this.serializeArgs(tuple.items()));
                return serTerm;
            }
            case 21: {
                LamTerm lamTerm = (LamTerm)term3;
                {
                    Object object = lamTerm.param();
                    LamTerm.Param param = object;
                    Object body = object = lamTerm.body();
                    serTerm = new SerTerm.Lam(this.serialize(param.ref()), param.explicit(), this.serialize((Term)body));
                    return serTerm;
                }
            }
            case 22: {
                NewTerm newTerm = (NewTerm)term3;
                serTerm = new SerTerm.New(this.serializeClassCall(newTerm.inner()));
                return serTerm;
            }
            case 23: {
                PartialTerm el = (PartialTerm)term3;
                serTerm = new SerTerm.PartEl(this.partial(el.partial()), this.serialize(el.rhsType()));
                return serTerm;
            }
            case 24: {
                PartialTyTerm ty = (PartialTyTerm)term3;
                serTerm = new SerTerm.PartTy(this.serialize(ty.type()), (Restr<SerTerm>)ty.restr().fmap(this::serialize));
                return serTerm;
            }
            case 25: {
                PathTerm path = (PathTerm)term3;
                serTerm = this.serialize(path);
                return serTerm;
            }
            case 26: {
                PLamTerm pLamTerm = (PLamTerm)term3;
                {
                    Object object;
                    ImmutableSeq<LocalVar> params = object = pLamTerm.params();
                    Object body = object = pLamTerm.body();
                    serTerm = new SerTerm.PathLam(this.serializeIntervals(params), this.serialize((Term)body));
                    return serTerm;
                }
            }
            case 27: {
                PAppTerm pAppTerm = (PAppTerm)term3;
                {
                    Object object;
                    ImmutableSeq<Arg<Term>> of = object = pAppTerm.of();
                    ImmutableSeq<Arg<Term>> args = object = pAppTerm.args();
                    Object cube = object = pAppTerm.cube();
                    serTerm = new SerTerm.PathApp(this.serialize((Term)of), this.serializeArgs(args), this.serialize((PathTerm)cube));
                    return serTerm;
                }
            }
            case 28: {
                CoeTerm coeTerm = (CoeTerm)term3;
                {
                    Term term4;
                    Term ty = term4 = coeTerm.type();
                    Term r = term4 = coeTerm.r();
                    Term s = term4 = coeTerm.s();
                    serTerm = new SerTerm.Coe(this.serialize(ty), this.serialize(r), this.serialize(s));
                    return serTerm;
                }
            }
            case 29: {
                SortTerm sort = (SortTerm)term3;
                serTerm = this.serialize(sort);
                return serTerm;
            }
            case 30: {
                MetaTerm hole = (MetaTerm)term3;
                throw new InternalException("Shall not have holes serialized.");
            }
            case 31: {
                MetaPatTerm metaPat = (MetaPatTerm)term3;
                throw new InternalException("Shall not have metaPats serialized.");
            }
            case 32: {
                ErrorTerm err = (ErrorTerm)term3;
                throw new InternalException("Shall not have error term serialized.");
            }
            case 33: {
                MetaLitTerm err = (MetaLitTerm)term3;
                throw new InternalException("Shall not have metaLiterals serialized.");
            }
            case 34: {
                HCompTerm hComp = (HCompTerm)term3;
                throw new InternalException("TODO");
            }
            case 35: {
                InTerm inTerm = (InTerm)term3;
                {
                    Term term5;
                    Term phi = term5 = inTerm.phi();
                    Term u = term5 = inTerm.u();
                    serTerm = new SerTerm.InS(this.serialize(phi), this.serialize(u));
                    return serTerm;
                }
            }
            case 36: 
        }
        OutTerm outTerm = (OutTerm)term3;
        {
            Term term6;
            Term phi = term6 = outTerm.phi();
            Term par = term6 = outTerm.partial();
            Term u = term6 = outTerm.of();
            serTerm = new SerTerm.OutS(this.serialize(phi), this.serialize(par), this.serialize(u));
        }
        return serTerm;
    }

    @NotNull
    private Partial<SerTerm> partial(Partial<Term> el) {
        return el.fmap(this::serialize);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private SerPat serialize(@NotNull Pat pat, boolean explicit) {
        Record record;
        Pat pat2 = pat;
        Objects.requireNonNull(pat2);
        Pat pat3 = pat2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Pat.Absurd.class, Pat.Ctor.class, Pat.Tuple.class, Pat.Bind.class, Pat.Meta.class, Pat.ShapedInt.class}, (Object)pat3, n)) {
            default: {
                throw new RuntimeException(null, null);
            }
            case 0: {
                Pat.Absurd absurd = (Pat.Absurd)pat3;
                record = new SerPat.Absurd(explicit);
                return record;
            }
            case 1: {
                SerDef.SerShapeResult serShapeResult;
                Object dataCall;
                DefVar<CtorDef, TeleDecl.DataCtor> params;
                DefVar<CtorDef, TeleDecl.DataCtor> ref;
                Pat.Ctor ctor = (Pat.Ctor)pat3;
                try {
                    Object object = ctor.ref();
                    ref = object;
                    object = ctor.params();
                    params = object;
                    Object typeRecog = object = ctor.typeRecog();
                    dataCall = object = ctor.type();
                    serShapeResult = typeRecog == null ? null : SerDef.SerShapeResult.serialize(this.state, (ShapeRecognition)typeRecog);
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable.toString(), throwable);
                }
                SerDef.SerShapeResult shapeResult = serShapeResult;
                record = new SerPat.Ctor(explicit, this.state.def(ref), this.serializePats((ImmutableSeq<Arg<Pat>>)params), shapeResult, this.serializeDataCall((DataCall)dataCall));
                return record;
            }
            case 2: {
                Pat.Tuple tuple = (Pat.Tuple)pat3;
                record = new SerPat.Tuple(explicit, this.serializePats(tuple.pats()));
                return record;
            }
            case 3: {
                Pat.Bind bind = (Pat.Bind)pat3;
                record = new SerPat.Bind(explicit, this.state.local(bind.bind()), this.serialize(bind.type()));
                return record;
            }
            case 4: {
                Pat.Meta meta = (Pat.Meta)pat3;
                throw new InternalException(String.valueOf(meta) + " is illegal here");
            }
            case 5: 
        }
        Pat.ShapedInt lit = (Pat.ShapedInt)pat3;
        record = new SerPat.ShapedInt(lit.repr(), explicit, SerDef.SerShapeResult.serialize(this.state, lit.recognition()), this.serializeDataCall(lit.type()));
        return record;
    }

    @NotNull
    private SerTerm.Path serialize(@NotNull PathTerm cube) {
        return new SerTerm.Path(this.serializeIntervals(cube.params()), this.serialize(cube.type()), this.partial(cube.partial()));
    }

    @NotNull
    private SerTerm.Data serializeDataCall(@NotNull DataCall dataCall) {
        return new SerTerm.Data(this.state.def((DefVar<?, ?>)dataCall.ref()), this.serializeCall(dataCall.ulift(), dataCall.args()));
    }

    @NotNull
    private SerTerm.Clazz serializeClassCall(@NotNull ClassCall classCall) {
        return new SerTerm.Clazz(this.state.def(classCall.ref()), classCall.ulift(), (ImmutableMap<SerDef.QName, SerTerm.SerArg>)ImmutableMap.from((Iterable)classCall.args().view().map((k, v) -> Tuple.of((Object)this.state.def((DefVar<?, ?>)k), (Object)this.serialize((Arg<Term>)v)))));
    }

    @NotNull
    private SerTerm.SerShapedApplicable serializeShapedApplicable(@NotNull Shaped.Applicable<Term, ?, ?> shapedApplicable) {
        Shaped.Applicable<Term, ?, ?> applicable = shapedApplicable;
        Objects.requireNonNull(applicable);
        Shaped.Applicable<Term, ?, ?> applicable2 = applicable;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IntegerOps.ConRule.class, IntegerOps.FnRule.class}, applicable2, n)) {
            case 0 -> {
                IntegerOps.ConRule conRule = (IntegerOps.ConRule)applicable2;
                yield new SerTerm.SerIntegerOps(this.state.def(conRule.ref()), (Either<SerTerm.ConInfo, IntegerOps.FnRule.Kind>)Either.left((Object)new SerTerm.ConInfo(SerDef.SerShapeResult.serialize(this.state, conRule.paramRecognition()), (SerTerm.Data)this.serialize(conRule.paramType()))));
            }
            case 1 -> {
                IntegerOps.FnRule fnRule = (IntegerOps.FnRule)applicable2;
                yield new SerTerm.SerIntegerOps(this.state.def(fnRule.ref()), (Either<SerTerm.ConInfo, IntegerOps.FnRule.Kind>)Either.right((Object)fnRule.kind()));
            }
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(shapedApplicable));
        };
    }

    @NotNull
    private SerPat.Clause serialize(@NotNull Term.Matching matchy) {
        return new SerPat.Clause(this.serializePats(matchy.patterns()), this.serialize(matchy.body()));
    }

    private SerTerm.SerArg serialize(@NotNull @NotNull Arg<@NotNull Term> termArg) {
        return new SerTerm.SerArg(this.serialize((Term)termArg.term()), termArg.explicit());
    }

    @Contract(value="_ -> new")
    private SerTerm.SerParam serialize(@NotNull Term.Param param) {
        return new SerTerm.SerParam(param.explicit(), this.serialize(param.ref()), this.serialize(param.type()));
    }

    @NotNull
    private SerTerm.SimpVar serialize(@NotNull LocalVar localVar) {
        return this.state.local(localVar);
    }

    @NotNull
    private ImmutableSeq<SerTerm.SerParam> serializeParams(ImmutableSeq<@NotNull Term.Param> params) {
        return params.map(this::serialize);
    }

    @NotNull
    private ImmutableSeq<SerTerm.SimpVar> serializeIntervals(ImmutableSeq<LocalVar> params) {
        return params.map(this::serialize);
    }

    @NotNull
    private ImmutableSeq<SerTerm.SerArg> serializeArgs(@NotNull ImmutableSeq<Arg<Term>> args) {
        return args.map(this::serialize);
    }

    @NotNull
    private ImmutableSeq<SerPat> serializePats(@NotNull ImmutableSeq<Arg<Pat>> pats) {
        return pats.map(x -> this.serialize((Pat)x.term(), x.explicit()));
    }

    @NotNull
    private SerTerm.CallData serializeCall(int ulift, @NotNull @NotNull ImmutableSeq<Arg<@NotNull Term>> args) {
        return new SerTerm.CallData(ulift, this.serializeArgs(args));
    }

    public record State(@NotNull MutableMap<LocalVar, Integer> localCache) {
        public State() {
            this((MutableMap<LocalVar, Integer>)MutableMap.create());
        }

        @NotNull
        public SerTerm.SimpVar local(@NotNull LocalVar var) {
            return new SerTerm.SimpVar((Integer)this.localCache.getOrPut((Object)var, () -> this.localCache.size()), var.name());
        }

        @NotNull
        public SerDef.QName def(@NotNull DefVar<?, ?> var) {
            assert (var.module != null);
            assert (var.fileModule != null);
            return new SerDef.QName(var.module, var.fileModule, var.name());
        }
    }
}

