/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.term;

import java.util.Iterator;
import java.util.function.UnaryOperator;
import kala.collection.SeqLike;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableMap;
import kala.collection.immutable.ImmutableSeq;
import kala.control.Option;
import kala.control.Result;
import kala.tuple.Tuple;
import kala.tuple.Tuple2;
import org.aya.concrete.Expr;
import org.aya.concrete.stmt.decl.ClassDecl;
import org.aya.concrete.stmt.decl.TeleDecl;
import org.aya.core.def.ClassDef;
import org.aya.core.def.Def;
import org.aya.core.def.MemberDef;
import org.aya.core.pat.Pat;
import org.aya.core.term.Formation;
import org.aya.core.term.StableWHNF;
import org.aya.core.term.Term;
import org.aya.core.visitor.Subst;
import org.aya.ref.DefVar;
import org.aya.ref.LocalVar;
import org.aya.tyck.ExprTycker;
import org.aya.tyck.error.FieldError;
import org.aya.util.Arg;
import org.aya.util.error.SourcePos;
import org.aya.util.error.WithPos;
import org.aya.util.reporter.Problem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record ClassCall(@NotNull DefVar<ClassDef, ClassDecl> ref, int ulift, @NotNull ImmutableMap<DefVar<MemberDef, TeleDecl.ClassMember>, Arg<Term>> args) implements StableWHNF,
Formation
{
    @NotNull
    public Subst fieldSubst(@Nullable MemberDef member) {
        MemberDef mapping;
        Subst fieldSubst = new Subst();
        Iterator iterator = ((ClassDef)this.ref.core).members.iterator();
        while (iterator.hasNext() && (mapping = (MemberDef)iterator.next()) != member) {
            Arg inst = (Arg)this.args.getOrNull(mapping.ref);
            if (inst == null) continue;
            fieldSubst.add(mapping.ref, (Term)inst.term());
        }
        return fieldSubst;
    }

    @NotNull
    public SeqView<MemberDef> missingMembers() {
        return ((ClassDef)this.ref.core).members.view().filter(mem -> !this.args.containsKey(mem.ref));
    }

    public boolean instantiated(@NotNull MemberDef member) {
        return this.args.containsKey(member.ref);
    }

    public boolean sameApply(@NotNull ClassCall other) {
        return this.ref == other.ref && this.args.keysView().toImmutableSet().sameElements((Iterable)other.args.keysView().toImmutableSet(), true);
    }

    @NotNull
    public ImmutableSeq<Arg<Term>> orderedArgs() {
        return ((ClassDef)this.ref.core).members.flatMap(m -> this.args.getOption(m.ref));
    }

    @NotNull
    public Result<ClassCall, Problem> addMember(@NotNull Expr.Field<Expr> member, @NotNull ExprTycker tycker) {
        Option fieldRefOpt = ((ClassDef)this.ref.core).members.find(m -> m.ref.name().equals(member.name().data()));
        if (fieldRefOpt.isEmpty()) {
            return Result.err((Object)new FieldError.NoSuchField(this.ref, member));
        }
        MemberDef memberRef = (MemberDef)((MemberDef)fieldRefOpt.get()).ref.core;
        if (this.instantiated(memberRef)) {
            throw new UnsupportedOperationException("TODO: report duplicate field");
        }
        member.resolvedField().set(memberRef.ref);
        SeqView telescopeExplicit = Def.defTele(memberRef.ref).view().map(Term.Param::explicit);
        ImmutableSeq<WithPos<LocalVar>> bindings = member.bindings();
        if (telescopeExplicit.sizeLessThan(bindings.size())) {
            SourcePos errPos = member.sourcePos().sourcePosForSubExpr(bindings.view().map(WithPos::sourcePos));
            return Result.err((Object)new FieldError.ArgMismatch(errPos, memberRef, bindings.size()));
        }
        Expr fieldExpr = (Expr)bindings.zipView((SeqLike)telescopeExplicit).foldRight((Object)member.body(), (pair, lamExpr) -> new Expr.Lambda(((Expr)member.body()).sourcePos(), new Expr.Param(((WithPos)pair.component1()).sourcePos(), (LocalVar)((WithPos)pair.component1()).data(), (Boolean)pair.component2()), (Expr)lamExpr));
        return Result.ok((Object)this.addMember(tycker, memberRef, fieldExpr));
    }

    @NotNull
    public ClassCall addMember(@NotNull ExprTycker tycker, @NotNull MemberDef member, Expr expr) {
        Subst subst = this.fieldSubst(member);
        Term type = Def.defType(member.ref).subst(subst, this.ulift);
        Term field = tycker.inherit(expr, type).wellTyped();
        ImmutableMap newArgs = this.args.putted(member.ref, (Object)new Arg((Object)field, true));
        return new ClassCall(this.ref, this.ulift, (ImmutableMap<DefVar<MemberDef, TeleDecl.ClassMember>, Arg<Term>>)newArgs);
    }

    @NotNull
    public ClassCall update(@NotNull ImmutableSeq<Tuple2<DefVar<MemberDef, TeleDecl.ClassMember>, Arg<Term>>> args) {
        return args.sameElements((Iterable)this.args().toImmutableSeq(), true) ? this : new ClassCall(this.ref(), this.ulift(), (ImmutableMap<DefVar<MemberDef, TeleDecl.ClassMember>, Arg<Term>>)ImmutableMap.from(args));
    }

    @Override
    @NotNull
    public ClassCall descent(@NotNull @NotNull UnaryOperator<@NotNull Term> f, @NotNull UnaryOperator<Pat> g) {
        return this.update((ImmutableSeq<Tuple2<DefVar<MemberDef, TeleDecl.ClassMember>, Arg<Term>>>)this.args.toImmutableSeq().map(t -> Tuple.of((Object)((DefVar)t.component1()), (Object)((Arg)t.component2()).descent(f))));
    }
}

