/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.term;

import java.io.Serializable;
import kala.collection.immutable.ImmutableSeq;
import org.aya.concrete.stmt.decl.TeleDecl;
import org.aya.core.def.CtorDef;
import org.aya.core.def.Def;
import org.aya.core.def.FnDef;
import org.aya.core.repr.CodeShape;
import org.aya.core.repr.ShapeRecognition;
import org.aya.core.term.DataCall;
import org.aya.core.term.IntegerTerm;
import org.aya.core.term.PiTerm;
import org.aya.core.term.Term;
import org.aya.generic.Shaped;
import org.aya.ref.DefVar;
import org.aya.util.Arg;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface IntegerOps<Core extends Def, Concrete extends TeleDecl<?>>
extends Shaped.Applicable<Term, Core, Concrete> {
    @Override
    @NotNull
    default public Term type() {
        Def core = (Def)this.ref().core;
        if (!1.$assertionsDisabled && core == null) {
            throw new AssertionError();
        }
        return PiTerm.make(core.telescope(), core.result());
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public record FnRule(@NotNull DefVar<FnDef, TeleDecl.FnDecl> ref, @NotNull Kind kind) implements IntegerOps<FnDef, TeleDecl.FnDecl>
    {
        @Override
        @Nullable
        public Term apply(@NotNull ImmutableSeq<Arg<Term>> args) {
            return switch (this.kind) {
                default -> throw new RuntimeException(null, null);
                case Kind.Add -> {
                    if (!$assertionsDisabled && !args.sizeEquals(2)) {
                        throw new AssertionError();
                    }
                    Term a = (Term)((Arg)args.get(0)).term();
                    Term b = (Term)((Arg)args.get(1)).term();
                    if (a instanceof IntegerTerm) {
                        IntegerTerm ita = (IntegerTerm)a;
                        if (b instanceof IntegerTerm) {
                            IntegerTerm itb = (IntegerTerm)b;
                            yield ita.map(x -> x + itb.repr());
                        }
                    }
                    yield null;
                }
                case Kind.SubTrunc -> {
                    if (!$assertionsDisabled && !args.sizeEquals(2)) {
                        throw new AssertionError();
                    }
                    Term a = (Term)((Arg)args.get(0)).term();
                    Term b = (Term)((Arg)args.get(1)).term();
                    if (a instanceof IntegerTerm) {
                        IntegerTerm ita = (IntegerTerm)a;
                        if (b instanceof IntegerTerm) {
                            IntegerTerm itb = (IntegerTerm)b;
                            yield ita.map(x -> Math.max(x - itb.repr(), 0));
                        }
                    }
                    yield null;
                }
            };
        }

        public static enum Kind implements Serializable
        {
            Add,
            SubTrunc;

        }
    }

    public record ConRule(@NotNull DefVar<CtorDef, TeleDecl.DataCtor> ref, @NotNull ShapeRecognition paramRecognition, @NotNull DataCall paramType) implements IntegerOps<CtorDef, TeleDecl.DataCtor>
    {
        public boolean isZero() {
            return this.paramRecognition.captures().get((Object)CodeShape.GlobalId.ZERO) == this.ref;
        }

        @Override
        @Nullable
        public Term apply(@NotNull ImmutableSeq<Arg<Term>> args) {
            if (this.isZero()) {
                assert (args.isEmpty());
                return new IntegerTerm(0, this.paramRecognition, this.paramType);
            }
            assert (args.sizeEquals(1));
            Term arg = (Term)((Arg)args.get(0)).term();
            if (arg instanceof IntegerTerm) {
                IntegerTerm intTerm = (IntegerTerm)arg;
                return intTerm.map(x -> x + 1);
            }
            return null;
        }
    }
}

