/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.term;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.function.IntUnaryOperator;
import java.util.function.UnaryOperator;
import kala.collection.immutable.ImmutableSeq;
import org.aya.concrete.stmt.decl.TeleDecl;
import org.aya.core.def.CtorDef;
import org.aya.core.def.DataDef;
import org.aya.core.pat.Pat;
import org.aya.core.repr.CodeShape;
import org.aya.core.repr.ShapeRecognition;
import org.aya.core.term.ConCallLike;
import org.aya.core.term.DataCall;
import org.aya.core.term.IntegerOps;
import org.aya.core.term.RuleReducer;
import org.aya.core.term.StableWHNF;
import org.aya.core.term.Term;
import org.aya.generic.Shaped;
import org.aya.ref.DefVar;
import org.aya.util.Arg;
import org.jetbrains.annotations.NotNull;

public final class IntegerTerm
extends Record
implements StableWHNF,
Shaped.Nat<Term>,
ConCallLike {
    private final int repr;
    @NotNull
    private final ShapeRecognition recognition;
    @NotNull
    private final DataCall type;

    public IntegerTerm(int repr, @NotNull ShapeRecognition recognition, @NotNull DataCall type) {
        assert (repr >= 0);
        this.repr = repr;
        this.recognition = recognition;
        this.type = type;
    }

    @Override
    @NotNull
    public ConCallLike.Head head() {
        DefVar ref = this.repr == 0 ? this.ctorRef(CodeShape.GlobalId.ZERO) : this.ctorRef(CodeShape.GlobalId.SUC);
        return new ConCallLike.Head((DefVar<DataDef, TeleDecl.DataDecl>)this.type.ref(), ((CtorDef)ref.core).ref, 0, (ImmutableSeq<Arg<Term>>)ImmutableSeq.empty());
    }

    @Override
    @NotNull
    public ImmutableSeq<Arg<Term>> conArgs() {
        if (this.repr == 0) {
            return ImmutableSeq.empty();
        }
        ImmutableSeq ctorTele = ((CtorDef)this.head().ref().core).selfTele;
        assert (ctorTele.sizeEquals(1));
        return ImmutableSeq.of((Object)new Arg((Object)new IntegerTerm(this.repr - 1, this.recognition, this.type), ((Term.Param)ctorTele.getFirst()).explicit()));
    }

    @Override
    @NotNull
    public IntegerTerm descent(@NotNull UnaryOperator<Term> f, @NotNull UnaryOperator<Pat> g) {
        return this;
    }

    @Override
    @NotNull
    public Term constructorForm() {
        return this;
    }

    @Override
    @NotNull
    public Term makeZero(@NotNull CtorDef zero) {
        return this.map(x -> 0);
    }

    @Override
    @NotNull
    public Term makeSuc(@NotNull CtorDef suc, @NotNull Arg<Term> term) {
        return new RuleReducer.Con(new IntegerOps.ConRule(suc.ref, this.recognition, this.type), 0, (ImmutableSeq<Arg<Term>>)ImmutableSeq.empty(), (ImmutableSeq<Arg<Term>>)ImmutableSeq.of(term));
    }

    @Override
    @NotNull
    public Term destruct(int repr) {
        return new IntegerTerm(repr, this.recognition, this.type);
    }

    @NotNull
    public IntegerTerm map(@NotNull IntUnaryOperator f) {
        return new IntegerTerm(f.applyAsInt(this.repr), this.recognition, this.type);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{IntegerTerm.class, "repr;recognition;type", "repr", "recognition", "type"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{IntegerTerm.class, "repr;recognition;type", "repr", "recognition", "type"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{IntegerTerm.class, "repr;recognition;type", "repr", "recognition", "type"}, this, o);
    }

    @Override
    public int repr() {
        return this.repr;
    }

    @Override
    @NotNull
    public ShapeRecognition recognition() {
        return this.recognition;
    }

    @Override
    @NotNull
    public DataCall type() {
        return this.type;
    }
}

