/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.term;

import java.util.function.UnaryOperator;
import kala.collection.immutable.ImmutableSeq;
import kala.control.Option;
import kala.tuple.Tuple2;
import org.aya.core.def.GenericDef;
import org.aya.core.pat.Pat;
import org.aya.core.repr.AyaShape;
import org.aya.core.repr.ShapeRecognition;
import org.aya.core.term.DataCall;
import org.aya.core.term.IntegerTerm;
import org.aya.core.term.ListTerm;
import org.aya.core.term.Term;
import org.aya.util.error.SourcePos;
import org.jetbrains.annotations.NotNull;

public record MetaLitTerm(@NotNull SourcePos sourcePos, @NotNull Object repr, @NotNull ImmutableSeq<Tuple2<GenericDef, ShapeRecognition>> candidates, @NotNull Term type) implements Term
{
    @NotNull
    public MetaLitTerm update(@NotNull Term type) {
        return type == this.type() ? this : new MetaLitTerm(this.sourcePos, this.repr, this.candidates, type);
    }

    @Override
    @NotNull
    public MetaLitTerm descent(@NotNull UnaryOperator<Term> f, @NotNull UnaryOperator<Pat> g) {
        return this.update((Term)f.apply(this.type));
    }

    @NotNull
    public Term inline() {
        Term term = this.type;
        if (!(term instanceof DataCall)) {
            return this;
        }
        DataCall dataCall = (DataCall)term;
        return (Term)this.candidates.find(t -> ((GenericDef)t.component1()).ref() == dataCall.ref()).flatMap(t -> {
            AyaShape shape = ((ShapeRecognition)t.component2()).shape();
            if (shape == AyaShape.NAT_SHAPE) {
                return Option.some((Object)new IntegerTerm((Integer)this.repr, (ShapeRecognition)t.component2(), dataCall));
            }
            if (shape == AyaShape.LIST_SHAPE) {
                return Option.some((Object)new ListTerm((ImmutableSeq<Term>)((ImmutableSeq)this.repr), (ShapeRecognition)t.component2(), dataCall));
            }
            return Option.none();
        }).getOrDefault((Object)this);
    }
}

