/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.term;

import java.util.function.UnaryOperator;
import org.aya.core.pat.Pat;
import org.aya.core.term.Formation;
import org.aya.core.term.StableWHNF;
import org.aya.core.term.Term;
import org.aya.generic.SortKind;
import org.jetbrains.annotations.NotNull;

public record SortTerm(@NotNull SortKind kind, int lift) implements StableWHNF,
Formation
{
    @NotNull
    public static final SortTerm Type0 = new SortTerm(SortKind.Type, 0);
    @NotNull
    public static final SortTerm Set0 = new SortTerm(SortKind.Set, 0);
    @NotNull
    public static final SortTerm Set1 = new SortTerm(SortKind.Set, 1);
    @NotNull
    public static final SortTerm ISet = new SortTerm(SortKind.ISet, 0);

    public SortTerm(@NotNull SortKind kind, int lift) {
        this.kind = kind;
        if (!kind.hasLevel() && lift != 0) {
            throw new IllegalArgumentException("invalid lift");
        }
        this.lift = lift;
    }

    @Override
    @NotNull
    public SortTerm descent(@NotNull UnaryOperator<Term> f, @NotNull UnaryOperator<Pat> g) {
        return this;
    }

    @NotNull
    public SortTerm succ() {
        return switch (this.kind) {
            default -> throw new RuntimeException(null, null);
            case SortKind.Type, SortKind.Set -> new SortTerm(this.kind, this.lift + 1);
            case SortKind.ISet -> Set1;
        };
    }

    @NotNull
    public SortTerm elevate(int lift) {
        if (this.kind.hasLevel()) {
            return new SortTerm(this.kind, this.lift + lift);
        }
        return this;
    }
}

