/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.term;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import kala.collection.Map;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import kala.collection.mutable.MutableMap;
import kala.tuple.Tuple3;
import org.aya.core.UntypedParam;
import org.aya.core.pat.Pat;
import org.aya.core.term.MetaTerm;
import org.aya.core.visitor.EndoTerm;
import org.aya.core.visitor.Expander;
import org.aya.core.visitor.Subst;
import org.aya.core.visitor.TermFolder;
import org.aya.core.visitor.VarConsumer;
import org.aya.generic.AyaDocile;
import org.aya.generic.ParamLike;
import org.aya.generic.util.NormalizeMode;
import org.aya.guest0x0.cubical.Restr;
import org.aya.prettier.BasePrettier;
import org.aya.prettier.CorePrettier;
import org.aya.pretty.doc.Doc;
import org.aya.ref.AnyVar;
import org.aya.ref.LocalVar;
import org.aya.tyck.env.LocalCtx;
import org.aya.tyck.tycker.TyckState;
import org.aya.tyck.unify.Synthesizer;
import org.aya.util.Arg;
import org.aya.util.error.SourcePos;
import org.aya.util.prettier.PrettierOptions;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Term
extends AyaDocile,
Restr.TermLike<Term> {
    @NotNull
    public Term descent(@NotNull UnaryOperator<Term> var1, @NotNull UnaryOperator<Pat> var2);

    @NotNull
    default public Term subst(@NotNull AnyVar var, @NotNull Term term) {
        return this.subst(new Subst(var, term));
    }

    @NotNull
    default public Term subst(@NotNull Subst subst) {
        return new EndoTerm.Substituter(subst).apply(this);
    }

    @NotNull
    default public Term subst(@NotNull Map<? extends AnyVar, ? extends Term> subst) {
        return this.subst(new Subst((MutableMap<AnyVar, Term>)MutableMap.from(subst)));
    }

    @NotNull
    default public Term subst(@NotNull Subst subst, int ulift) {
        return this.subst(subst).lift(ulift);
    }

    @NotNull
    default public Term rename() {
        return new EndoTerm.Renamer().apply(this);
    }

    default public int findUsages(@NotNull AnyVar var) {
        return (Integer)new TermFolder.Usages(var).apply(this);
    }

    default public VarConsumer.ScopeChecker scopeCheck(@NotNull ImmutableSeq<LocalVar> allowed) {
        VarConsumer.ScopeChecker checker = new VarConsumer.ScopeChecker(allowed);
        checker.accept(this);
        if (!2.$assertionsDisabled && !checker.isCleared()) {
            throw new AssertionError((Object)"The scope checker is not properly cleared up");
        }
        return checker;
    }

    @NotNull
    default public Term normalize(@NotNull TyckState state, @NotNull NormalizeMode mode) {
        return switch (mode) {
            default -> throw new RuntimeException(null, null);
            case NormalizeMode.NULL -> this;
            case NormalizeMode.NF -> new Expander.Normalizer(state).apply(this);
            case NormalizeMode.WHNF -> new Expander.WHNFer(state).apply(this);
        };
    }

    @NotNull
    default public Term freezeHoles(final @Nullable TyckState state) {
        return new EndoTerm(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            @NotNull
            public Term pre(@NotNull Term term) {
                Term term2;
                if (term instanceof MetaTerm) {
                    MetaTerm hole = (MetaTerm)term;
                    if (state != null) {
                        term2 = (Term)state.metas().getOption((Object)hole.ref()).map(this::pre).getOrDefault((Object)term);
                        return term2;
                    }
                }
                term2 = term;
                return term2;
            }
        }.apply(this);
    }

    @Override
    @NotNull
    default public Doc toDoc(@NotNull PrettierOptions options) {
        return new CorePrettier(options).term(BasePrettier.Outer.Free, this);
    }

    @NotNull
    default public Term lift(int ulift) {
        return new EndoTerm.Elevator(ulift).apply(this);
    }

    @NotNull
    default public Term computeType(@NotNull TyckState state, @NotNull LocalCtx ctx) {
        return new Synthesizer(state, ctx).press(this);
    }

    static {
        if (2.$assertionsDisabled) {
            // empty if block
        }
    }

    public record Matching(@NotNull SourcePos sourcePos, @NotNull ImmutableSeq<Arg<Pat>> patterns, @NotNull Term body) implements AyaDocile
    {
        @Override
        @NotNull
        public Doc toDoc(@NotNull PrettierOptions options) {
            return Pat.Preclause.weaken(this).toDoc(options);
        }

        @NotNull
        public Matching update(@NotNull ImmutableSeq<Arg<Pat>> patterns, @NotNull Term body) {
            return body == this.body() && patterns.sameElements(this.patterns(), true) ? this : new Matching(this.sourcePos, patterns, body);
        }

        @NotNull
        public Matching descent(@NotNull UnaryOperator<Term> f, @NotNull UnaryOperator<Pat> g) {
            return this.update((ImmutableSeq<Arg<Pat>>)this.patterns.map(p -> p.descent(g)), (Term)f.apply(this.body));
        }

        public void descentConsume(@NotNull Consumer<Term> f, @NotNull Consumer<Pat> g) {
            this.patterns.forEach(a -> a.descentConsume(g));
            f.accept(this.body);
        }
    }

    public static final class Param
    extends Record
    implements ParamLike<Term>,
    UntypedParam {
        @NotNull
        private final LocalVar ref;
        @NotNull
        private final Term type;
        private final boolean explicit;

        public Param(@NotNull ParamLike<?> param, @NotNull Term type) {
            this(param.ref(), type, param.explicit());
        }

        public Param(@NotNull LocalVar ref, @NotNull Term type, boolean explicit) {
            this.ref = ref;
            this.type = type;
            this.explicit = explicit;
        }

        @NotNull
        public static @NotNull ImmutableSeq<@NotNull Param> fromBuffer(@NotNull MutableList<Tuple3<LocalVar, Boolean, Term>> buf) {
            return buf.view().map(tup -> new Param((LocalVar)tup.component1(), (Term)tup.component3(), (Boolean)tup.component2())).toImmutableSeq();
        }

        @NotNull
        public Param descent(@NotNull @NotNull UnaryOperator<@NotNull Term> f) {
            Term type = (Term)f.apply(this.type());
            if (type == this.type()) {
                return this;
            }
            return new Param(this, type);
        }

        public void descentConsume(@NotNull @NotNull Consumer<@NotNull Term> f) {
            f.accept(this.type);
        }

        @Contract(value=" -> new")
        @NotNull
        public Param implicitify() {
            return new Param(this.ref, this.type, false);
        }

        @Contract(value=" -> new")
        @NotNull
        public Param rename() {
            return new Param(this.renameVar(), this.type, this.explicit);
        }

        @NotNull
        public Arg<Pat> toPat() {
            return new Arg((Object)new Pat.Bind(this.ref, this.type), this.explicit);
        }

        @NotNull
        public Param subst(@NotNull AnyVar var, @NotNull Term term) {
            return this.subst(new Subst(var, term));
        }

        @NotNull
        public Param subst(@NotNull Subst subst) {
            return this.subst(subst, 0);
        }

        @NotNull
        public static ImmutableSeq<Param> subst(@NotNull @NotNull ImmutableSeq<@NotNull Param> params, @NotNull Subst subst, int ulift) {
            return params.map(param -> param.subst(subst, ulift));
        }

        @NotNull
        public static ImmutableSeq<Param> subst(@NotNull @NotNull ImmutableSeq<@NotNull Param> params, int ulift) {
            return Param.subst(params, Subst.EMPTY, ulift);
        }

        @NotNull
        public Param subst(@NotNull Subst subst, int ulift) {
            return new Param(this.ref, this.type.subst(subst, ulift), this.explicit);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Param.class, "ref;type;explicit", "ref", "type", "explicit"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Param.class, "ref;type;explicit", "ref", "type", "explicit"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Param.class, "ref;type;explicit", "ref", "type", "explicit"}, this, o);
        }

        @Override
        @NotNull
        public LocalVar ref() {
            return this.ref;
        }

        @Override
        @NotNull
        public Term type() {
            return this.type;
        }

        @Override
        public boolean explicit() {
            return this.explicit;
        }
    }
}

