/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.visitor;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.UnaryOperator;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.value.MutableValue;
import org.aya.concrete.stmt.decl.TeleDecl;
import org.aya.core.def.DataDef;
import org.aya.core.def.FnDef;
import org.aya.core.def.PrimDef;
import org.aya.core.pat.Pat;
import org.aya.core.term.ClassCall;
import org.aya.core.term.ConCall;
import org.aya.core.term.ConCallLike;
import org.aya.core.term.DataCall;
import org.aya.core.term.FnCall;
import org.aya.core.term.LamTerm;
import org.aya.core.term.PLamTerm;
import org.aya.core.term.PathTerm;
import org.aya.core.term.PiTerm;
import org.aya.core.term.PrimCall;
import org.aya.core.term.RefTerm;
import org.aya.core.term.RuleReducer;
import org.aya.core.term.SigmaTerm;
import org.aya.core.term.SortTerm;
import org.aya.core.term.Term;
import org.aya.core.visitor.BetaExpander;
import org.aya.core.visitor.Subst;
import org.aya.ref.AnyVar;
import org.aya.ref.DefVar;
import org.aya.ref.LocalVar;
import org.aya.util.error.InternalException;
import org.aya.util.error.SourcePos;
import org.jetbrains.annotations.NotNull;

public interface EndoTerm
extends UnaryOperator<Term> {
    @NotNull
    default public Term pre(@NotNull Term term) {
        return term;
    }

    @NotNull
    default public Term post(@NotNull Term term) {
        return term;
    }

    @NotNull
    default public Pat pre(@NotNull Pat pat) {
        return pat;
    }

    @NotNull
    default public Pat post(@NotNull Pat pat) {
        return pat;
    }

    @Override
    @NotNull
    default public Term apply(@NotNull Term term) {
        return this.post(this.pre(term).descent(this, this::apply));
    }

    @Override
    @NotNull
    default public Pat apply(@NotNull Pat pat) {
        return this.post(this.pre(pat).descent(this::apply, this));
    }

    public record MetaBind(@NotNull Subst subst, @NotNull SourcePos definition) implements NoMeta
    {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        @NotNull
        public Pat post(@NotNull Pat pat) {
            LocalVar bind2;
            Object object;
            if (!(pat instanceof Pat.Bind)) return NoMeta.super.post(pat);
            Pat.Bind bind = (Pat.Bind)pat;
            try {
                object = bind.bind();
                bind2 = object;
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable.toString(), throwable);
            }
            Object type = object = bind.type();
            LocalVar newVar = new LocalVar(bind2.name(), this.definition);
            Pat.Meta meta = new Pat.Meta((MutableValue<Pat>)MutableValue.create(), newVar, (Term)type);
            this.subst.addDirectly(bind2, meta.toTerm());
            return meta;
        }
    }

    public static interface NoMeta
    extends EndoTerm {
        @Override
        @NotNull
        default public Pat pre(@NotNull Pat pat) {
            Pat pat2 = EndoTerm.super.pre(pat);
            Objects.requireNonNull(pat2);
            Pat pat3 = pat2;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Pat.Meta.class, Pat.class}, (Object)pat3, n)) {
                case 0: {
                    Pat.Meta meta = (Pat.Meta)pat3;
                    throw new InternalException("expected: no Pat.Meta, but actual: Pat.Meta");
                }
            }
            Pat p = pat3;
            return p;
        }
    }

    public record Elevator(int lift) implements EndoTerm
    {
        @Override
        @NotNull
        public Term apply(@NotNull Term term) {
            if (this.lift == 0) {
                return term;
            }
            return EndoTerm.super.apply(term);
        }

        @Override
        @NotNull
        public Term post(@NotNull Term term) {
            Term term2 = term;
            Objects.requireNonNull(term2);
            Term term3 = term2;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SortTerm.class, ClassCall.class, DataCall.class, ConCall.class, FnCall.class, RuleReducer.Con.class, RuleReducer.Fn.class, PrimCall.class, Term.class}, (Object)term3, n)) {
                case 0 -> {
                    SortTerm sort = (SortTerm)term3;
                    yield sort.elevate(this.lift);
                }
                case 1 -> {
                    ClassCall struct = (ClassCall)term3;
                    yield new ClassCall(struct.ref(), struct.ulift() + this.lift, struct.args());
                }
                case 2 -> {
                    DataCall data = (DataCall)term3;
                    yield new DataCall((DefVar<DataDef, TeleDecl.DataDecl>)data.ref(), data.ulift() + this.lift, data.args());
                }
                case 3 -> {
                    ConCall con = (ConCall)term3;
                    ConCallLike.Head head = con.head();
                    head = new ConCallLike.Head(head.dataRef(), head.ref(), head.ulift() + this.lift, head.dataArgs());
                    yield new ConCall(head, con.conArgs());
                }
                case 4 -> {
                    FnCall fn = (FnCall)term3;
                    yield new FnCall((DefVar<FnDef, TeleDecl.FnDecl>)fn.ref(), fn.ulift() + this.lift, fn.args());
                }
                case 5 -> {
                    RuleReducer.Con con = (RuleReducer.Con)term3;
                    yield new RuleReducer.Con(con.rule(), con.ulift() + this.lift, con.dataArgs(), con.conArgs());
                }
                case 6 -> {
                    RuleReducer.Fn fn = (RuleReducer.Fn)term3;
                    yield new RuleReducer.Fn(fn.rule(), fn.ulift() + this.lift, fn.args());
                }
                case 7 -> {
                    PrimCall prim = (PrimCall)term3;
                    yield new PrimCall((DefVar<PrimDef, TeleDecl.PrimDecl>)prim.ref(), prim.ulift() + this.lift, prim.args());
                }
                default -> {
                    Term misc;
                    yield misc = term3;
                }
            };
        }
    }

    public record Substituter(@NotNull Subst subst) implements BetaExpander
    {
        @Override
        @NotNull
        public Term post(@NotNull Term term) {
            Term term2;
            Term term3 = term;
            Objects.requireNonNull(term3);
            Term term4 = term3;
            int n = 0;
            block5: while (true) {
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RefTerm.class, RefTerm.class, RefTerm.Field.class, Term.class}, (Object)term4, n)) {
                    case 0: {
                        RefTerm ref = (RefTerm)term4;
                        if (ref.var() != LocalVar.IGNORED) {
                            n = 1;
                            continue block5;
                        }
                        throw new InternalException("found usage of ignored var");
                    }
                    case 1: {
                        RefTerm ref = (RefTerm)term4;
                        term2 = this.replacement(ref, ref.var());
                        break block5;
                    }
                    case 2: {
                        RefTerm.Field field = (RefTerm.Field)term4;
                        term2 = this.replacement(field, field.ref());
                        break block5;
                    }
                    default: {
                        Term misc = term4;
                        term2 = BetaExpander.super.post(misc);
                        break block5;
                    }
                }
                break;
            }
            return term2;
        }

        private Term replacement(Term field, @NotNull AnyVar ref) {
            return (Term)this.subst.map().getOption((Object)ref).map(Term::rename).getOrDefault((Object)field);
        }
    }

    public record Renamer(@NotNull Subst subst) implements EndoTerm
    {
        public Renamer() {
            this(new Subst());
        }

        @NotNull
        public ImmutableSeq<Term.Param> params(@NotNull SeqView<Term.Param> params) {
            return params.map(p -> this.handleBinder(p.descent(this))).toImmutableSeq();
        }

        @NotNull
        private Term.Param handleBinder(@NotNull Term.Param param) {
            LocalVar v = param.renameVar();
            this.subst.add(param.ref(), new RefTerm(v));
            return new Term.Param(v, param.type(), param.explicit());
        }

        @NotNull
        private LocalVar handleBinder(@NotNull LocalVar localVar) {
            LocalVar v = localVar.rename();
            this.subst.addDirectly(localVar, new RefTerm(v));
            return v;
        }

        @Override
        @NotNull
        public Pat pre(@NotNull Pat pat) {
            Pat pat2 = pat;
            Objects.requireNonNull(pat2);
            Pat pat3 = pat2;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Pat.Bind.class, Pat.class}, (Object)pat3, n)) {
                case 0 -> {
                    Pat.Bind bind = (Pat.Bind)pat3;
                    yield new Pat.Bind(this.handleBinder(bind.bind()), bind.type());
                }
                default -> {
                    Pat p;
                    yield p = pat3;
                }
            };
        }

        @Override
        @NotNull
        public Term pre(@NotNull Term term) {
            Term term2 = term;
            Objects.requireNonNull(term2);
            Term term3 = term2;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LamTerm.class, PiTerm.class, SigmaTerm.class, RefTerm.class, RefTerm.Field.class, PathTerm.class, PLamTerm.class, Term.class}, (Object)term3, n)) {
                case 0 -> {
                    LamTerm lambda = (LamTerm)term3;
                    yield new LamTerm(new LamTerm.Param(this.handleBinder(lambda.param().ref()), lambda.param().explicit()), lambda.body());
                }
                case 1 -> {
                    PiTerm pi = (PiTerm)term3;
                    yield new PiTerm(this.handleBinder(pi.param()), pi.body());
                }
                case 2 -> {
                    SigmaTerm sigma = (SigmaTerm)term3;
                    yield new SigmaTerm((ImmutableSeq<Term.Param>)sigma.params().map(this::handleBinder));
                }
                case 3 -> {
                    RefTerm ref = (RefTerm)term3;
                    yield (Term)this.subst.map().getOrDefault((Object)ref.var(), (Object)ref);
                }
                case 4 -> {
                    RefTerm.Field field = (RefTerm.Field)term3;
                    yield (Term)this.subst.map().getOrDefault(field.ref(), (Object)field);
                }
                case 5 -> {
                    PathTerm path = (PathTerm)term3;
                    yield new PathTerm((ImmutableSeq<LocalVar>)path.params().map(this::handleBinder), path.type(), path.partial());
                }
                case 6 -> {
                    PLamTerm lam = (PLamTerm)term3;
                    yield new PLamTerm((ImmutableSeq<LocalVar>)lam.params().map(this::handleBinder), lam.body());
                }
                default -> {
                    Term misc;
                    yield misc = term3;
                }
            };
        }
    }
}

