/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.visitor;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.Consumer;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import org.aya.core.term.ClassCall;
import org.aya.core.term.ConCall;
import org.aya.core.term.DataCall;
import org.aya.core.term.FnCall;
import org.aya.core.term.LamTerm;
import org.aya.core.term.MetaTerm;
import org.aya.core.term.PLamTerm;
import org.aya.core.term.PathTerm;
import org.aya.core.term.PiTerm;
import org.aya.core.term.PrimCall;
import org.aya.core.term.RefTerm;
import org.aya.core.term.SigmaTerm;
import org.aya.core.term.Term;
import org.aya.core.visitor.TermConsumer;
import org.aya.ref.AnyVar;
import org.aya.ref.LocalVar;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

public interface VarConsumer
extends TermConsumer {
    public void var(@NotNull AnyVar var1);

    @Override
    default public void accept(@NotNull Term term) {
        Term term2 = term;
        Objects.requireNonNull(term2);
        Term term3 = term2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RefTerm.class, RefTerm.Field.class, MetaTerm.class, FnCall.class, PrimCall.class, DataCall.class, ConCall.class, ClassCall.class}, (Object)term3, n)) {
            case 0: {
                RefTerm ref = (RefTerm)term3;
                this.var(ref.var());
                break;
            }
            case 1: {
                RefTerm.Field field = (RefTerm.Field)term3;
                this.var(field.ref());
                break;
            }
            case 2: {
                MetaTerm hole = (MetaTerm)term3;
                this.var(hole.ref());
                break;
            }
            case 3: {
                FnCall fn = (FnCall)term3;
                this.var(fn.ref());
                break;
            }
            case 4: {
                PrimCall prim = (PrimCall)term3;
                this.var(prim.ref());
                break;
            }
            case 5: {
                DataCall data = (DataCall)term3;
                this.var(data.ref());
                break;
            }
            case 6: {
                ConCall con = (ConCall)term3;
                this.var(con.ref());
                break;
            }
            case 7: {
                ClassCall struct = (ClassCall)term3;
                this.var(struct.ref());
                break;
            }
        }
        TermConsumer.super.accept(term);
    }

    public static final class ScopeChecker
    extends Scoped {
        @NotNull
        public final ImmutableSeq<LocalVar> allowed;
        @NotNull
        public final MutableList<LocalVar> invalid;
        @NotNull
        public final MutableList<LocalVar> confused;

        @Contract(pure=true)
        public ScopeChecker(@NotNull ImmutableSeq<LocalVar> allowed) {
            this(allowed, (MutableList<LocalVar>)MutableList.create(), (MutableList<LocalVar>)MutableList.create());
        }

        @Override
        public void accept(@NotNull Term term) {
            if (term instanceof MetaTerm) {
                MetaTerm hole = (MetaTerm)term;
                ScopeChecker checker = new ScopeChecker((ImmutableSeq<LocalVar>)this.allowed.appendedAll((Iterable)this.bound), this.confused, this.confused);
                hole.contextArgs().forEach(arg -> checker.accept((Term)arg.term()));
                hole.args().forEach(arg -> this.accept((Term)arg.term()));
            } else {
                super.accept(term);
            }
        }

        @Contract(pure=true)
        private ScopeChecker(@NotNull ImmutableSeq<LocalVar> allowed, @NotNull MutableList<LocalVar> confused, @NotNull MutableList<LocalVar> invalid) {
            this.allowed = allowed;
            this.confused = confused;
            this.invalid = invalid;
        }

        @Override
        @Contract(mutates="this")
        public void var(@NotNull AnyVar v) {
            LocalVar local;
            if (v instanceof LocalVar && !this.allowed.contains((Object)(local = (LocalVar)v)) && !this.bound.contains((Object)local) && !this.invalid.contains((Object)local)) {
                this.invalid.append((Object)local);
            }
        }
    }

    public static abstract class Scoped
    implements VarConsumer {
        @NotNull
        protected final MutableList<LocalVar> bound = MutableList.create();

        @TestOnly
        @VisibleForTesting
        public boolean isCleared() {
            return this.bound.isEmpty();
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void accept(@NotNull Term term) {
            Term term2 = term;
            Objects.requireNonNull(term2);
            Term term3 = term2;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LamTerm.class, PiTerm.class, SigmaTerm.class, PathTerm.class, PLamTerm.class}, (Object)term3, n)) {
                case 0: {
                    LamTerm lambda = (LamTerm)term3;
                    this.bound.append((Object)lambda.param().ref());
                    VarConsumer.super.accept(lambda);
                    this.bound.removeLast();
                    return;
                }
                case 1: {
                    PiTerm pi = (PiTerm)term3;
                    this.bound.append((Object)pi.param().ref());
                    VarConsumer.super.accept(pi);
                    this.bound.removeLast();
                    return;
                }
                case 2: {
                    ImmutableSeq<Term.Param> params;
                    SigmaTerm sigmaTerm = (SigmaTerm)term3;
                    try {
                        ImmutableSeq<Term.Param> immutableSeq;
                        params = immutableSeq = sigmaTerm.params();
                    }
                    catch (Throwable throwable) {
                        throw new RuntimeException(throwable.toString(), throwable);
                    }
                    int start = this.bound.size();
                    params.forEach(param -> {
                        this.bound.append((Object)param.ref());
                        this.accept(param.type());
                    });
                    this.bound.removeInRange(start, start + params.size());
                    return;
                }
                case 3: {
                    PathTerm cube = (PathTerm)term3;
                    int start = this.bound.size();
                    cube.params().forEach(arg_0 -> this.bound.append(arg_0));
                    this.accept(cube.type());
                    cube.partial().termsView().forEach((Consumer)this);
                    this.bound.removeInRange(start, start + cube.params().size());
                    return;
                }
                case 4: {
                    Object body;
                    ImmutableSeq<LocalVar> params;
                    PLamTerm pLamTerm = (PLamTerm)term3;
                    {
                        Object object;
                        params = object = pLamTerm.params();
                        body = object = pLamTerm.body();
                    }
                    int start = this.bound.size();
                    params.forEach(arg_0 -> this.bound.append(arg_0));
                    this.accept((Term)body);
                    this.bound.removeInRange(start, start + params.size());
                    return;
                }
            }
            VarConsumer.super.accept(term);
        }
    }
}

