/*
 * Decompiled with CFR 0.152.
 */
package org.aya.generic.util;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import org.aya.generic.Constants;
import org.aya.util.FileUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface AyaFiles {
    @NotNull
    public static final ImmutableSeq<String> AYA_SOURCE_POSTFIXES = ImmutableSeq.of((Object)".aya", (Object)".aya.md");

    @NotNull
    public static String stripAyaSourcePostfix(@NotNull String name) {
        return Constants.AYA_POSTFIX_PATTERN.matcher(name).replaceAll("");
    }

    public static boolean isLiterate(@NotNull Path path) {
        return path.getFileName().toString().endsWith(".aya.md");
    }

    @NotNull
    public static Path resolveAyaSourceFile(@NotNull Path basePath, @NotNull ImmutableSeq<String> moduleName) {
        Path literate = FileUtil.resolveFile((Path)basePath, moduleName, (String)".aya.md");
        if (Files.exists(literate, new LinkOption[0])) {
            return literate;
        }
        return FileUtil.resolveFile((Path)basePath, moduleName, (String)".aya");
    }

    @Nullable
    public static Path resolveAyaSourceFile(@NotNull SeqView<Path> basePaths, @NotNull ImmutableSeq<String> moduleName) {
        Path literate = FileUtil.resolveFile(basePaths, moduleName, (String)".aya.md");
        if (literate != null) {
            return literate;
        }
        return FileUtil.resolveFile(basePaths, moduleName, (String)".aya");
    }

    @NotNull
    public static Path resolveAyaCompiledFile(@NotNull Path basePath, @NotNull ImmutableSeq<String> moduleName) {
        return FileUtil.resolveFile((Path)basePath, moduleName, (String)".ayac");
    }

    @Nullable
    public static Path resolveAyaCompiledFile(@NotNull SeqView<Path> basePaths, @NotNull ImmutableSeq<String> moduleName) {
        return FileUtil.resolveFile(basePaths, moduleName, (String)".ayac");
    }

    @NotNull
    public static ImmutableSeq<Path> collectAyaSourceFiles(@NotNull Path basePath) {
        return AyaFiles.collectAyaSourceFiles(basePath, Integer.MAX_VALUE);
    }

    @NotNull
    public static ImmutableSeq<Path> collectAyaSourceFiles(@NotNull Path basePath, int maxDepth) {
        return FileUtil.collectSource((Path)basePath, AYA_SOURCE_POSTFIXES, (int)maxDepth);
    }
}

