/*
 * Decompiled with CFR 0.152.
 */
package org.aya.resolve.visitor;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableLinkedHashMap;
import kala.collection.mutable.MutableList;
import kala.collection.mutable.MutableMap;
import kala.collection.mutable.MutableStack;
import kala.control.Either;
import kala.control.Option;
import kala.value.MutableValue;
import org.aya.concrete.Expr;
import org.aya.concrete.Pattern;
import org.aya.concrete.stmt.Generalize;
import org.aya.concrete.stmt.GeneralizedVar;
import org.aya.concrete.stmt.QualifiedID;
import org.aya.concrete.stmt.Stmt;
import org.aya.concrete.stmt.decl.TeleDecl;
import org.aya.concrete.visitor.EndoExpr;
import org.aya.concrete.visitor.EndoPattern;
import org.aya.core.def.CtorDef;
import org.aya.core.def.PrimDef;
import org.aya.ref.AnyVar;
import org.aya.ref.DefVar;
import org.aya.ref.LocalVar;
import org.aya.resolve.context.Context;
import org.aya.resolve.context.ModuleName;
import org.aya.resolve.context.NoExportContext;
import org.aya.resolve.error.GeneralizedNotAvailableError;
import org.aya.tyck.Result;
import org.aya.tyck.error.FieldError;
import org.aya.tyck.order.TyckOrder;
import org.aya.tyck.order.TyckUnit;
import org.aya.util.Arg;
import org.aya.util.error.InternalException;
import org.aya.util.error.SourcePos;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record ExprResolver(@NotNull Context ctx, @NotNull Options options, @NotNull MutableMap<GeneralizedVar, Expr.Param> allowedGeneralizes, @NotNull MutableList<TyckOrder> reference, @NotNull MutableStack<Where> where, @Nullable Consumer<TyckUnit> parentAdd) implements EndoExpr
{
    @NotNull
    public static final Options RESTRICTIVE = new Options(false);
    @NotNull
    public static final Options LAX = new Options(true);

    public ExprResolver(@NotNull Context ctx, @NotNull Options options) {
        this(ctx, options, (MutableMap<GeneralizedVar, Expr.Param>)MutableLinkedHashMap.of(), (MutableList<TyckOrder>)MutableList.create(), (MutableStack<Where>)MutableStack.create(), null);
    }

    @NotNull
    Expr.PartEl partial(@NotNull Context ctx, Expr.PartEl el) {
        return el.descent((UnaryOperator)this.enter(ctx));
    }

    public void enterHead() {
        this.where.push((Object)Where.Head);
        this.reference.clear();
    }

    public void enterBody() {
        this.where.push((Object)Where.Body);
        this.reference.clear();
    }

    @NotNull
    public ExprResolver enter(Context ctx) {
        return ctx == this.ctx() ? this : new ExprResolver(ctx, this.options, this.allowedGeneralizes, this.reference, this.where, this.parentAdd);
    }

    @NotNull
    public ExprResolver member(@NotNull TyckUnit decl, Where initial) {
        ExprResolver resolver = new ExprResolver(this.ctx, RESTRICTIVE, this.allowedGeneralizes, (MutableList<TyckOrder>)MutableList.of((Object)new TyckOrder.Head(decl)), (MutableStack<Where>)MutableStack.create(), this::addReference);
        resolver.where.push((Object)initial);
        return resolver;
    }

    @Contract(mutates="this")
    @NotNull
    public ExprResolver enterClauses() {
        this.enterBody();
        ExprResolver resolver = new ExprResolver(this.ctx, RESTRICTIVE, (MutableMap<GeneralizedVar, Expr.Param>)MutableMap.from(this.allowedGeneralizes), (MutableList<TyckOrder>)MutableList.create(), (MutableStack<Where>)MutableStack.create(), this::addReference);
        resolver.where.push((Object)Where.Body);
        return resolver;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public Expr pre(@NotNull Expr expr) {
        Expr expr2;
        Expr expr3 = expr;
        Objects.requireNonNull(expr3);
        Expr expr32 = expr3;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Expr.Proj.class, Expr.Hole.class}, (Object)expr32, n)) {
            case 0: {
                Object theCore;
                Object resolved;
                Either<Integer, QualifiedID> ix;
                Object tup;
                SourcePos pos;
                Expr.Proj proj = (Expr.Proj)expr32;
                try {
                    Object object = proj.sourcePos();
                    pos = object;
                    object = proj.tup();
                    tup = object;
                    ix = object = proj.ix();
                    resolved = object = proj.resolvedVar();
                    theCore = object = proj.theCore();
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable.toString(), throwable);
                }
                if (ix.isLeft()) {
                    expr2 = new Expr.Proj(pos, (Expr)tup, ix, (AnyVar)resolved, (MutableValue<Result>)theCore);
                    return expr2;
                }
                QualifiedID projName = (QualifiedID)ix.getRightValue();
                AnyVar resolvedIx = this.ctx.getMaybe(projName);
                if (resolvedIx == null) {
                    this.ctx.reportAndThrow(new FieldError.UnknownField(projName.sourcePos(), projName.join()));
                }
                expr2 = new Expr.Proj(pos, (Expr)tup, ix, resolvedIx, (MutableValue<Result>)theCore);
                return expr2;
            }
            case 1: {
                Expr.Hole hole = (Expr.Hole)expr32;
                hole.accessibleLocal().set((Object)this.ctx.collect((MutableList<LocalVar>)MutableList.create()).toImmutableSeq());
                expr2 = hole;
                return expr2;
            }
        }
        expr2 = EndoExpr.super.pre(expr);
        return expr2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public Expr apply(@NotNull Expr expr) {
        Expr expr2;
        Expr expr3 = expr;
        Objects.requireNonNull(expr3);
        Expr expr32 = expr3;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Expr.Do.class, Expr.Match.class, Expr.New.class, Expr.Lambda.class, Expr.Pi.class, Expr.Sigma.class, Expr.Path.class, Expr.Array.class, Expr.Unresolved.class, Expr.Let.class, Expr.LetOpen.class}, (Object)expr32, n)) {
            case 0: {
                Expr.Do doExpr = (Expr.Do)expr32;
                expr2 = doExpr.update(this.apply(doExpr.bindName()), this.bind(doExpr.binds(), (MutableValue<Context>)MutableValue.create((Object)this.ctx)));
                return expr2;
            }
            case 1: {
                Expr.Match match = (Expr.Match)expr32;
                ImmutableSeq clauses = match.clauses().map(this::apply);
                expr2 = match.update((ImmutableSeq<Expr>)match.discriminant().map((Function)this), (ImmutableSeq<Pattern.Clause>)clauses);
                return expr2;
            }
            case 2: {
                Expr.New neu = (Expr.New)expr32;
                expr2 = neu.update(this.apply(neu.struct()), (ImmutableSeq<Expr.Field<Expr>>)neu.fields().map(field -> {
                    Context fieldCtx = (Context)field.bindings().foldLeft((Object)this.ctx, (c, x) -> c.bind((LocalVar)x.data()));
                    return field.descent(this.enter(fieldCtx));
                }));
                return expr2;
            }
            case 3: {
                Expr.Lambda lam = (Expr.Lambda)expr32;
                MutableValue mCtx = MutableValue.create((Object)this.ctx);
                Expr.Param param2 = this.bind(lam.param(), (MutableValue<Context>)mCtx);
                expr2 = lam.update(param2, this.enter((Context)mCtx.get()).apply(lam.body()));
                return expr2;
            }
            case 4: {
                Expr.Pi pi = (Expr.Pi)expr32;
                MutableValue mCtx = MutableValue.create((Object)this.ctx);
                Expr.Param param3 = this.bind(pi.param(), (MutableValue<Context>)mCtx);
                expr2 = pi.update(param3, this.enter((Context)mCtx.get()).apply(pi.last()));
                return expr2;
            }
            case 5: {
                Expr.Sigma sigma = (Expr.Sigma)expr32;
                MutableValue mCtx = MutableValue.create((Object)this.ctx);
                ImmutableSeq params = sigma.params().map(param -> this.bind((Expr.Param)param, (MutableValue<Context>)mCtx));
                expr2 = sigma.update((ImmutableSeq<Expr.Param>)params);
                return expr2;
            }
            case 6: {
                Expr.Path path = (Expr.Path)expr32;
                Context newCtx = (Context)path.params().foldLeft((Object)this.ctx, Context::bind);
                expr2 = path.descent((UnaryOperator)this.enter(newCtx));
                return expr2;
            }
            case 7: {
                Expr.Array array = (Expr.Array)expr32;
                expr2 = array.update((Either<Expr.Array.CompBlock, Expr.Array.ElementList>)array.arrayBlock().map(left -> {
                    MutableValue mCtx = MutableValue.create((Object)this.ctx);
                    ImmutableSeq<Expr.DoBind> binds = this.bind(left.binds(), (MutableValue<Context>)mCtx);
                    Expr generator = this.enter((Context)mCtx.get()).apply(left.generator());
                    return left.update(generator, binds, left.names().fmap(this));
                }, right -> right.descent(this)));
                return expr2;
            }
            case 8: {
                AnyVar anyVar;
                SourcePos pos;
                Object object;
                Expr.Unresolved unresolved = (Expr.Unresolved)expr32;
                try {
                    pos = object = unresolved.sourcePos();
                    Object name = object = unresolved.name();
                    anyVar = this.ctx.get((QualifiedID)name);
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable.toString(), throwable);
                }
                Objects.requireNonNull(anyVar);
                object = anyVar;
                int n2 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GeneralizedVar.class, DefVar.class, AnyVar.class}, (Object)object, n2)) {
                    case 0: {
                        GeneralizedVar generalized = (GeneralizedVar)object;
                        if (!this.allowedGeneralizes.containsKey((Object)generalized)) {
                            if (this.options.allowIntroduceGeneralized) {
                                Generalize owner = generalized.owner;
                                assert (owner != null) : "Sanity check";
                                this.allowedGeneralizes.put((Object)generalized, (Object)owner.toExpr(false, generalized.toLocal()));
                                this.addReference(owner);
                            } else {
                                this.ctx.reportAndThrow(new GeneralizedNotAvailableError(pos, generalized));
                            }
                        }
                        expr2 = new Expr.Ref(pos, ((Expr.Param)this.allowedGeneralizes.get((Object)generalized)).ref());
                        return expr2;
                    }
                    case 1: {
                        DefVar def = (DefVar)object;
                        assert (def.concrete != null || def.core != null);
                        this.addReference(def);
                        expr2 = new Expr.Ref(pos, def);
                        return expr2;
                    }
                }
                Object var = object;
                expr2 = new Expr.Ref(pos, (AnyVar)var);
                return expr2;
            }
            case 9: {
                Expr.Let let = (Expr.Let)expr32;
                Expr.LetBind letBind = let.bind();
                MutableValue mCtx = MutableValue.create((Object)this.ctx);
                ImmutableSeq telescope = letBind.telescope().map(param -> this.bind((Expr.Param)param, (MutableValue<Context>)mCtx));
                ExprResolver resolver = this.enter((Context)mCtx.get());
                Expr result = resolver.apply(letBind.result());
                Expr definedAs = resolver.apply(letBind.definedAs());
                Expr newBody = this.enter(this.ctx.bind(letBind.bindName())).apply(let.body());
                expr2 = let.update(letBind.update((ImmutableSeq<Expr.Param>)telescope, result, definedAs), newBody);
                return expr2;
            }
            case 10: {
                Expr.LetOpen letOpen = (Expr.LetOpen)expr32;
                NoExportContext innerCtx = new NoExportContext(this.ctx);
                innerCtx.openModule(letOpen.componentName(), Stmt.Accessibility.Private, letOpen.sourcePos(), letOpen.useHide());
                expr2 = letOpen.update(this.enter(innerCtx).apply(letOpen.body()));
                return expr2;
            }
        }
        expr2 = EndoExpr.super.apply(expr);
        return expr2;
    }

    private void addReference(@NotNull TyckUnit unit) {
        if (this.parentAdd != null) {
            this.parentAdd.accept(unit);
        }
        if (this.where.isEmpty()) {
            throw new InternalException("where am I?");
        }
        switch ((Where)((Object)this.where.peek())) {
            case Head: {
                this.reference.append((Object)new TyckOrder.Head(unit));
                this.reference.append((Object)new TyckOrder.Body(unit));
                break;
            }
            case Body: {
                this.reference.append((Object)new TyckOrder.Body(unit));
            }
        }
    }

    private void addReference(@NotNull DefVar<?, ?> defVar) {
        Object Concrete = defVar.concrete;
        if (Concrete instanceof TyckUnit) {
            Object unit = Concrete;
            this.addReference((TyckUnit)unit);
        }
    }

    @Override
    @NotNull
    public Pattern.Clause apply(@NotNull Pattern.Clause clause) {
        MutableValue mCtx = MutableValue.create((Object)this.ctx());
        ImmutableSeq pats = clause.patterns.map(pa -> pa.descent(pat -> this.bind((Pattern)pat, (MutableValue<Context>)mCtx)));
        return clause.update((ImmutableSeq<Arg<Pattern>>)pats, (Option<Expr>)clause.expr.map((Function)this.enter((Context)mCtx.get())));
    }

    @NotNull
    public Pattern bind(@NotNull Pattern pattern, final @NotNull MutableValue<Context> ctx) {
        return new EndoPattern(){

            @Override
            @NotNull
            public Pattern post(@NotNull Pattern pattern) {
                Pattern pattern2 = pattern;
                Objects.requireNonNull(pattern2);
                Pattern pattern3 = pattern2;
                int n = 0;
                return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Pattern.Bind.class, Pattern.QualifiedRef.class, Pattern.As.class}, (Object)pattern3, n)) {
                    case 0 -> {
                        Pattern.Bind bind = (Pattern.Bind)pattern3;
                        DefVar maybe = ((Context)ctx.get()).iterate(c -> ExprResolver.patternCon(c.getUnqualifiedLocalMaybe(bind.bind().name(), bind.sourcePos())));
                        if (maybe != null) {
                            ExprResolver.this.addReference(maybe);
                            yield new Pattern.Ctor(bind, (AnyVar)maybe);
                        }
                        ctx.set((Object)((Context)ctx.get()).bind(bind.bind(), var -> false));
                        yield bind;
                    }
                    case 1 -> {
                        Pattern.QualifiedRef qref = (Pattern.QualifiedRef)pattern3;
                        QualifiedID qid = qref.qualifiedID();
                        if (!$assertionsDisabled && !(qid.component() instanceof ModuleName.Qualified)) {
                            throw new AssertionError();
                        }
                        DefVar maybe = ((Context)ctx.get()).iterate(c -> ExprResolver.patternCon(c.getQualifiedLocalMaybe((ModuleName.Qualified)qid.component(), qid.name(), qref.sourcePos())));
                        if (maybe != null) {
                            ExprResolver.this.addReference(maybe);
                            yield new Pattern.Ctor(qref, (AnyVar)maybe);
                        }
                        yield EndoPattern.super.post(pattern);
                    }
                    case 2 -> {
                        Pattern.As as = (Pattern.As)pattern3;
                        ctx.set((Object)ExprResolver.bindAs(as.as(), (Context)ctx.get()));
                        yield as;
                    }
                    default -> EndoPattern.super.post(pattern);
                };
            }
        }.apply(pattern);
    }

    @Nullable
    private static DefVar<?, ?> patternCon(@Nullable AnyVar myMaybe) {
        if (myMaybe == null) {
            return null;
        }
        if (myMaybe instanceof DefVar) {
            DefVar def = (DefVar)myMaybe;
            if (def.core instanceof CtorDef || def.concrete instanceof TeleDecl.DataCtor || def.core instanceof PrimDef || def.concrete instanceof TeleDecl.PrimDecl) {
                return def;
            }
        }
        return null;
    }

    private static Context bindAs(@NotNull LocalVar as, @NotNull Context ctx) {
        return ctx.bind(as);
    }

    @NotNull
    public Expr.Param bind(@NotNull Expr.Param param, @NotNull MutableValue<Context> ctx) {
        Expr.Param p = param.descent(this.enter((Context)ctx.get()));
        ctx.set((Object)((Context)ctx.get()).bind(param.ref()));
        return p;
    }

    @NotNull
    public ImmutableSeq<Expr.DoBind> bind(@NotNull ImmutableSeq<Expr.DoBind> binds, @NotNull MutableValue<Context> ctx) {
        return binds.map(bind -> {
            Expr.DoBind b = bind.descent(this.enter((Context)ctx.get()));
            ctx.set((Object)((Context)ctx.get()).bind(bind.var()));
            return b;
        });
    }

    public record Options(boolean allowIntroduceGeneralized) {
    }

    public static enum Where {
        Head,
        Body;

    }
}

