/*
 * Decompiled with CFR 0.152.
 */
package org.aya.resolve.visitor;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.Function;
import kala.collection.SeqLike;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.value.MutableValue;
import org.aya.concrete.Expr;
import org.aya.concrete.Pattern;
import org.aya.concrete.desugar.AyaBinOpSet;
import org.aya.concrete.error.OperatorError;
import org.aya.concrete.stmt.BindBlock;
import org.aya.concrete.stmt.Command;
import org.aya.concrete.stmt.Generalize;
import org.aya.concrete.stmt.QualifiedID;
import org.aya.concrete.stmt.Stmt;
import org.aya.concrete.stmt.decl.ClassDecl;
import org.aya.concrete.stmt.decl.Decl;
import org.aya.concrete.stmt.decl.TeleDecl;
import org.aya.core.term.Term;
import org.aya.ref.AnyVar;
import org.aya.ref.DefVar;
import org.aya.resolve.ResolveInfo;
import org.aya.resolve.context.Context;
import org.aya.resolve.error.NameProblem;
import org.aya.resolve.visitor.ExprResolver;
import org.aya.tyck.order.TyckOrder;
import org.aya.tyck.order.TyckUnit;
import org.aya.util.binop.OpDecl;
import org.aya.util.reporter.Problem;
import org.aya.util.reporter.Reporter;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface StmtResolver {
    public static void resolveStmt(@NotNull @NotNull SeqLike<@NotNull Stmt> stmt, @NotNull ResolveInfo info) {
        stmt.forEach(s -> StmtResolver.resolveStmt(s, info));
    }

    public static void resolveStmt(@NotNull Stmt stmt, @NotNull ResolveInfo info) {
        Stmt stmt2 = stmt;
        Objects.requireNonNull(stmt2);
        Stmt stmt3 = stmt2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Decl.class, Command.Module.class, Command.class, Generalize.class}, (Object)stmt3, n)) {
            default: {
                throw new RuntimeException(null, null);
            }
            case 0: {
                Decl decl = (Decl)stmt3;
                StmtResolver.resolveDecl(decl, info);
                break;
            }
            case 1: {
                Command.Module mod = (Command.Module)stmt3;
                StmtResolver.resolveStmt(mod.contents(), info);
                break;
            }
            case 2: {
                Command cmd = (Command)stmt3;
                break;
            }
            case 3: {
                Generalize variables = (Generalize)stmt3;
                if (!1.$assertionsDisabled && variables.ctx == null) {
                    throw new AssertionError();
                }
                ExprResolver resolver = new ExprResolver(variables.ctx, ExprResolver.RESTRICTIVE);
                resolver.enterBody();
                variables.type = resolver.apply(variables.type);
                StmtResolver.addReferences(info, (TyckOrder)new TyckOrder.Body(variables), resolver);
            }
        }
    }

    /*
     * Loose catch block
     */
    private static void resolveDecl(@NotNull Decl predecl, @NotNull ResolveInfo info) {
        block16: {
            Decl decl = predecl;
            Objects.requireNonNull(decl);
            Decl decl2 = decl;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TeleDecl.FnDecl.class, TeleDecl.DataDecl.class, ClassDecl.class, TeleDecl.PrimDecl.class, TeleDecl.DataCtor.class, TeleDecl.ClassMember.class}, (Object)decl2, n)) {
                default: {
                    throw new RuntimeException(null, null);
                }
                case 0: {
                    TeleDecl.FnDecl decl3 = (TeleDecl.FnDecl)decl2;
                    ExprResolver resolver = StmtResolver.resolveDeclSignature(decl3, ExprResolver.LAX, info);
                    TeleDecl.FnBody fnBody = decl3.body;
                    Objects.requireNonNull(fnBody);
                    TeleDecl.FnBody fnBody2 = fnBody;
                    int n2 = 0;
                    decl3.body = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TeleDecl.BlockBody.class, TeleDecl.ExprBody.class}, (Object)fnBody2, n2)) {
                        default -> throw new RuntimeException(null, null);
                        case 0 -> {
                            ImmutableSeq<Pattern.Clause> var10_16;
                            TeleDecl.BlockBody var8_14 = (TeleDecl.BlockBody)fnBody2;
                            ImmutableSeq<Pattern.Clause> cls = var10_16 = var8_14.clauses();
                            StmtResolver.insertGeneralizedVars(decl3, resolver);
                            ExprResolver clausesResolver = resolver.enterClauses();
                            TeleDecl.BlockBody body = new TeleDecl.BlockBody((ImmutableSeq<Pattern.Clause>)cls.map(clausesResolver::apply));
                            resolver.reference().appendAll(clausesResolver.reference());
                            yield body;
                        }
                        case 1 -> {
                            Expr var12_22;
                            TeleDecl.ExprBody var10_17 = (TeleDecl.ExprBody)fnBody2;
                            Expr expr = var12_22 = var10_17.expr();
                            resolver.enterBody();
                            Expr body = resolver.apply(expr);
                            StmtResolver.insertGeneralizedVars(decl3, resolver);
                            yield new TeleDecl.ExprBody(body);
                        }
                    };
                    StmtResolver.addReferences(info, (TyckOrder)new TyckOrder.Body(decl3), resolver);
                    break;
                }
                case 1: {
                    TeleDecl.DataDecl decl4 = (TeleDecl.DataDecl)decl2;
                    ExprResolver resolver = StmtResolver.resolveDeclSignature(decl4, ExprResolver.LAX, info);
                    StmtResolver.insertGeneralizedVars(decl4, resolver);
                    resolver.enterBody();
                    decl4.body.forEach(ctor -> {
                        ExprResolver bodyResolver = resolver.member(decl4, ExprResolver.Where.Head);
                        MutableValue mCtx = MutableValue.create((Object)resolver.ctx());
                        ctor.patterns = ctor.patterns.map(pat -> pat.descent(pattern -> bodyResolver.bind((Pattern)pattern, (MutableValue<Context>)mCtx)));
                        StmtResolver.resolveMemberSignature(ctor, bodyResolver, (MutableValue<Context>)mCtx);
                        ctor.clauses = bodyResolver.partial((Context)mCtx.get(), ctor.clauses);
                        TyckOrder.Head head = new TyckOrder.Head((TyckUnit)ctor);
                        StmtResolver.addReferences(info, (TyckOrder)head, bodyResolver);
                        StmtResolver.addReferences(info, (TyckOrder)new TyckOrder.Body((TyckUnit)ctor), (SeqView<TyckOrder>)SeqView.of((Object)head));
                    });
                    StmtResolver.addReferences(info, (TyckOrder)new TyckOrder.Body(decl4), (SeqView<TyckOrder>)resolver.reference().view().concat((SeqLike)decl4.body.map(TyckOrder.Body::new)));
                    break;
                }
                case 2: {
                    ClassDecl decl5 = (ClassDecl)decl2;
                    if (!1.$assertionsDisabled && decl5.ctx == null) {
                        throw new AssertionError();
                    }
                    ExprResolver resolver = new ExprResolver(decl5.ctx, ExprResolver.RESTRICTIVE);
                    resolver.enterHead();
                    decl5.members.forEach(field -> {
                        ExprResolver bodyResolver = resolver.member(decl5, ExprResolver.Where.Head);
                        MutableValue mCtx = MutableValue.create((Object)resolver.ctx());
                        StmtResolver.resolveMemberSignature(field, bodyResolver, (MutableValue<Context>)mCtx);
                        StmtResolver.addReferences(info, (TyckOrder)new TyckOrder.Head((TyckUnit)field), (SeqView<TyckOrder>)bodyResolver.reference().view().appended((Object)new TyckOrder.Head(decl5)));
                        bodyResolver.enterBody();
                        field.body = field.body.map((Function)bodyResolver.enter((Context)mCtx.get()));
                        StmtResolver.addReferences(info, (TyckOrder)new TyckOrder.Body((TyckUnit)field), bodyResolver);
                    });
                    StmtResolver.addReferences(info, (TyckOrder)new TyckOrder.Head(decl5), (SeqView<TyckOrder>)resolver.reference().view().concat((SeqLike)decl5.members.map(TyckOrder.Head::new)));
                    break;
                }
                case 3: {
                    TeleDecl.PrimDecl decl6 = (TeleDecl.PrimDecl)decl2;
                    StmtResolver.resolveDeclSignature(decl6, ExprResolver.RESTRICTIVE, info);
                    StmtResolver.addReferences(info, (TyckOrder)new TyckOrder.Body(decl6), (SeqView<TyckOrder>)SeqView.empty());
                    break;
                }
                case 4: {
                    TeleDecl.DataCtor ctor2 = (TeleDecl.DataCtor)decl2;
                    break;
                }
                case 5: {
                    TeleDecl.ClassMember classMember = (TeleDecl.ClassMember)decl2;
                    break;
                }
            }
            break block16;
            catch (Throwable throwable) {
                throw new RuntimeException(throwable.toString(), throwable);
            }
        }
    }

    private static <T extends TeleDecl<?>> void resolveMemberSignature(T ctor, ExprResolver bodyResolver, MutableValue<@NotNull Context> mCtx) {
        ctor.modifyTelescope(t -> t.map(param -> bodyResolver.bind((Expr.Param)param, mCtx)));
        ctor.modifyResult(t -> bodyResolver.enter((Context)mCtx.get()).apply((Expr)t));
    }

    private static void addReferences(@NotNull ResolveInfo info, TyckOrder decl, SeqView<TyckOrder> refs) {
        info.depGraph().sucMut((Object)decl).appendAll((Iterable)refs.filter(unit -> unit.unit().needTyck(info.thisModule().modulePath().path())));
        if (decl instanceof TyckOrder.Body) {
            info.depGraph().sucMut((Object)decl).append((Object)new TyckOrder.Head(decl.unit()));
        }
    }

    private static void addReferences(@NotNull ResolveInfo info, TyckOrder decl, ExprResolver resolver) {
        StmtResolver.addReferences(info, decl, (SeqView<TyckOrder>)resolver.reference().view());
    }

    @NotNull
    private static ExprResolver resolveDeclSignature(@NotNull TeleDecl.TopLevel<?> decl, @NotNull ExprResolver.Options options, @NotNull ResolveInfo info) {
        if (!1.$assertionsDisabled && decl.ctx == null) {
            throw new AssertionError();
        }
        ExprResolver resolver = new ExprResolver(decl.ctx, options);
        resolver.enterHead();
        MutableValue mCtx = MutableValue.create((Object)decl.ctx);
        ImmutableSeq telescope = decl.telescope.map(param -> resolver.bind((Expr.Param)param, (MutableValue<Context>)mCtx));
        ExprResolver newResolver = resolver.enter((Context)mCtx.get());
        decl.modifyResult(newResolver);
        decl.telescope = telescope;
        StmtResolver.addReferences(info, (TyckOrder)new TyckOrder.Head(decl), resolver);
        return newResolver;
    }

    private static <RetTy extends Term> void insertGeneralizedVars(@NotNull TeleDecl<RetTy> decl, @NotNull ExprResolver resolver) {
        decl.telescope = decl.telescope.prependedAll((Iterable)resolver.allowedGeneralizes().valuesView());
    }

    public static void visitBind(@NotNull DefVar<?, ?> selfDef, @NotNull BindBlock bind, @NotNull ResolveInfo info) {
        AyaBinOpSet opSet = info.opSet();
        OpDecl self = selfDef.opDecl;
        if (self == null && bind != BindBlock.EMPTY) {
            opSet.reporter.report((Problem)new OperatorError.BadBindBlock(selfDef.concrete.sourcePos(), selfDef.name()));
            throw new Context.ResolvingInterruptedException();
        }
        StmtResolver.bind(bind, opSet, self);
    }

    private static void bind(@NotNull BindBlock bindBlock, AyaBinOpSet opSet, OpDecl self) {
        if (bindBlock == BindBlock.EMPTY) {
            return;
        }
        Context ctx = (Context)bindBlock.context().get();
        if (!1.$assertionsDisabled && ctx == null) {
            throw new AssertionError((Object)"no shallow resolver?");
        }
        bindBlock.resolvedLoosers().set((Object)bindBlock.loosers().map(looser -> StmtResolver.bind(self, opSet, ctx, OpDecl.BindPred.Looser, looser)));
        bindBlock.resolvedTighters().set((Object)bindBlock.tighters().map(tighter -> StmtResolver.bind(self, opSet, ctx, OpDecl.BindPred.Tighter, tighter)));
    }

    @NotNull
    private static DefVar<?, ?> bind(@NotNull OpDecl self, @NotNull AyaBinOpSet opSet, @NotNull Context ctx, @NotNull OpDecl.BindPred pred, @NotNull QualifiedID id) throws Context.ResolvingInterruptedException {
        DefVar defVar;
        OpDecl opDecl;
        AnyVar anyVar = ctx.get(id);
        if (anyVar instanceof DefVar && (opDecl = (defVar = (DefVar)anyVar).resolveOpDecl(ctx.modulePath())) != null) {
            opSet.bind(self, pred, opDecl, id.sourcePos());
            return defVar;
        }
        throw StmtResolver.resolvingInterrupt(opSet.reporter, new NameProblem.OperatorNameNotFound(id.sourcePos(), id.join()));
    }

    public static void resolveBind(@NotNull @NotNull SeqLike<@NotNull Stmt> contents, @NotNull ResolveInfo info) {
        contents.forEach(s -> StmtResolver.resolveBind(s, info));
        info.opRename().forEach((k, v) -> {
            if (v.component2() == BindBlock.EMPTY) {
                return;
            }
            StmtResolver.bind((BindBlock)v.component2(), info.opSet(), (OpDecl)v.component1());
        });
    }

    public static void resolveBind(@NotNull Stmt stmt, @NotNull ResolveInfo info) {
        Stmt stmt2 = stmt;
        Objects.requireNonNull(stmt2);
        Stmt stmt3 = stmt2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Command.Module.class, ClassDecl.class, TeleDecl.DataDecl.class, TeleDecl.DataCtor.class, TeleDecl.ClassMember.class, TeleDecl.FnDecl.class, TeleDecl.PrimDecl.class, Command.class, Generalize.class}, (Object)stmt3, n)) {
            default: {
                throw new RuntimeException(null, null);
            }
            case 0: {
                Command.Module mod = (Command.Module)stmt3;
                StmtResolver.resolveBind(mod.contents(), info);
                break;
            }
            case 1: {
                ClassDecl decl = (ClassDecl)stmt3;
                decl.members.forEach(field -> StmtResolver.resolveBind(field, info));
                StmtResolver.visitBind(decl.ref, decl.bindBlock(), info);
                break;
            }
            case 2: {
                TeleDecl.DataDecl decl = (TeleDecl.DataDecl)stmt3;
                decl.body.forEach(ctor -> StmtResolver.resolveBind(ctor, info));
                StmtResolver.visitBind(decl.ref, decl.bindBlock(), info);
                break;
            }
            case 3: {
                TeleDecl.DataCtor ctor2 = (TeleDecl.DataCtor)stmt3;
                StmtResolver.visitBind(ctor2.ref, ctor2.bindBlock(), info);
                break;
            }
            case 4: {
                TeleDecl.ClassMember field2 = (TeleDecl.ClassMember)stmt3;
                StmtResolver.visitBind(field2.ref, field2.bindBlock(), info);
                break;
            }
            case 5: {
                TeleDecl.FnDecl decl = (TeleDecl.FnDecl)stmt3;
                StmtResolver.visitBind(decl.ref, decl.bindBlock(), info);
                break;
            }
            case 6: {
                TeleDecl.PrimDecl decl = (TeleDecl.PrimDecl)stmt3;
                break;
            }
            case 7: {
                Command cmd = (Command)stmt3;
                break;
            }
            case 8: {
                Generalize generalize = (Generalize)stmt3;
            }
        }
    }

    @Contract(value="_, _ -> fail")
    public static Context.ResolvingInterruptedException resolvingInterrupt(Reporter reporter, Problem problem) {
        reporter.report(problem);
        throw new Context.ResolvingInterruptedException();
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

