/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import kala.collection.Seq;
import kala.collection.SeqLike;
import kala.collection.immutable.ImmutableArray;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableArrayList;
import kala.collection.mutable.MutableList;
import kala.control.Either;
import kala.control.Option;
import org.aya.concrete.Expr;
import org.aya.concrete.Pattern;
import org.aya.concrete.stmt.decl.ClassDecl;
import org.aya.concrete.stmt.decl.Decl;
import org.aya.concrete.stmt.decl.TeleDecl;
import org.aya.core.UntypedParam;
import org.aya.core.def.ClassDef;
import org.aya.core.def.CtorDef;
import org.aya.core.def.DataDef;
import org.aya.core.def.Def;
import org.aya.core.def.FnDef;
import org.aya.core.def.GenericDef;
import org.aya.core.def.MemberDef;
import org.aya.core.def.PrimDef;
import org.aya.core.pat.Pat;
import org.aya.core.term.DataCall;
import org.aya.core.term.PartialTerm;
import org.aya.core.term.PathTerm;
import org.aya.core.term.PiTerm;
import org.aya.core.term.SortTerm;
import org.aya.core.term.Term;
import org.aya.core.visitor.Subst;
import org.aya.core.visitor.Zonker;
import org.aya.generic.Modifier;
import org.aya.generic.ParamLike;
import org.aya.generic.util.NormalizeMode;
import org.aya.guest0x0.cubical.Partial;
import org.aya.ref.DefVar;
import org.aya.ref.LocalVar;
import org.aya.tyck.ExprTycker;
import org.aya.tyck.Result;
import org.aya.tyck.env.SeqLocalCtx;
import org.aya.tyck.error.CubicalError;
import org.aya.tyck.error.NobodyError;
import org.aya.tyck.error.PrimError;
import org.aya.tyck.error.UnifyError;
import org.aya.tyck.error.UnifyInfo;
import org.aya.tyck.pat.ClauseTycker;
import org.aya.tyck.pat.Conquer;
import org.aya.tyck.pat.PatClassifier;
import org.aya.tyck.pat.YouTrack;
import org.aya.tyck.trace.Trace;
import org.aya.tyck.tycker.TracedTycker;
import org.aya.util.Arg;
import org.aya.util.TreeBuilder;
import org.aya.util.error.SourcePos;
import org.aya.util.reporter.Problem;
import org.aya.util.reporter.Reporter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StmtTycker
extends TracedTycker {
    public StmtTycker(@NotNull Reporter reporter,  @Nullable Trace.Builder traceBuilder) {
        super(reporter, traceBuilder);
    }

    private <S extends Decl, D extends GenericDef> D traced(@NotNull S yeah, ExprTycker p, @NotNull BiFunction<S, ExprTycker, D> f) {
        return (D)this.traced(() -> new Trace.DeclT(yeah.ref(), yeah.sourcePos()), () -> p.subscoped(() -> (GenericDef)f.apply(yeah, p)));
    }

    @NotNull
    public GenericDef tyck(@NotNull Decl decl, @NotNull ExprTycker tycker) {
        return this.traced(decl, tycker, this::doTyck);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private GenericDef doTyck(@NotNull Decl predecl, @NotNull ExprTycker tycker) {
        GenericDef genericDef;
        if (predecl instanceof TeleDecl) {
            TeleDecl decl = (TeleDecl)predecl;
            if (decl.signature != null) {
                StmtTycker.loadTele(tycker, decl.signature);
            } else if (predecl.ref().core == null) {
                this.tyckHeader(predecl, tycker);
            }
        }
        Decl decl = predecl;
        Objects.requireNonNull(decl);
        Decl decl2 = decl;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TeleDecl.FnDecl.class, TeleDecl.DataDecl.class, TeleDecl.ClassMember.class, TeleDecl.PrimDecl.class, ClassDecl.class, TeleDecl.DataCtor.class}, (Object)decl2, n)) {
            default: {
                throw new RuntimeException(null, null);
            }
            case 0: {
                FnDef def;
                ClauseTycker.PatResult result;
                ImmutableSeq<Pattern.Clause> clauses;
                TeleDecl.FnDecl decl3 = (TeleDecl.FnDecl)decl2;
                Def.Signature signature = decl3.signature;
                assert (signature != null);
                BiFunction<Term, Either<Term, ImmutableSeq<Term.Matching>>, FnDef> factory = FnDef.factory((resultTy, body) -> new FnDef(decl.ref, signature.param(), (Term)resultTy, decl.modifiers, (Either<Term, ImmutableSeq<Term.Matching>>)body));
                TeleDecl.FnBody fnBody = decl3.body;
                Objects.requireNonNull(fnBody);
                TeleDecl.FnBody fnBody2 = fnBody;
                int n2 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TeleDecl.ExprBody.class, TeleDecl.BlockBody.class}, (Object)fnBody2, n2)) {
                    default: {
                        throw new RuntimeException(null, null);
                    }
                    case 0: {
                        Term nobody;
                        TeleDecl.ExprBody exprBody = (TeleDecl.ExprBody)fnBody2;
                        try {
                            Expr expr;
                            Expr body2 = expr = exprBody.expr();
                            nobody = tycker.inherit(body2, (Term)signature.result()).wellTyped();
                        }
                        catch (Throwable throwable) {
                            throw new RuntimeException(throwable.toString(), throwable);
                        }
                        Term resultTy2 = tycker.zonk((Term)signature.result());
                        genericDef = factory.apply(resultTy2, (Either<Term, ImmutableSeq<Term.Matching>>)Either.left((Object)tycker.zonk(nobody)));
                        return genericDef;
                    }
                    case 1: 
                }
                TeleDecl.BlockBody blockBody = (TeleDecl.BlockBody)fnBody2;
                {
                    ImmutableSeq<Pattern.Clause> immutableSeq;
                    clauses = immutableSeq = blockBody.clauses();
                }
                ExprTycker exprTycker = this.newTycker(tycker.state.primFactory(), tycker.shapeFactory);
                SourcePos pos = decl3.sourcePos();
                boolean orderIndependent = decl3.modifiers.contains((Object)Modifier.Overlap);
                if (orderIndependent) {
                    result = ClauseTycker.elabClausesDirectly(exprTycker, clauses, signature);
                    def = factory.apply(result.result(), (Either<Term, ImmutableSeq<Term.Matching>>)Either.right(result.matchings()));
                    if (!result.hasLhsError()) {
                        this.tracing(builder -> builder.shift(new Trace.LabelT(pos, "confluence check")));
                        YouTrack confluence = new YouTrack(signature.param(), tycker, pos);
                        confluence.check(result, PatClassifier.classify(result.clauses(), signature.param(), tycker, pos));
                        this.tracing(TreeBuilder::reduce);
                    }
                } else {
                    result = ClauseTycker.elabClausesClassified(exprTycker, clauses, signature, pos);
                    def = factory.apply(result.result(), (Either<Term, ImmutableSeq<Term.Matching>>)Either.right(result.matchings()));
                }
                if (!result.hasLhsError()) {
                    Conquer.against(def, orderIndependent, tycker, pos);
                }
                genericDef = def;
                return genericDef;
            }
            case 1: {
                TeleDecl.DataDecl decl4 = (TeleDecl.DataDecl)decl2;
                Def.Signature signature = decl4.signature;
                assert (signature != null);
                ImmutableSeq body3 = decl4.body.map(clause -> (CtorDef)this.tyck((Decl)clause, tycker));
                genericDef = new DataDef(decl4.ref, signature.param(), (SortTerm)signature.result(), (ImmutableSeq<CtorDef>)body3);
                return genericDef;
            }
            case 2: {
                TeleDecl.ClassMember member = (TeleDecl.ClassMember)decl2;
                if (member.ref.core != null) {
                    genericDef = (MemberDef)member.ref.core;
                    return genericDef;
                }
                Def.Signature signature = member.signature;
                assert (signature != null);
                DefVar<ClassDef, ClassDecl> classDef = member.classDef;
                Object result = signature.result();
                genericDef = new MemberDef(member.ref, classDef, signature.param(), (Term)result, member.coerce);
                return genericDef;
            }
            case 3: {
                TeleDecl.PrimDecl decl5 = (TeleDecl.PrimDecl)decl2;
                genericDef = (PrimDef)decl5.ref.core;
                return genericDef;
            }
            case 4: {
                ClassDecl decl6 = (ClassDecl)decl2;
                genericDef = (ClassDef)decl6.ref.core;
                return genericDef;
            }
            case 5: 
        }
        TeleDecl.DataCtor ctor = (TeleDecl.DataCtor)decl2;
        genericDef = (CtorDef)ctor.ref.core;
        return genericDef;
    }

    @NotNull
    public FnDef simpleFn(@NotNull ExprTycker tycker, TeleDecl.FnDecl fn, Expr expr) {
        return this.traced(fn, tycker, (f, t) -> this.doSimpleFn((TeleDecl.FnDecl)f, (ExprTycker)t, expr));
    }

    @NotNull
    private FnDef doSimpleFn(TeleDecl.FnDecl fn, @NotNull ExprTycker tycker, Expr expr) {
        record Tmp(ImmutableSeq<TeleResult> okTele, Term preresult, Term prebody) {
        }
        Tmp tmp = tycker.subscoped(() -> {
            Term prebody;
            Term preresult;
            ImmutableSeq<TeleResult> okTele = this.checkTele(tycker, (ImmutableSeq<Expr.Param>)fn.telescope, null);
            if (fn.result != null) {
                preresult = tycker.ty(fn.result);
                prebody = tycker.inherit(expr, preresult).wellTyped();
            } else {
                Result synthesize = tycker.synthesize(expr);
                prebody = synthesize.wellTyped();
                preresult = synthesize.type();
            }
            return new Tmp(okTele, preresult, prebody);
        });
        ImmutableSeq<Term.Param> tele = this.zonkTele(tycker, tmp.okTele);
        Term result = tycker.zonk(tmp.preresult);
        fn.signature = new Def.Signature<Term>(tele, result);
        Term body = tycker.zonk(tmp.prebody);
        return new FnDef(fn.ref, fn.signature.param(), (Term)fn.signature.result(), fn.modifiers, (Either<Term, ImmutableSeq<Term.Matching>>)Either.left((Object)body));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void tyckHeader(@NotNull Decl decl, @NotNull ExprTycker tycker) {
        this.tracing(builder -> builder.shift(new Trace.LabelT(decl.sourcePos(), "telescope of " + decl.ref().name())));
        Decl decl2 = decl;
        Objects.requireNonNull(decl2);
        Decl decl3 = decl2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ClassDecl.class, TeleDecl.FnDecl.class, TeleDecl.DataDecl.class, TeleDecl.PrimDecl.class, TeleDecl.DataCtor.class, TeleDecl.ClassMember.class}, (Object)decl3, n)) {
            default: {
                throw new RuntimeException(null, null);
            }
            case 0: {
                ClassDecl clazz = (ClassDecl)decl3;
                ImmutableSeq body = clazz.members.map(field -> (MemberDef)this.tyck((Decl)field, tycker));
                new ClassDef(clazz.ref, (ImmutableSeq<MemberDef>)body);
                break;
            }
            case 1: {
                ImmutableSeq<Pattern.Clause> cls;
                TeleDecl.FnBody fnBody;
                Object tele;
                TeleDecl.FnDecl fn = (TeleDecl.FnDecl)decl3;
                ImmutableArray resultTele = this.tele(tycker, (ImmutableSeq<Expr.Param>)fn.telescope, null);
                if (fn.result == null) {
                    fn.result = new Expr.Hole(fn.sourcePos(), false, null);
                }
                Term resultRes = tycker.ty(fn.result).freezeHoles(tycker.state);
                if (fn.body instanceof TeleDecl.BlockBody) {
                    tele = MutableArrayList.from(resultTele);
                    resultRes = PiTerm.unpi(tycker.zonk(resultRes), tycker::whnf, (MutableList<Term.Param>)tele);
                    resultTele = tele.toImmutableArray();
                }
                fn.signature = new Def.Signature<Term>((ImmutableSeq<Term.Param>)resultTele, resultRes);
                if (!resultTele.isEmpty() || !((fnBody = fn.body) instanceof TeleDecl.BlockBody)) break;
                tele = (TeleDecl.BlockBody)fnBody;
                try {
                    ImmutableSeq<Pattern.Clause> immutableSeq;
                    cls = immutableSeq = ((TeleDecl.BlockBody)tele).clauses();
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable.toString(), throwable);
                }
                if (!cls.isEmpty()) break;
                this.reporter.report((Problem)new NobodyError(decl.sourcePos(), fn.ref));
                break;
            }
            case 2: {
                TeleDecl.DataDecl data = (TeleDecl.DataDecl)decl3;
                ImmutableSeq<Term.Param> tele = this.tele(tycker, (ImmutableSeq<Expr.Param>)data.telescope, null);
                SortTerm resultTy = this.resultTy(tycker, data);
                data.signature = new Def.Signature<SortTerm>(tele, resultTy);
                break;
            }
            case 3: {
                TeleDecl.PrimDecl prim = (TeleDecl.PrimDecl)decl3;
                assert (tycker.ctx.isEmpty());
                PrimDef core = (PrimDef)prim.ref.core;
                ImmutableSeq<Term.Param> tele = this.tele(tycker, (ImmutableSeq<Expr.Param>)prim.telescope, null);
                if (tele.isNotEmpty()) {
                    if (prim.result == null) {
                        this.reporter.report((Problem)new PrimError.NoResultType(prim));
                        return;
                    }
                    Term result = tycker.synthesize(prim.result).wellTyped();
                    tycker.unifyTyReported(PiTerm.make(tele, result), PiTerm.make((SeqLike<Term.Param>)core.telescope, core.result), prim.result);
                    prim.signature = new Def.Signature<Term>(tele, result);
                } else if (prim.result != null) {
                    Term result = tycker.synthesize(prim.result).wellTyped();
                    tycker.unifyTyReported(result, core.result, prim.result);
                } else {
                    prim.signature = new Def.Signature<Term>((ImmutableSeq<Term.Param>)core.telescope, core.result);
                }
                tycker.solveMetas();
                tycker.ctx = new SeqLocalCtx();
                break;
            }
            case 4: {
                TeleDecl.DataCtor ctor = (TeleDecl.DataCtor)decl3;
                this.checkCtor(tycker, ctor);
                break;
            }
            case 5: {
                TeleDecl.ClassMember member = (TeleDecl.ClassMember)decl3;
                if (member.signature != null) break;
                ImmutableSeq<Term.Param> tele = this.tele(tycker, (ImmutableSeq<Expr.Param>)member.telescope, null);
                assert (member.result != null);
                Term result = tycker.zonk(tycker.ty(member.result));
                member.signature = new Def.Signature<Term>(tele, result);
            }
        }
        this.tracing(TreeBuilder::reduce);
    }

    private void checkCtor(@NotNull ExprTycker tycker, TeleDecl.DataCtor ctor) {
        ImmutableSeq<Term.Param> patternTele;
        if (ctor.ref.core != null) {
            return;
        }
        DefVar<DataDef, TeleDecl.DataDecl> dataRef = ctor.dataRef;
        TeleDecl.DataDecl dataConcrete = (TeleDecl.DataDecl)dataRef.concrete;
        Def.Signature dataSig = dataConcrete.signature;
        assert (dataSig != null);
        StmtTycker.loadTele(tycker, dataSig);
        ImmutableSeq dataArgs = dataSig.param().map(UntypedParam::toArg);
        DataCall predataCall = new DataCall(dataRef, 0, (ImmutableSeq<Arg<Term>>)dataArgs);
        ImmutableSeq<Arg<Pat>> pat = ImmutableSeq.empty();
        if (ctor.patterns.isNotEmpty()) {
            Def.Signature<DataCall> sig = new Def.Signature<DataCall>(dataSig.param(), predataCall);
            ClauseTycker.LhsResult lhs = ClauseTycker.checkLhs(tycker, new Pattern.Clause(ctor.sourcePos(), ctor.patterns, (Option<Expr>)Option.none()), sig, false);
            pat = lhs.preclause().patterns();
            tycker.ctx = lhs.gamma();
            tycker.definitionEqualities = lhs.bodySubst();
            predataCall = (DataCall)predataCall.subst(new Subst((SeqLike<LocalVar>)dataSig.param().view().map(Term.Param::ref), (SeqLike<? extends Term>)pat.view().map(Arg::term).map(Pat::toTerm)));
        }
        DataCall dataCall = predataCall;
        SortTerm ulift = (SortTerm)dataConcrete.signature.result();
        ImmutableSeq tele = this.tele(tycker, (ImmutableSeq<Expr.Param>)ctor.telescope, ulift);
        Partial<Term> elabClauses = tycker.zonk(tycker.elaboratePartial(ctor.clauses, dataCall));
        if (ctor.result != null) {
            Term result = tycker.ty(ctor.result).normalize(tycker.state, NormalizeMode.NF);
            MutableArrayList additionalTele = MutableArrayList.create();
            result = PiTerm.unpi(result, tycker::whnf, (MutableList<Term.Param>)additionalTele);
            Partial partial = null;
            if (result instanceof PathTerm) {
                PathTerm path = (PathTerm)result;
                PathTerm flat = path.flatten();
                additionalTele.appendAll(flat.computeParams());
                partial = flat.partial();
                result = flat.type();
            }
            Term eventually = result;
            tycker.unifyTyReported(dataCall, eventually, ctor.result, u -> new UnifyError.ConReturn(ctor, (UnifyInfo.Comparison)u, new UnifyInfo(tycker.state)));
            tycker.solveMetas();
            Zonker zonker = Zonker.make(tycker);
            if (partial != null) {
                partial = partial.map((Function)zonker);
            }
            tele = tele.view().concat((SeqLike)additionalTele).map(p -> p.descent(zonker)).toImmutableSeq();
            elabClauses = PartialTerm.merge((Seq<Partial<Term>>)Seq.of(elabClauses, (Object)partial).filterNotNull());
        }
        ImmutableSeq<Term.Param> immutableSeq = patternTele = pat.isEmpty() ? dataSig.param().map(Term.Param::implicitify) : Pat.extractTele((SeqLike<Pat>)pat.map(Arg::term));
        while (true) {
            if (elabClauses instanceof Partial.Split) break;
            this.reporter.report((Problem)new CubicalError.PathConDominateError(ctor.clauses.sourcePos()));
            elabClauses = PartialTerm.DUMMY_SPLIT;
        }
        Partial.Split split = (Partial.Split)elabClauses;
        dataConcrete.checkedBody.append((Object)new CtorDef(dataRef, ctor.ref, pat, patternTele, tele, (Partial.Split<Term>)split, dataCall, ctor.coerce));
    }

    private static void loadTele(@NotNull ExprTycker tycker, Def.Signature<?> dataSig) {
        dataSig.param().forEach(tycker.ctx::put);
    }

    private SortTerm resultTy(@NotNull ExprTycker tycker, TeleDecl<SortTerm> data) {
        if (data.result != null) {
            Result.Sort result = tycker.sort(data.result);
            return (SortTerm)tycker.zonk(result.wellTyped());
        }
        return SortTerm.Type0;
    }

    @NotNull
    private ImmutableSeq<Term.Param> tele(@NotNull ExprTycker tycker, @NotNull ImmutableSeq<Expr.Param> tele, @Nullable SortTerm sort) {
        ImmutableSeq okTele = tycker.subscoped(() -> this.checkTele(tycker, tele, sort));
        return this.zonkTele(tycker, (ImmutableSeq<TeleResult>)okTele);
    }

    @NotNull
    private Term checkTele(@NotNull ExprTycker exprTycker, @NotNull Expr tele, @NotNull SortTerm sort) {
        Term result = exprTycker.ty(tele);
        if (!exprTycker.synthesizer().inheritPiDom(result, sort)) {
            this.reporter.report((Problem)new UnifyError.PiDom(tele, result, sort));
        }
        return result;
    }

    @NotNull
    private ImmutableSeq<TeleResult> checkTele(@NotNull ExprTycker exprTycker, @NotNull ImmutableSeq<Expr.Param> tele, @Nullable SortTerm sort) {
        return tele.map(param -> {
            Term paramTyped = sort != null ? this.checkTele(exprTycker, param.type(), sort) : exprTycker.ty(param.type());
            Term.Param newParam = new Term.Param((ParamLike<?>)param, paramTyped);
            exprTycker.ctx.put(newParam);
            exprTycker.addWithTerm((Expr.Param)param, paramTyped);
            return new TeleResult(newParam, param.sourcePos());
        });
    }

    @NotNull
    private ImmutableSeq<Term.Param> zonkTele(@NotNull ExprTycker exprTycker, ImmutableSeq<TeleResult> okTele) {
        exprTycker.solveMetas();
        Zonker zonker = Zonker.make(exprTycker);
        return okTele.map(tt -> {
            Term.Param rawParam = tt.param;
            Term.Param param = new Term.Param(rawParam, zonker.apply(rawParam.type()));
            exprTycker.ctx.put(param);
            return param;
        });
    }

    private record TeleResult(@NotNull Term.Param param, @NotNull SourcePos pos) {
    }
}

