/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.env;

import java.lang.runtime.SwitchBootstraps;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import kala.collection.Seq;
import kala.collection.SeqLike;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableLinkedHashMap;
import kala.collection.mutable.MutableList;
import kala.collection.mutable.MutableMap;
import kala.tuple.Tuple;
import kala.tuple.Tuple2;
import org.aya.core.UntypedParam;
import org.aya.core.meta.Meta;
import org.aya.core.term.IntervalTerm;
import org.aya.core.term.LamTerm;
import org.aya.core.term.MetaTerm;
import org.aya.core.term.Term;
import org.aya.core.visitor.VarConsumer;
import org.aya.ref.AnyVar;
import org.aya.ref.LocalVar;
import org.aya.tyck.env.MapLocalCtx;
import org.aya.tyck.env.SeqLocalCtx;
import org.aya.tyck.tycker.TyckState;
import org.aya.util.Arg;
import org.aya.util.error.InternalException;
import org.aya.util.error.SourcePos;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Debug;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Debug.Renderer(hasChildren="true", childrenArray="extract().toArray()")
public interface LocalCtx {
    @NotNull
    default public Tuple2<MetaTerm, Term> freshHole(@NotNull Term type, @NotNull SourcePos sourcePos) {
        return this.freshHole(type, "_", sourcePos);
    }

    @NotNull
    default public Tuple2<MetaTerm, Term> freshHole(@NotNull Term type, @NotNull String name, @NotNull SourcePos sourcePos) {
        ImmutableSeq<Term.Param> ctxTele = this.extract();
        Meta meta = Meta.from(ctxTele, name, type, sourcePos);
        ImmutableSeq view = meta.telescope.map(LamTerm::param);
        MetaTerm hole = new MetaTerm(meta, (ImmutableSeq<Arg<Term>>)ctxTele.map(UntypedParam::toArg), (ImmutableSeq<Arg<Term>>)view.map(UntypedParam::toArg));
        return Tuple.of((Object)hole, (Object)LamTerm.make((SeqLike<LamTerm.Param>)view, hole));
    }

    @NotNull
    default public Tuple2<MetaTerm, Term> freshTyHole(@NotNull String name, @NotNull SourcePos sourcePos) {
        ImmutableSeq<Term.Param> ctxTele = this.extract();
        Meta meta = Meta.from(ctxTele, name, sourcePos);
        ImmutableSeq view = meta.telescope.map(LamTerm::param);
        MetaTerm hole = new MetaTerm(meta, (ImmutableSeq<Arg<Term>>)ctxTele.map(UntypedParam::toArg), (ImmutableSeq<Arg<Term>>)view.map(UntypedParam::toArg));
        return Tuple.of((Object)hole, (Object)LamTerm.make((SeqLike<LamTerm.Param>)view, hole));
    }

    default public <T> T with(@NotNull Term.Param param, @NotNull Supplier<T> action) {
        return this.with(param.ref(), param.type(), action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <T> T with(@NotNull Seq<Term.Param> params, @NotNull Supplier<T> action) {
        if (params.isEmpty()) {
            return action.get();
        }
        params.forEach(x -> this.put(x.ref(), x.type()));
        try {
            T t = action.get();
            return t;
        }
        finally {
            this.remove((SeqView<LocalVar>)params.view().map(Term.Param::ref));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <T> T withIntervals(@NotNull SeqView<LocalVar> params, @NotNull Supplier<T> action) {
        if (params.isEmpty()) {
            return action.get();
        }
        params.forEach(x -> this.put((LocalVar)x, IntervalTerm.INSTANCE));
        try {
            T t = action.get();
            return t;
        }
        finally {
            this.remove(params);
        }
    }

    public void remove(@NotNull SeqView<LocalVar> var1);

    default public void forward(final @NotNull LocalCtx dest, @NotNull Term term, final @NotNull TyckState state) {
        new VarConsumer.Scoped(){

            @Override
            public void var(@NotNull AnyVar var) {
                if (this.bound.contains((Object)var)) {
                    return;
                }
                AnyVar anyVar = var;
                Objects.requireNonNull(anyVar);
                AnyVar anyVar2 = anyVar;
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LocalVar.class, Meta.class}, (Object)anyVar2, n)) {
                    case 0: {
                        LocalVar localVar = (LocalVar)anyVar2;
                        dest.putUnchecked(localVar, LocalCtx.this.get(localVar));
                        break;
                    }
                    case 1: {
                        Meta meta = (Meta)anyVar2;
                        Term sol = (Term)state.metas().getOrNull((Object)meta);
                        if (sol == null) break;
                        LocalCtx.this.forward(dest, sol, state);
                        break;
                    }
                }
            }
        }.accept(term);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <T> T with(@NotNull LocalVar var, @NotNull Term type, @NotNull Supplier<T> action) {
        this.put(var, type);
        try {
            T t = action.get();
            return t;
        }
        finally {
            this.remove((SeqView<LocalVar>)SeqView.of((Object)var));
        }
    }

    default public <T> T with(@NotNull Supplier<T> action, Term.Param ... param) {
        return this.with(action, (SeqView<Term.Param>)Seq.of((Object[])param).view());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <T> T with(@NotNull Supplier<T> action, @NotNull SeqView<Term.Param> param) {
        for (Term.Param p : param) {
            this.put(p);
        }
        try {
            Iterator<Object> iterator = action.get();
            return (T)iterator;
        }
        finally {
            this.remove((SeqView<LocalVar>)param.map(Term.Param::ref));
        }
    }

    @NotNull
    default public ImmutableSeq<Term.Param> extract() {
        MutableList ctx = MutableList.create();
        for (LocalCtx map = this; map != null; map = map.parent()) {
            map.extractToLocal((MutableList<Term.Param>)ctx);
        }
        return ctx.toImmutableSeq();
    }

    @Contract(mutates="param1")
    public void extractToLocal(@NotNull MutableList<Term.Param> var1);

    @Contract(pure=true)
    @NotNull
    default public Term get(@NotNull LocalVar var) {
        Term res = this.getUnchecked(var);
        if (res != null) {
            return res;
        }
        throw new InternalException(var.name());
    }

    @Contract(pure=true)
    @Nullable
    default public Term getUnchecked(@NotNull LocalVar var) {
        for (LocalCtx ctx = this; ctx != null; ctx = ctx.parent()) {
            Term res = ctx.getLocal(var);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    @Contract(pure=true)
    default public boolean contains(@NotNull LocalVar var) {
        return this.getUnchecked(var) != null;
    }

    @Contract(pure=true)
    @Nullable
    public Term getLocal(@NotNull LocalVar var1);

    default public void put(@NotNull Term.Param param) {
        this.put(param.ref(), param.type());
    }

    default public void put(@NotNull LocalVar var, @NotNull Term term) {
        if (var != LocalVar.IGNORED) {
            this.putUnchecked(var, term);
        }
    }

    public void putUnchecked(@NotNull LocalVar var1, @NotNull Term var2);

    default public boolean isEmpty() {
        if (this.isMeEmpty()) {
            LocalCtx parent = this.parent();
            return parent == null || parent.isEmpty();
        }
        return false;
    }

    public boolean isMeEmpty();

    @Contract(value=" -> new")
    @NotNull
    default public MapLocalCtx deriveMap() {
        return new MapLocalCtx((MutableMap<LocalVar, Term>)MutableLinkedHashMap.of(), this);
    }

    @Contract(value=" -> new")
    @NotNull
    default public SeqLocalCtx deriveSeq() {
        return new SeqLocalCtx((MutableList<SeqLocalCtx.P>)MutableList.create(), this);
    }

    @Nullable
    public LocalCtx parent();

    @Contract(mutates="this")
    public void modifyMyTerms(@NotNull UnaryOperator<Term> var1);
}

