/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.error;

import kala.collection.SeqLike;
import kala.collection.immutable.ImmutableSeq;
import org.aya.concrete.Expr;
import org.aya.core.def.MemberDef;
import org.aya.prettier.BasePrettier;
import org.aya.pretty.doc.Doc;
import org.aya.ref.AnyVar;
import org.aya.ref.DefVar;
import org.aya.tyck.error.TyckError;
import org.aya.util.error.SourcePos;
import org.aya.util.prettier.PrettierOptions;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface FieldError
extends TyckError {

    public record ArgMismatch(@NotNull SourcePos sourcePos, @NotNull MemberDef memberDef, int supplied) implements FieldError
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"Expected"), Doc.plain((String)String.valueOf(((MemberDef)this.memberDef.ref.core).telescope.size())), Doc.english((String)"arguments, but found"), Doc.plain((String)String.valueOf(this.supplied)), Doc.english((String)"arguments for field"), BasePrettier.linkRef(this.memberDef.ref, BasePrettier.MEMBER)});
        }
    }

    public record UnknownField(@NotNull SourcePos sourcePos, @NotNull String name) implements FieldError
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"Unknown field"), Doc.code((String)this.name), Doc.english((String)"projected")});
        }
    }

    public record NoSuchField(@NotNull DefVar<?, ?> classRef, @NotNull Expr.Field<Expr> member) implements FieldError
    {
        @NotNull
        public SourcePos sourcePos() {
            return this.member.name().sourcePos();
        }

        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"The member"), Doc.code((String)((String)this.member.name().data())), Doc.english((String)"does not exist in class"), Doc.code((String)this.classRef.name())});
        }
    }

    public record MissingField(@NotNull SourcePos sourcePos, @NotNull ImmutableSeq<AnyVar> missing) implements FieldError
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"Missing field(s):"), Doc.commaList((SeqLike)this.missing.view().map(BasePrettier::varDoc).map(Doc::code))});
        }
    }
}

