/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.error;

import kala.collection.Seq;
import kala.collection.SeqLike;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import org.aya.core.term.MetaTerm;
import org.aya.core.term.Term;
import org.aya.prettier.BasePrettier;
import org.aya.pretty.doc.Doc;
import org.aya.ref.LocalVar;
import org.aya.tyck.error.UnifyInfo;
import org.aya.tyck.tycker.TyckState;
import org.aya.util.error.SourcePos;
import org.aya.util.error.WithPos;
import org.aya.util.prettier.PrettierOptions;
import org.aya.util.reporter.Problem;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface HoleProblem
extends Problem {
    @NotNull
    public MetaTerm term();

    @NotNull
    default public Problem.Severity level() {
        return Problem.Severity.ERROR;
    }

    @NotNull
    default public SourcePos sourcePos() {
        return this.term().ref().sourcePos;
    }

    public record CannotFindGeneralSolution(@NotNull ImmutableSeq<TyckState.Eqn> eqns) implements Problem
    {
        @NotNull
        public SourcePos sourcePos() {
            return ((TyckState.Eqn)this.eqns.getLast()).pos();
        }

        @NotNull
        public SeqView<WithPos<Doc>> inlineHints(@NotNull PrettierOptions options) {
            return this.eqns.view().map(eqn -> new WithPos(eqn.pos(), (Object)eqn.toDoc(options)));
        }

        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.english((String)"Solving equation(s) with not very general solution(s)");
        }

        @NotNull
        public Problem.Severity level() {
            return Problem.Severity.INFO;
        }
    }

    public record RecursionError(@NotNull MetaTerm term, @NotNull Term sol) implements HoleProblem
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.vcat((Doc[])new Doc[]{Doc.sep((Doc[])new Doc[]{Doc.english((String)"Trying to solve hole"), Doc.code((Doc)BasePrettier.linkDef(this.term.ref())), Doc.plain((String)"as")}), Doc.par((int)1, (Doc)this.sol.toDoc(options)), Doc.english((String)"which is recursive")});
        }
    }

    public record BadlyScopedError(@NotNull MetaTerm term, @NotNull Term solved, @NotNull Seq<LocalVar> scopeCheck) implements HoleProblem
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.vcat((Doc[])new Doc[]{Doc.english((String)"The solution"), Doc.par((int)1, (Doc)this.solved.toDoc(options)), Doc.plain((String)"is not well-scoped"), Doc.cat((Doc[])new Doc[]{Doc.english((String)"In particular, these variables are not in scope:"), Doc.ONE_WS, Doc.commaList((SeqLike)this.scopeCheck.view().map(BasePrettier::varDoc).map(Doc::code))})});
        }
    }

    public record IllTypedError(@NotNull MetaTerm term, @NotNull TyckState state, @NotNull Term solution) implements HoleProblem
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            MutableList list = MutableList.of((Object)Doc.english((String)"The meta (denoted ? below) is supposed to satisfy:"), (Object)Doc.par((int)1, (Doc)this.term.ref().info.toDoc(options)), (Object)Doc.english((String)"However, the solution below does not seem so:"));
            UnifyInfo.exprInfo(this.solution, options, this.state, (MutableList<Doc>)list);
            return Doc.vcat((SeqLike)list);
        }
    }

    public record BadSpineError(@NotNull MetaTerm term) implements HoleProblem
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.vcat((Doc[])new Doc[]{Doc.english((String)"Can't perform pattern unification on hole with the following spine:"), BasePrettier.argsDoc(options, this.term.args())});
        }
    }
}

