/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.pat;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.control.Option;
import kala.value.MutableValue;
import org.aya.concrete.Expr;
import org.aya.concrete.Pattern;
import org.aya.concrete.visitor.PatternConsumer;
import org.aya.core.def.Def;
import org.aya.core.pat.Pat;
import org.aya.core.term.ErrorTerm;
import org.aya.core.term.MetaPatTerm;
import org.aya.core.term.Term;
import org.aya.core.visitor.EndoTerm;
import org.aya.generic.AyaDocile;
import org.aya.tyck.ExprTycker;
import org.aya.tyck.env.LocalCtx;
import org.aya.tyck.pat.PatClassifier;
import org.aya.tyck.pat.PatternProblem;
import org.aya.tyck.pat.PatternTycker;
import org.aya.tyck.pat.TypedSubst;
import org.aya.tyck.trace.Trace;
import org.aya.util.Arg;
import org.aya.util.error.SourcePos;
import org.aya.util.reporter.Problem;
import org.aya.util.tyck.pat.PatClass;
import org.jetbrains.annotations.NotNull;

public final class ClauseTycker {
    public static final EndoTerm META_PAT_INLINER = new EndoTerm(){

        @Override
        @NotNull
        public Term post(@NotNull Term term) {
            Term term2;
            if (term instanceof MetaPatTerm) {
                MetaPatTerm metaPat = (MetaPatTerm)term;
                term2 = metaPat.inline(this);
            } else {
                term2 = term;
            }
            return term2;
        }
    };

    @NotNull
    public static PatResult elabClausesDirectly(@NotNull ExprTycker exprTycker, @NotNull @NotNull ImmutableSeq<@NotNull Pattern.Clause> clauses, @NotNull Def.Signature<?> signature) {
        return ClauseTycker.checkAllRhs(exprTycker, ClauseTycker.checkAllLhs(exprTycker, clauses, signature), signature.result());
    }

    @NotNull
    public static PatResult elabClausesClassified(@NotNull ExprTycker exprTycker, @NotNull @NotNull ImmutableSeq<@NotNull Pattern.Clause> clauses, @NotNull Def.Signature<?> signature, @NotNull SourcePos overallPos) {
        AllLhsResult lhsResults = ClauseTycker.checkAllLhs(exprTycker, clauses, signature);
        if (!lhsResults.hasError()) {
            ImmutableSeq<PatClass<ImmutableSeq<Arg<Term>>>> classes = PatClassifier.classify(lhsResults.lhsResult().view().map(LhsResult::preclause), signature.param(), exprTycker, overallPos);
            if (clauses.isNotEmpty()) {
                int[] nArray = PatClassifier.firstMatchDomination(clauses, exprTycker.reporter, classes);
            }
        }
        return ClauseTycker.checkAllRhs(exprTycker, lhsResults, signature.result());
    }

    @NotNull
    private static AllLhsResult checkAllLhs(@NotNull ExprTycker exprTycker, @NotNull @NotNull ImmutableSeq<@NotNull Pattern.Clause> clauses, @NotNull Def.Signature<?> signature) {
        return new AllLhsResult((ImmutableSeq<LhsResult>)clauses.mapIndexed((index, clause) -> exprTycker.traced(() -> new Trace.LabelT(clause.sourcePos, "lhs of clause " + (1 + index)), () -> ClauseTycker.checkLhs(exprTycker, clause, signature, true))));
    }

    @NotNull
    private static PatResult checkAllRhs(@NotNull ExprTycker exprTycker, @NotNull AllLhsResult lhsResult, @NotNull Term result) {
        ImmutableSeq<LhsResult> clauses = lhsResult.lhsResult();
        ImmutableSeq res = clauses.mapIndexed((index, lhs) -> exprTycker.traced(() -> new Trace.LabelT(lhs.preclause.sourcePos(), "rhs of clause " + (1 + index)), () -> ClauseTycker.checkRhs(exprTycker, lhs)));
        ImmutableSeq preclauses = res.map(c -> new Pat.Preclause(c.sourcePos(), (ImmutableSeq<Arg<Pat>>)c.patterns().map(p -> p.descent(x -> x.zonk(exprTycker))), c.expr().map(exprTycker::zonk)));
        return new PatResult(exprTycker.zonk(result), (ImmutableSeq<Pat.Preclause<Term>>)preclauses, (ImmutableSeq<Term.Matching>)preclauses.flatMap(Pat.Preclause::lift), lhsResult.hasError());
    }

    @NotNull
    public static LhsResult checkLhs(@NotNull ExprTycker exprTycker, @NotNull Pattern.Clause match, @NotNull Def.Signature<?> signature, boolean isElim) {
        PatternTycker patTycker = new PatternTycker(exprTycker, signature, (SeqView<Arg<Pattern>>)match.patterns.view());
        return exprTycker.subscoped(() -> {
            if (isElim && !match.patterns.anyMatch(p -> ClauseTycker.hasAbsurdity((Pattern)p.term())) && match.expr.isEmpty()) {
                match.hasError = true;
                exprTycker.reporter.report((Problem)new PatternProblem.InvalidEmptyBody(match));
            }
            PatternTycker.TyckResult step0 = patTycker.tyck(null, (Expr)match.expr.getOrNull());
            match.hasError |= patTycker.hasError();
            ImmutableSeq patterns = step0.wellTyped().map(p -> p.descent(x -> x.inline(exprTycker.ctx)));
            ClauseTycker.inlineTypedSubst(patTycker.bodySubst);
            Term type = ClauseTycker.inlineTerm(step0.codomain());
            exprTycker.ctx.modifyMyTerms(META_PAT_INLINER);
            PatternConsumer consumer = new PatternConsumer(){

                @Override
                public void pre(@NotNull Pattern pat) {
                    Pattern pattern = pat;
                    Objects.requireNonNull(pattern);
                    Pattern pattern2 = pattern;
                    int n = 0;
                    MutableValue<Term> typeRef = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Pattern.Bind.class, Pattern.As.class}, (Object)pattern2, n)) {
                        case 0 -> {
                            Pattern.Bind bind = (Pattern.Bind)pattern2;
                            yield bind.type();
                        }
                        case 1 -> {
                            Pattern.As as = (Pattern.As)pattern2;
                            yield as.type();
                        }
                        default -> MutableValue.create();
                    };
                    typeRef.update(t -> t == null ? null : ClauseTycker.inlineTerm(t));
                    PatternConsumer.super.pre(pat);
                }
            };
            match.patterns.view().map(Arg::term).forEach((consumer)::accept);
            return new LhsResult(exprTycker.ctx, type, patTycker.bodySubst, patTycker.hasError(), new Pat.Preclause<Expr>(match.sourcePos, (ImmutableSeq<Arg<Pat>>)patterns, Option.ofNullable((Object)step0.newBody())));
        });
    }

    private static Pat.Preclause<Term> checkRhs(@NotNull ExprTycker exprTycker, @NotNull LhsResult lhsResult) {
        return exprTycker.subscoped(() -> {
            exprTycker.ctx = lhsResult.gamma;
            Option term = exprTycker.subscoped(() -> {
                exprTycker.definitionEqualities.addDirectly(lhsResult.bodySubst());
                return lhsResult.preclause.expr().map(e -> lhsResult.hasError ? new ErrorTerm((AyaDocile)e, false) : exprTycker.inherit((Expr)e, lhsResult.type).wellTyped());
            });
            return new Pat.Preclause(lhsResult.preclause.sourcePos(), lhsResult.preclause.patterns(), term);
        });
    }

    private static boolean hasAbsurdity(@NotNull Pattern pattern) {
        Pattern pattern2 = pattern;
        Objects.requireNonNull(pattern2);
        Pattern pattern3 = pattern2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Pattern.Absurd.class, Pattern.As.class, Pattern.BinOpSeq.class, Pattern.Ctor.class, Pattern.List.class, Pattern.Tuple.class}, (Object)pattern3, n)) {
            case 0 -> {
                Pattern.Absurd ignored = (Pattern.Absurd)pattern3;
                yield true;
            }
            case 1 -> {
                Pattern.As as = (Pattern.As)pattern3;
                yield ClauseTycker.hasAbsurdity(as.pattern());
            }
            case 2 -> {
                Pattern.BinOpSeq binOpSeq = (Pattern.BinOpSeq)pattern3;
                yield binOpSeq.seq().anyMatch(p -> ClauseTycker.hasAbsurdity((Pattern)p.term()));
            }
            case 3 -> {
                Pattern.Ctor ctor = (Pattern.Ctor)pattern3;
                yield ctor.params().anyMatch(p -> ClauseTycker.hasAbsurdity((Pattern)p.term()));
            }
            case 4 -> {
                Pattern.List list = (Pattern.List)pattern3;
                yield list.elements().anyMatch(ClauseTycker::hasAbsurdity);
            }
            case 5 -> {
                Pattern.Tuple tuple = (Pattern.Tuple)pattern3;
                yield tuple.patterns().anyMatch(p -> ClauseTycker.hasAbsurdity((Pattern)p.term()));
            }
            default -> false;
        };
    }

    @NotNull
    public static Term inlineTerm(@NotNull Term term) {
        return META_PAT_INLINER.apply(term);
    }

    @NotNull
    public static TypedSubst inlineTypedSubst(@NotNull TypedSubst tySubst) {
        tySubst.subst().map().replaceAll((var, term) -> ClauseTycker.inlineTerm(term));
        tySubst.type().replaceAll((var, term) -> ClauseTycker.inlineTerm(term));
        return tySubst;
    }

    public record AllLhsResult(@NotNull ImmutableSeq<LhsResult> lhsResult, boolean hasError) {
        public AllLhsResult(@NotNull ImmutableSeq<LhsResult> lhsResults) {
            this(lhsResults, lhsResults.anyMatch(LhsResult::hasError));
        }
    }

    public record PatResult(@NotNull Term result, @NotNull ImmutableSeq<Pat.Preclause<Term>> clauses, @NotNull ImmutableSeq<Term.Matching> matchings, boolean hasLhsError) {
    }

    public record LhsResult(@NotNull LocalCtx gamma, @NotNull Term type, @NotNull TypedSubst bodySubst, boolean hasError, @NotNull Pat.Preclause<Expr> preclause) {
    }
}

